/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common;

import com.taobao.middleware.logger.Level;
import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.TxcRole;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.util.string.ErrLogObj;
import org.apache.commons.lang.StringUtils;

public class LoggerWrap {
    public Logger[] loggers = new Logger[2];
    private String thisClassName = this.getClass().getName();

    private String getCaller() {
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            String nameString = stack[i].getClassName();
            if (nameString.equals(this.thisClassName)) continue;
            String[] names = nameString.split("\\.");
            return String.format("%s:%s:%d", names[names.length - 1], stack[i].getMethodName(), stack[i].getLineNumber());
        }
        return "";
    }

    public void Init(boolean isfile, String pid) {
        if (isfile) {
            this.loggers[0] = LoggerFactory.getLogger((String)"txc");
            this.loggers[0].activateAppenderWithSizeRolling("txc", "txc." + pid + ".log", "utf-8", "512MB", LoggerWrap.getMaxBackupIndex("txc", 20));
            this.loggers[1] = LoggerFactory.getLogger((String)"txc_error");
            this.loggers[1].activateAppenderWithSizeRolling("txc", "txc_error.log", "utf-8", "512MB", LoggerWrap.getMaxBackupIndex("txc_error", 10));
        } else {
            this.loggers[0] = LoggerFactory.getLogger((String)"txc");
            this.loggers[0].activateConsoleAppender("System.out", "utf-8");
        }
        this.loggers[0].setAdditivity(false);
        this.loggers[1].setAdditivity(false);
        this.loggers[0].setLevel(Level.INFO);
        this.loggers[1].setLevel(Level.WARN);
    }

    private static int getMaxBackupIndex(String logName, int defaultValue) {
        int index = defaultValue;
        String config = System.getProperty(logName + ".max.backup.index");
        if (!StringUtils.isEmpty((String)config)) {
            try {
                index = Integer.parseInt(config);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return index;
    }

    public void getDynamicLogLevel() {
        TxcConfigHolder.getInstance().getLoggerLevelDynamic(new IConfigCallback(){

            @Override
            public void callback(String content) {
                LoggerWrap.this.warn(String.format("log level set to: %s", content));
                Level level = TxcConfigHolder.convertLoggerLevel(content);
                LoggerWrap.this.loggers[0].setLevel(level);
                if (LoggerInit.loggerUnsupportSQL != null) {
                    LoggerInit.loggerUnsupportSQL.setLevel(level);
                }
            }
        });
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.loggers[0].debug(this.getCaller(), message);
        }
    }

    public void debug(String format, Object ... args) {
        if (this.isDebugEnabled()) {
            this.loggers[0].debug(this.getCaller(), format, args);
        }
    }

    public void info(String message) {
        if (this.isInfoEnabled()) {
            this.loggers[0].info(this.getCaller(), message);
        }
    }

    public void info(String format, Object ... args) {
        if (this.isInfoEnabled()) {
            this.loggers[0].info(this.getCaller(), format, args);
        }
    }

    public void warn(ErrLogObj errLogObj, String errorCode, String message) {
        if (this.isWarnEnabled()) {
            this.loggers[0].warn(this.getCaller(), message);
            if (this.loggers[1] != null) {
                if (errLogObj == null) {
                    errLogObj = new ErrLogObj();
                }
                errLogObj.type = "WARN";
                errLogObj.caller = this.getCaller();
                errLogObj.content = message;
                if (!StringUtils.isEmpty((String)errorCode)) {
                    errLogObj.errorCode = errorCode;
                }
                this.loggers[1].warn(errLogObj.toJsonStr());
            }
        }
    }

    public void warn(ErrLogObj errLogObj, String errorCode, String format, Object ... args) {
        this.warn(errLogObj, errorCode, String.format(format, args));
    }

    public void warn(ErrLogObj errLogObj, String message) {
        this.warn(errLogObj, null, message);
    }

    public void warn(String message) {
        this.warn((ErrLogObj)null, null, message);
    }

    public void warn(String errorCode, String message) {
        this.warn((ErrLogObj)null, errorCode, message);
    }

    public void warn(String format, Object ... args) {
        this.warn((ErrLogObj)null, null, format, args);
    }

    public void error(ErrLogObj errLogObj, String errorCode, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            this.loggers[0].error(this.getCaller(), errorCode, message, t);
            if (this.loggers[1] != null && TxcConstants.role.equals((Object)TxcRole.SERVER)) {
                if (errLogObj == null) {
                    errLogObj = new ErrLogObj();
                }
                errLogObj.type = "ERROR";
                errLogObj.content = message;
                errLogObj.caller = this.getCaller();
                errLogObj.trw = t;
                if (!StringUtils.isEmpty((String)errorCode)) {
                    errLogObj.errorCode = errorCode;
                }
                this.loggers[1].error("", errLogObj.toJsonStr());
            }
        }
    }

    public void error(TxcErrCode error, Throwable t) {
        this.error((ErrLogObj)null, error.errCode, error.errMessage, t);
    }

    public void error(String errorCode, String message) {
        this.error((ErrLogObj)null, errorCode, message, null);
    }

    public void error(String errorCode, String message, Throwable t) {
        this.error((ErrLogObj)null, errorCode, message, t);
    }

    public void error(String errorCode, String format, Object ... objs) {
        this.error((ErrLogObj)null, errorCode, format, objs, null);
    }

    public void error(ErrLogObj errLogObj, String errorCode, String format, Object ... objs) {
        this.error(errLogObj, errorCode, String.format(format, objs), null);
    }

    public void error(String msg, TxcErrCode err, Throwable t) {
        this.error((ErrLogObj)null, err.errCode, String.format("%s:%s:%s", msg, err.errMessage, err.errDispose), t);
    }

    public void monitor(String errorCode, String message) {
        if (this.isErrorEnabled()) {
            this.loggers[0].error(errorCode, message);
            this.loggers[1].error(errorCode, message);
        }
    }

    public void alarm(ErrLogObj errLogObj, String errorCode, String message) {
        if (this.isWarnEnabled()) {
            String msg = String.format("<<ALARM>> %s", message);
            this.loggers[0].warn(this.getCaller(), msg);
            if (this.loggers[1] != null) {
                if (errLogObj == null) {
                    errLogObj = new ErrLogObj();
                }
                errLogObj.type = "ALARM";
                errLogObj.content = message;
                errLogObj.caller = this.getCaller();
                if (!StringUtils.isEmpty((String)errorCode)) {
                    errLogObj.errorCode = errorCode;
                }
                this.loggers[1].warn(errLogObj.toJsonStr());
            }
        }
    }

    public void alarm(String message) {
        this.alarm((ErrLogObj)null, null, message);
    }

    public void alarm(String errorCode, String message) {
        this.alarm((ErrLogObj)null, errorCode, message);
    }

    public void alarm(ErrLogObj errLogObj, String format, Object ... args) {
        this.alarm(errLogObj, String.format(format, args), new Object[0]);
    }

    public void alarm(String format, Object ... args) {
        this.alarm((ErrLogObj)null, format, args);
    }

    public void analyze(String context, Object ... fields) {
        AnalyzeLogger.getInstance().info(context, fields);
    }

    public boolean isAnalyzeEnabled() {
        return TxcConfigHolder.getInstance().isAnalyzeEnabled();
    }

    public boolean isDebugEnabled() {
        return this.loggers[0].isDebugEnabled();
    }

    public boolean isInfoEnabled() {
        return this.loggers[0].isInfoEnabled();
    }

    public boolean isWarnEnabled() {
        return this.loggers[0].isWarnEnabled();
    }

    public boolean isErrorEnabled() {
        return this.loggers[0].isErrorEnabled();
    }

    public Object getDelegate() {
        return this.loggers[0].getDelegate();
    }
}

