/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.context.TxcContextOperateHelper;
import com.taobao.txc.common.exception.TxcException;

public class TxcContext {
    private static final LoggerWrap logger = LoggerInit.logger;
    public static final String TXC_XID_KEY = "TXC_XID";
    public static final String TXC_XID_OWNER_KEY = "TXC_XID_OWNER";
    public static final String TXC_RETRY_BRANCH_KEY = "TXC_RETRY_BRANCH";
    public static final String MT_UDATA_KEY = "MT_UDATA";
    public static final String COMMIT_COUNT = "COMMIT_COUNT";
    public static final String BEGIN_COUNT = "BEGIN_COUNT";
    public static final String TXC_NEXT_SVR_ADDR = "TXC_NEXT_SVR_ADDR";
    public static final String NEW_REDO_CONTEXT = "TXC_NEW_REDO_CONTEXT";
    public static final String TXC_HINT = "TXC_HINT";
    public static final String TXC_RULE = "TXC_RULE";
    public static final String TXC_ROLLBACKONLY = "TXC_ROLLBACKONLY";
    public static final String TXC_ROLLBACKONLY_VALUE_TRUE = "TRUE";

    public static final void setRollbackOnly(boolean rollbackOnly) {
        if (!TxcContext.inTxcTransaction()) {
            return;
        }
        if (rollbackOnly) {
            if (!TxcContext.isRollbackOnly()) {
                TxcContextOperateHelper.putUserData(TXC_ROLLBACKONLY, TXC_ROLLBACKONLY_VALUE_TRUE);
                if (logger.isDebugEnabled()) {
                    logger.debug("Transaction(" + TxcContext.getCurrentXid() + ") is set rollbackOnly. ", new Throwable());
                }
            }
        } else if (TxcContext.isRollbackOnly()) {
            TxcContextOperateHelper.removeUserData(TXC_ROLLBACKONLY);
        }
    }

    public static final boolean isRollbackOnly() {
        String num = TxcContextOperateHelper.getUserData(TXC_ROLLBACKONLY);
        return num != null;
    }

    public static final int getBeginCount() {
        String num = TxcContextOperateHelper.getUserData(BEGIN_COUNT);
        return num == null ? 0 : Integer.parseInt(num);
    }

    public static final int getCommitCount() {
        String num = TxcContextOperateHelper.getUserData(COMMIT_COUNT);
        return num == null ? 0 : Integer.parseInt(num);
    }

    public static final void setBegin(int beginCount) {
        TxcContextOperateHelper.putUserData(BEGIN_COUNT, String.valueOf(beginCount));
    }

    public static final void setCommitCount(int commitCount) {
        TxcContextOperateHelper.putUserData(COMMIT_COUNT, String.valueOf(commitCount));
    }

    public static String getTxcNextSvrAddr() {
        return TxcContextOperateHelper.getUserData(TXC_NEXT_SVR_ADDR);
    }

    public static final void clearReenterCounter() {
        TxcContextOperateHelper.removeUserData(COMMIT_COUNT);
        TxcContextOperateHelper.removeUserData(BEGIN_COUNT);
    }

    public static long getTransactionId() {
        return TxcXID.getTransactionId(TxcContext.getCurrentXid());
    }

    public static String getCurrentXid() {
        return TxcContextOperateHelper.getUserData(TXC_XID_KEY);
    }

    public static String getCurrentServer() {
        int idx;
        String xid = TxcContextOperateHelper.getUserData(TXC_XID_KEY);
        if (xid != null && (idx = xid.lastIndexOf(":")) > 0) {
            return xid.substring(0, idx);
        }
        return null;
    }

    public static void bind(String xid, String nextSvrAddr) throws TxcException {
        TxcContextOperateHelper.putUserData(TXC_XID_KEY, xid);
        TxcContextOperateHelper.putUserData(TXC_XID_OWNER_KEY, "TXC");
        if (nextSvrAddr != null) {
            TxcContextOperateHelper.putUserData(TXC_NEXT_SVR_ADDR, nextSvrAddr);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("XID_TRACING: Bind XID: " + xid, new Throwable());
        }
    }

    public static boolean inTxcTransaction() {
        return TxcContext.getCurrentXid() != null;
    }

    public static void unbind() {
        TxcContextOperateHelper.removeUserData(TXC_XID_KEY);
        TxcContextOperateHelper.removeUserData(TXC_XID_OWNER_KEY);
        TxcContextOperateHelper.removeUserData(TXC_NEXT_SVR_ADDR);
    }

    public static String suspendTxcTransaction() {
        return TxcContextOperateHelper.removeUserData(TXC_XID_KEY);
    }

    public static void resumeTxcTransaction(String xid) {
        if (xid != null) {
            TxcContextOperateHelper.putUserData(TXC_XID_KEY, xid);
        }
    }

    public static void startRetryBranch(long effectiveTime) {
        TxcContextOperateHelper.putUserData(TXC_RETRY_BRANCH_KEY, Long.toString(effectiveTime));
    }

    public static void endRetryBranch() {
        TxcContextOperateHelper.removeUserData(TXC_RETRY_BRANCH_KEY);
    }

    public static boolean inRetryContext() {
        return TxcContextOperateHelper.getUserData(TXC_RETRY_BRANCH_KEY) != null;
    }

    public static long getEffectiveTime() {
        String s = TxcContextOperateHelper.getUserData(TXC_RETRY_BRANCH_KEY);
        if (s != null) {
            return Long.parseLong(s);
        }
        return -1L;
    }

    public static void putMtUdata(String mtUdata) {
        if (mtUdata != null) {
            TxcContextOperateHelper.putUserData(MT_UDATA_KEY, mtUdata);
        }
    }

    public static String removeMtUdata() {
        return TxcContextOperateHelper.removeUserData(MT_UDATA_KEY);
    }

    public static boolean inTxcEnv() {
        return TxcContext.inTxcTransaction() || TxcContext.inRetryContext();
    }

    public static void putTxcHint(String hint) {
        TxcContextOperateHelper.putUserData(TXC_HINT, hint);
    }

    public static String getTxcHint() {
        return TxcContextOperateHelper.getUserData(TXC_HINT);
    }

    public static void putTxcRule(String hint) {
        TxcContextOperateHelper.putUserData(TXC_RULE, hint);
    }

    public static String getTxcRule() {
        return TxcContextOperateHelper.getUserData(TXC_RULE);
    }
}

