/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.analyze;

import com.taobao.middleware.logger.Logger;
import com.taobao.middleware.logger.LoggerFactory;
import com.taobao.txc.common.analyze.AnalyzeLoggerIndex;
import com.taobao.txc.common.config.TxcConfigHolder;
import java.util.concurrent.atomic.AtomicLong;

public class AnalyzeLogger {
    private static final String FIELD_SEPARATOR = Character.toString('\u001f');
    private Logger alogger;
    private AnalyzeLoggerIndex analyzeLoggerIndex = null;
    private ThreadLocal<Long> threadLocal = new ThreadLocal();
    private AtomicLong seq = new AtomicLong(0L);
    private static AnalyzeLogger analyzeLogger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AnalyzeLogger getInstance() {
        if (analyzeLogger != null) return analyzeLogger;
        Class<AnalyzeLogger> clazz = AnalyzeLogger.class;
        synchronized (AnalyzeLogger.class) {
            if (analyzeLogger != null) return analyzeLogger;
            analyzeLogger = new AnalyzeLogger();
            // ** MonitorExit[var0] (shouldn't be in output)
            return analyzeLogger;
        }
    }

    private AnalyzeLogger() {
        this.init();
    }

    private void init() {
        this.alogger = LoggerFactory.getLogger((String)"txc-analyze");
        this.alogger.activateAppenderWithSizeRolling("txc", "txc.analyze.log", "utf-8", "100mb", 100);
        this.analyzeLoggerIndex = new AnalyzeLoggerIndex();
    }

    public boolean isEnabled() {
        return TxcConfigHolder.getInstance().isAnalyzeEnabled();
    }

    private String getRecord(Object[] fields) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Object field : fields) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(FIELD_SEPARATOR);
            }
            sb.append(field);
        }
        return sb.toString();
    }

    public void info(String context, Object ... fields) {
        if (!this.isEnabled()) {
            return;
        }
        this.alogger.info(context, this.getRecord(fields));
    }

    public void begin(String xid) {
        this.analyzeLoggerIndex.begin(xid);
    }

    public long getLastCost() {
        Long b = this.threadLocal.get();
        if (b == null) {
            this.threadLocal.set(new Long(System.currentTimeMillis()));
            return 0L;
        }
        long n = System.currentTimeMillis();
        long c = n - b;
        this.threadLocal.set(new Long(n));
        return c;
    }

    public long getNextSequence() {
        return this.seq.incrementAndGet();
    }
}

