/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.analyze;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.util.CommandStreamReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;

public class AnalyzeLoggerIndex {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static int INDEX_BUCKET = 16;
    private static int maxCachedNumber = 200000;
    private SimpleDateFormat recordPrefixDateFormat = new SimpleDateFormat("HH:mm:ss ");
    private SimpleDateFormat indexFileSufffixDateFormat = new SimpleDateFormat(".yyyy-MM-dd");
    private ConcurrentHashMap<String, IndexFileOutPutStream> indexFileMap = new ConcurrentHashMap(INDEX_BUCKET * 3);
    private StringBuilder[] stringBuilders;
    private ScheduledExecutorService executorService;
    private ReentrantLock xlock = new ReentrantLock();
    private HashMap<String, LinkedBlockingQueue<String>> allCachedXids = new HashMap();
    private String indexPath;

    public AnalyzeLoggerIndex() {
        String userHome = System.getProperty("user.home");
        if (StringUtils.isEmpty((String)userHome)) {
            userHome = "/home/admin";
        }
        this.indexPath = userHome + File.separator + "logs" + File.separator + "txc" + File.separator + "analyze" + File.separator + "index";
        File path = new File(this.indexPath);
        if (path.exists()) {
            if (!path.isDirectory()) {
                logger.error(null, "the analyze index directory is invalid - " + path.getAbsolutePath());
            }
        } else if (!path.mkdirs()) {
            logger.error(null, "failed to create the analyze index directory - " + path.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void begin(String xid) {
        String serverAddr;
        LinkedBlockingQueue<String> cachedXids;
        if (!AnalyzeLogger.getInstance().isEnabled()) {
            return;
        }
        if (this.executorService == null) {
            AnalyzeLoggerIndex analyzeLoggerIndex = this;
            synchronized (analyzeLoggerIndex) {
                if (this.executorService == null) {
                    this.executorService = Executors.newScheduledThreadPool(2);
                    this.executorService.scheduleWithFixedDelay(new Runnable(){

                        @Override
                        public void run() {
                            AnalyzeLoggerIndex.this.flushXids();
                        }
                    }, 10L, 60L, TimeUnit.SECONDS);
                    this.executorService.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            AnalyzeLoggerIndex.this.clean();
                        }
                    }, 1L, 1L, TimeUnit.HOURS);
                }
            }
        }
        if ((cachedXids = this.allCachedXids.get(serverAddr = TxcXID.getServerAddress(xid))) == null) {
            this.xlock.lock();
            try {
                cachedXids = this.allCachedXids.get(serverAddr);
                if (cachedXids == null) {
                    cachedXids = new LinkedBlockingQueue(maxCachedNumber);
                    this.allCachedXids.put(serverAddr, cachedXids);
                }
            }
            finally {
                this.xlock.unlock();
            }
        }
        cachedXids.offer(xid);
    }

    private void writeIndex(String indexFileName, String record) {
        IndexFileOutPutStream ifos = this.indexFileMap.get(indexFileName);
        if (ifos == null) {
            this.indexFileMap.putIfAbsent(indexFileName, new IndexFileOutPutStream(indexFileName));
            ifos = this.indexFileMap.get(indexFileName);
        }
        try {
            ifos.write(record.getBytes("utf-8"));
        }
        catch (Exception e) {
            logger.error("IO failed", "can't write to file " + indexFileName, (Throwable)e);
            return;
        }
    }

    private void flushXids() {
        if (this.allCachedXids.size() == 0) {
            return;
        }
        File indexFilePath = new File(this.indexPath);
        if (!indexFilePath.exists() || !indexFilePath.isDirectory()) {
            for (String serverAddr : this.allCachedXids.keySet()) {
                LinkedBlockingQueue<String> cachedXids = this.allCachedXids.get(serverAddr);
                if (cachedXids == null) continue;
                cachedXids.clear();
            }
            return;
        }
        if (this.stringBuilders == null) {
            this.stringBuilders = new StringBuilder[INDEX_BUCKET];
            for (int i = 0; i < INDEX_BUCKET; ++i) {
                this.stringBuilders[i] = new StringBuilder(8000);
            }
        }
        Date curDate = new Date();
        String recordPrefix = this.recordPrefixDateFormat.format(curDate);
        String indexFileSuffix = this.indexFileSufffixDateFormat.format(curDate);
        for (String serverAddr : this.allCachedXids.keySet()) {
            int idx;
            String xid;
            String serverAddrPath = serverAddr.replace(':', '_');
            LinkedBlockingQueue<String> cachedXids = this.allCachedXids.get(serverAddr);
            if (cachedXids == null) continue;
            int len = cachedXids.size();
            if (len == 0) {
                return;
            }
            for (int i = 0; i < len && (xid = cachedXids.poll()) != null; ++i) {
                long tid = TxcXID.getTransactionId(xid);
                idx = (int)(tid % (long)INDEX_BUCKET);
                if (this.stringBuilders[idx].length() == 0) {
                    this.stringBuilders[idx].append(recordPrefix).append(tid);
                    continue;
                }
                this.stringBuilders[idx].append(' ').append(tid);
            }
            for (idx = 0; idx < INDEX_BUCKET; ++idx) {
                StringBuilder sb = this.stringBuilders[idx];
                if (sb.length() == 0) continue;
                sb.append('\n');
                String indexFile = String.format("%s%s%s%s%02d%sindex%s", this.indexPath, File.separator, serverAddrPath, File.separator, idx, File.separator, indexFileSuffix);
                this.writeIndex(indexFile, sb.toString());
                sb.setLength(0);
            }
        }
    }

    private void clean() {
        int historyDays = TxcConfigHolder.getInstance().getAnalyzeClean();
        this.cleanUselessFileOutputStream();
        this.cleanUselessIndexFiles(historyDays);
    }

    private void cleanUselessFileOutputStream() {
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        if (hour != 1 && hour != 3) {
            return;
        }
        calendar.add(5, -1);
        String endDatePrefix = this.indexFileSufffixDateFormat.format(calendar.getTime());
        Set indexFileNames = this.indexFileMap.keySet();
        for (String indexFileName : indexFileNames) {
            String fileDate = indexFileName.substring(indexFileName.length() - this.indexFileSufffixDateFormat.toPattern().length());
            if (fileDate.compareTo(endDatePrefix) >= 0) continue;
            IndexFileOutPutStream fos = this.indexFileMap.remove(indexFileName);
            fos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUselessIndexFiles(int historyDays) {
        if (historyDays < 1) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        int hour = calendar.get(11);
        if (hour != 5 && hour != 21) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("find ").append(this.indexPath).append(" -mtime +").append(historyDays);
        sb.append(" -name 'index.*' -type f -delete");
        CommandStreamReader commandStreamReader = new CommandStreamReader();
        try {
            commandStreamReader.execute(new String[]{"/bin/sh", "-c", sb.toString()}, null);
            String res = commandStreamReader.readContent(CommandStreamReader.StreamType.ERROR_STREAM, 10000L);
            logger.info(String.format("clean index files done. cmd:[%s] res:[%s]", sb.toString(), res));
        }
        catch (Exception e) {
            logger.warn("clean index files failed. " + e.getMessage());
        }
        finally {
            commandStreamReader.destroy();
        }
    }

    private class IndexFileOutPutStream {
        private String path;
        private FileOutputStream fos;

        public IndexFileOutPutStream(String path) {
            this.path = path;
        }

        public void write(byte[] record) {
            if (this.fos == null) {
                File f = new File(this.path);
                File p = f.getParentFile();
                if (!p.exists()) {
                    p.mkdirs();
                }
                if (!f.exists()) {
                    try {
                        f.createNewFile();
                    }
                    catch (IOException e) {
                        logger.error(null, "failed to create analyze index file " + this.path, (Throwable)e);
                        return;
                    }
                }
                try {
                    this.fos = new FileOutputStream(f, true);
                }
                catch (FileNotFoundException e) {
                    return;
                }
            }
            try {
                this.fos.write(record);
            }
            catch (IOException e) {
                logger.error(null, "failed to write", (Throwable)e);
            }
        }

        public void close() {
            if (this.fos != null) {
                try {
                    this.fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

