/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONType;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.util.http.HttpSecurity;
import com.taobao.txc.common.util.http.HttpUtil;
import com.taobao.txc.common.util.http.LocalCache;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ConsoleConfig {
    private static final LoggerWrap logger = LoggerInit.logger;
    private ScheduledExecutorService longPollExecutor = Executors.newSingleThreadScheduledExecutor();
    private String[] urls = new String[]{new String("https://cs2.gts.aliyuncs.com")};
    private int urlIndex = 0;
    private static ConsoleConfig _instance;
    private static String CONFIG_SERVER_URL_ENV;
    private static String LONG_POLL_TIMEOUT;
    private static long LONG_POLL_PERIOD_MS;
    private static long LONG_POLL_FAILED_DELAY;
    private static String FAKE_CONTENT;
    private static int objCount;
    private static String serverRulePrefix;
    private Random random = new Random();
    private ConcurrentHashMap<KeyItem, Set<ITxcManagerListener>> longPollListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<KeyItem, String> configDatas = new ConcurrentHashMap();
    private ConcurrentHashMap<KeyItem, KeyItem> configDataVersion = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> vgroupRuleCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> globalRuleCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<IConfigCallback>> vgroupRuleCallbacks = new ConcurrentHashMap();
    private MultiRuleConfig serverRuleConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void enableServerRule(String prefix) {
        serverRulePrefix = prefix;
        if (_instance == null) return;
        Class<ConsoleConfig> clazz = ConsoleConfig.class;
        synchronized (ConsoleConfig.class) {
            _instance.setServerRule(prefix);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Set<KeyItem> fillDataIdVersion(Set<KeyItem> input) {
        HashSet<KeyItem> keyItemWithVersions = new HashSet<KeyItem>();
        for (KeyItem keyItem : input) {
            if (this.configDataVersion.containsKey(keyItem)) {
                keyItemWithVersions.add(this.configDataVersion.get(keyItem));
                continue;
            }
            keyItemWithVersions.add(keyItem);
        }
        return keyItemWithVersions;
    }

    private void initUrls(String urls) {
        if (StringUtils.isEmpty((String)urls)) {
            return;
        }
        String[] myurls = urls.split(",");
        for (int i = 0; i < myurls.length; ++i) {
            if (!myurls[i].isEmpty()) continue;
            throw new IllegalArgumentException("empty url in " + urls);
        }
        this.urls = myurls;
        if (this.urls.length == 1) {
            this.urlIndex = 0;
        } else {
            Random r = new Random();
            this.urlIndex = r.nextInt(this.urls.length);
        }
    }

    private boolean changeUrl() {
        if (this.urls.length == 1) {
            return false;
        }
        this.urlIndex = (this.urlIndex + 1) % this.urls.length;
        logger.info("change console config url to {}", this.getUrl());
        return true;
    }

    private String getUrl() {
        return this.urls[this.urlIndex];
    }

    public ConsoleConfig(String urls) {
        this.init(urls);
        _instance = this;
    }

    private ConsoleConfig() {
        this.init(null);
    }

    public void setServerRule(String prefix) {
        if (this.serverRuleConfig == null) {
            this.serverRuleConfig = new MultiRuleConfig(prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsoleConfig getInstance() {
        if (_instance != null) return _instance;
        Class<ConsoleConfig> clazz = ConsoleConfig.class;
        synchronized (ConsoleConfig.class) {
            if (_instance != null) return _instance;
            _instance = new ConsoleConfig();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }

    public void printUsage() {
        logger.info(String.format("Use console config url:%s", this.getUrl()));
    }

    private String httppost(String uri, Map<String, String> headers, String body) throws Exception {
        int retry = 2;
        String content = null;
        while (true) {
            String fullUrl = this.getUrl() + uri;
            try {
                content = HttpUtil.post(fullUrl, headers, body);
            }
            catch (IOException e) {
                if (retry-- > 0 && this.changeUrl()) continue;
                throw e;
            }
            break;
        }
        return content;
    }

    private void startLongPollSchedule() {
        this.longPollExecutor.scheduleAtFixedRate(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (ConsoleConfig.this.longPollListeners.size() > 0) {
                        HashMap<String, Object> body = new HashMap<String, Object>();
                        body.put("timeout", LONG_POLL_TIMEOUT);
                        body.put("keys", ConsoleConfig.this.fillDataIdVersion(ConsoleConfig.this.longPollListeners.keySet()));
                        String contents = ConsoleConfig.this.httppost("/cs/api/config.json", null, JSON.toJSONString(body));
                        if (!StringUtils.isEmpty((String)contents)) {
                            ConsoleConfig.this.processLongPollResponse(StringUtils.trim((String)contents));
                        }
                    }
                }
                catch (IOException e) {
                    logger.error(TxcErrCode.HttpAccessError.errMessage, String.format("POST keys:%s", ConsoleConfig.this.longPollListeners.keySet()), (Throwable)e);
                    MultiRuleConfig serverRuleConfig = ConsoleConfig.this.serverRuleConfig;
                    try {
                        HashMap globalRules = new HashMap();
                        HashMap vgroupRules = new HashMap();
                        for (KeyItem keyItem : ConsoleConfig.this.longPollListeners.keySet()) {
                            Set listeners;
                            String content = null;
                            boolean isRule = false;
                            if (!ConsoleConfig.this.configDatas.containsKey(keyItem)) {
                                ConcurrentHashMap concurrentHashMap = ConsoleConfig.this.configDatas;
                                synchronized (concurrentHashMap) {
                                    if (!ConsoleConfig.this.configDatas.containsKey(keyItem)) {
                                        content = StringUtils.trim((String)LocalCache.loadFromCache(keyItem.group, keyItem.dataId));
                                        logger.info(String.format("POST loadCache dataId:%s group:%s value:%s", keyItem.dataId, keyItem.group, content));
                                        if (!StringUtils.isEmpty((String)content)) {
                                            ConsoleConfig.this.configDatas.put(keyItem, content);
                                            isRule = ConsoleConfig.this.preProcessRules(globalRules, vgroupRules, keyItem.group, keyItem.dataId, content);
                                            if (serverRuleConfig != null) {
                                                serverRuleConfig.preProcessRules(keyItem.group, keyItem.dataId, content);
                                            }
                                        }
                                    }
                                }
                            } else if (StringUtils.isEmpty(content) || StringUtils.equals((String)((String)ConsoleConfig.this.configDatas.get(keyItem)), content)) continue;
                            if (isRule || content == null || (listeners = (Set)ConsoleConfig.this.longPollListeners.get(keyItem)) == null) continue;
                            Set set = listeners;
                            synchronized (set) {
                                for (ITxcManagerListener listener : listeners) {
                                    try {
                                        listener.receiveConfigInfo(content);
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                        }
                        if (!globalRules.isEmpty() || !vgroupRules.isEmpty()) {
                            ConsoleConfig.this.mergeRulesAndNotify(globalRules, vgroupRules);
                        }
                    }
                    catch (Exception e1) {
                        logger.error(TxcErrCode.UnknownAppError, e1);
                    }
                    if (serverRuleConfig != null) {
                        try {
                            serverRuleConfig.mergeRulesAndNotify();
                        }
                        catch (Throwable e2) {
                            logger.error(TxcErrCode.UnknownAppError, e2);
                        }
                    }
                    try {
                        Thread.sleep(LONG_POLL_FAILED_DELAY);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception e) {
                    logger.error(TxcErrCode.UnknownAppError, e);
                }
            }
        }, 5000L, LONG_POLL_PERIOD_MS, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String urls) {
        String eurl = System.getProperty(CONFIG_SERVER_URL_ENV);
        if (StringUtils.isNotEmpty((String)eurl)) {
            this.initUrls(eurl);
        } else if (StringUtils.isNotEmpty((String)urls)) {
            this.initUrls(urls);
        }
        try {
            Class.forName("org.apache.http.client.HttpClient");
        }
        catch (ClassNotFoundException e) {
            logger.info("console config init error, no httpclient jar!");
            throw new RuntimeException(e);
        }
        Class<ConsoleConfig> clazz = ConsoleConfig.class;
        synchronized (ConsoleConfig.class) {
            // ** MonitorExit[var3_4] (shouldn't be in output)
            if (++objCount > 1) {
                throw new RuntimeException(String.format("should create console only once! %s", this.getUrl()));
            }
            if (serverRulePrefix != null) {
                this.setServerRule(serverRulePrefix);
            }
            this.startLongPollSchedule();
            this.printUsage();
            return;
        }
    }

    private void parseRules(Map<String, String> rules, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return;
        }
        StringTokenizer token = new StringTokenizer(content, "\r\n");
        while (token.hasMoreElements()) {
            String rule = token.nextToken();
            if (rule == null || rule.trim().length() == 0) continue;
            int epos = rule.indexOf(61);
            if (epos <= 0) {
                throw new TxcException("invalid txc rules", TxcErrCode.TxcRuleError);
            }
            rules.put(rule.substring(0, epos), rule.substring(epos + 1));
        }
    }

    private boolean preProcessRules(Map<String, String> globalRules, Map<String, String> vgroupRules, String group, String dataId, String content) {
        boolean isRule = false;
        if (dataId.indexOf("com.taobao.txc.rules") != -1 && group.equals("TXC_GROUP")) {
            isRule = true;
            if (dataId.equals("com.taobao.txc.rules.global")) {
                this.parseRules(globalRules, content);
            } else {
                this.parseRules(vgroupRules, content);
            }
        }
        return isRule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLongPollResponse(String contents) {
        JSONArray jsonArray = null;
        try {
            jsonArray = JSON.parseArray((String)contents);
            if (jsonArray == null) {
                return;
            }
        }
        catch (Exception e) {
            logger.error("poll Json parse failed ", String.format("contents:%s", contents), (Throwable)e);
            return;
        }
        HashMap<String, String> globalRules = new HashMap<String, String>();
        HashMap<String, String> vgroupRules = new HashMap<String, String>();
        MultiRuleConfig serverRuleConfig = this.serverRuleConfig;
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            if (obj == null) continue;
            String group = obj.getString("group");
            String dataId = obj.getString("dataId");
            String content = obj.getString("content");
            if (StringUtils.isEmpty((String)content)) continue;
            content = StringUtils.trim((String)content);
            KeyItem keyItem = new KeyItem(group, dataId);
            String version = obj.getString("version");
            if (!StringUtils.isEmpty((String)version)) {
                keyItem.version = version;
                this.configDataVersion.put(keyItem, keyItem);
            }
            boolean isRule = this.preProcessRules(globalRules, vgroupRules, group, dataId, content);
            if (serverRuleConfig != null) {
                serverRuleConfig.preProcessRules(group, dataId, content);
            }
            if (!this.configDatas.containsKey(keyItem)) {
                ConcurrentHashMap<KeyItem, String> concurrentHashMap = this.configDatas;
                synchronized (concurrentHashMap) {
                    if (!this.configDatas.containsKey(keyItem)) {
                        this.configDatas.put(keyItem, content);
                    }
                }
            } else if (StringUtils.equals((String)this.configDatas.get(keyItem), (String)content)) continue;
            if (LocalCache.flushCache(group, dataId, content)) {
                this.configDatas.put(keyItem, content);
            }
            logger.info(String.format("received updated group:%s dataId:%s content:%s", group, dataId, content));
            if (isRule || this.longPollListeners.isEmpty()) continue;
            for (KeyItem item : this.longPollListeners.keySet()) {
                Set<ITxcManagerListener> listeners;
                if (item == null || !item.dataId.equals(dataId) || !item.group.equals(group) || (listeners = this.longPollListeners.get(item)) == null) continue;
                Set<ITxcManagerListener> set = listeners;
                synchronized (set) {
                    for (ITxcManagerListener listener : listeners) {
                        try {
                            listener.receiveConfigInfo(content);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        if (!globalRules.isEmpty() || !vgroupRules.isEmpty()) {
            this.mergeRulesAndNotify(globalRules, vgroupRules);
        }
        if (serverRuleConfig != null) {
            serverRuleConfig.mergeRulesAndNotify();
        }
    }

    private void mergeRulesAndNotify(Map<String, String> globalRules, Map<String, String> vgroupRules) {
        Set<IConfigCallback> cbs;
        String value;
        HashSet<String> processedGlobalKeys = new HashSet<String>();
        HashSet removedVgroupKeys = new HashSet();
        if (!vgroupRules.isEmpty()) {
            for (String key : vgroupRules.keySet()) {
                value = vgroupRules.get(key);
                if (StringUtils.isEmpty((String)value) || this.vgroupRuleCache.containsKey(key) && this.vgroupRuleCache.get(key).equals(value)) continue;
                if (this.vgroupRuleCallbacks.containsKey(key)) {
                    cbs = this.vgroupRuleCallbacks.get(key);
                    for (IConfigCallback cb : cbs) {
                        try {
                            cb.callback(value);
                        }
                        catch (Exception exception) {}
                    }
                }
                if (!globalRules.containsKey(key)) continue;
                processedGlobalKeys.add(key);
            }
            removedVgroupKeys.addAll(this.vgroupRuleCache.keySet());
            removedVgroupKeys.removeAll(vgroupRules.keySet());
            this.vgroupRuleCache.clear();
            this.vgroupRuleCache.putAll(vgroupRules);
        }
        if (!globalRules.isEmpty()) {
            for (String key : globalRules.keySet()) {
                if (processedGlobalKeys.contains(key) || this.vgroupRuleCache.containsKey(key) || StringUtils.isEmpty((String)(value = globalRules.get(key))) || this.globalRuleCache.containsKey(key) && this.globalRuleCache.get(key).equals(value) && !removedVgroupKeys.contains(key) || !this.vgroupRuleCallbacks.containsKey(key)) continue;
                cbs = this.vgroupRuleCallbacks.get(key);
                for (IConfigCallback cb : cbs) {
                    try {
                        cb.callback(value);
                    }
                    catch (Exception exception) {}
                }
            }
            this.globalRuleCache.clear();
            this.globalRuleCache.putAll(globalRules);
        }
    }

    public String getConfig(String dataId, String group) {
        return this.getConfig(dataId, group, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfig(String dataId, String group, long timeoutMs) {
        KeyItem keyItem;
        block42: {
            String content;
            if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group)) {
                return null;
            }
            keyItem = new KeyItem(group, dataId);
            try {
                int connTimeout = 30000;
                if (this.configDatas.containsKey(keyItem)) {
                    connTimeout = 5000;
                }
                int retry = 2;
                content = null;
                StringBuilder sb = new StringBuilder();
                while (true) {
                    sb.setLength(0);
                    sb.append(this.getUrl()).append("/cs/api/config.co?");
                    sb.append("group=").append(URLEncoder.encode(group, "UTF-8"));
                    sb.append("&dataId=").append(URLEncoder.encode(dataId, "UTF-8"));
                    sb.append("&timeout=").append(0);
                    try {
                        content = StringUtils.trim((String)HttpUtil.get(sb.toString(), connTimeout));
                    }
                    catch (IOException e) {
                        if (retry-- > 0 && this.changeUrl()) continue;
                        throw e;
                    }
                    break;
                }
                if (StringUtils.isEmpty((String)content)) {
                    logger.info(String.format("dataid:%s,group:%s is empty", dataId, group));
                    String string = content;
                    return string;
                }
                if (this.configDatas.containsKey(keyItem) && StringUtils.equals((String)this.configDatas.get(keyItem), (String)content)) break block42;
                ConcurrentHashMap<KeyItem, String> concurrentHashMap = this.configDatas;
                synchronized (concurrentHashMap) {
                    if (!(this.configDatas.containsKey(keyItem) && StringUtils.equals((String)this.configDatas.get(keyItem), (String)content) || !LocalCache.flushCache(group, dataId, content))) {
                        this.configDatas.put(keyItem, content);
                    }
                }
            }
            catch (TxcException e) {
                if (e.getErrcode() == TxcErrCode.HttpDataNotExistError) {
                    logger.warn(String.format("http get return 404 dataId:%s,group:%s", dataId, group));
                    String string = null;
                    return string;
                }
                logger.error(e.getMessage(), String.format("GET dataId:%s group:%s", dataId, group), (Throwable)e);
                if (this.configDatas.containsKey(keyItem)) break block42;
                ConcurrentHashMap<KeyItem, String> concurrentHashMap = this.configDatas;
                synchronized (concurrentHashMap) {
                    if (!this.configDatas.containsKey(keyItem)) {
                        content = StringUtils.trim((String)LocalCache.loadFromCache(group, dataId));
                        logger.info(String.format("GET loadCache dataId:%s group:%s value:%s", dataId, group, content));
                        if (!StringUtils.isEmpty((String)content)) {
                            this.configDatas.put(keyItem, content);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(TxcErrCode.HttpAccessError.errMessage, String.format("GET dataId:%s group:%s", dataId, group), (Throwable)e);
                if (this.configDatas.containsKey(keyItem)) break block42;
                ConcurrentHashMap<KeyItem, String> concurrentHashMap = this.configDatas;
                synchronized (concurrentHashMap) {
                    if (!this.configDatas.containsKey(keyItem)) {
                        content = StringUtils.trim((String)LocalCache.loadFromCache(group, dataId));
                        logger.info(String.format("GET loadCache dataId:%s group:%s value:%s", dataId, group, content));
                        if (!StringUtils.isEmpty((String)content)) {
                            this.configDatas.put(keyItem, content);
                        }
                    }
                }
            }
            finally {
                int rand = this.random.nextInt(100);
                try {
                    Thread.sleep(100 + rand);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        String res = this.configDatas.get(keyItem);
        logger.info(String.format("dataid:%s,group:%s,result:%s", dataId, group, res));
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String dataId, String group, ITxcManagerListener listener) {
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group) || listener == null) {
            return;
        }
        KeyItem fullkey = new KeyItem(group, dataId);
        if (!this.longPollListeners.containsKey(fullkey)) {
            ConcurrentHashMap<KeyItem, Set<ITxcManagerListener>> concurrentHashMap = this.longPollListeners;
            synchronized (concurrentHashMap) {
                if (!this.longPollListeners.containsKey(fullkey)) {
                    this.longPollListeners.put(fullkey, new HashSet());
                }
            }
            Set<ITxcManagerListener> listeners = this.longPollListeners.get(fullkey);
            if (listeners != null) {
                Set<ITxcManagerListener> set = listeners;
                synchronized (set) {
                    listeners.add(listener);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("add listener {} for dataId:{}, group:{}", listener, dataId, group);
                }
            }
        } else {
            logger.info(String.format("ignore duplicated dataId:%s group:%s addListener", dataId, group));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String dataId, String group, ITxcManagerListener listener) {
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group) || listener == null) {
            return;
        }
        KeyItem fullkey = new KeyItem(group, dataId);
        if (this.longPollListeners.containsKey(fullkey)) {
            Set<ITxcManagerListener> listeners = null;
            Object object = this.longPollListeners;
            synchronized (object) {
                if (this.longPollListeners.containsKey(fullkey)) {
                    listeners = this.longPollListeners.get(fullkey);
                }
            }
            if (listeners != null && listeners.contains(listener)) {
                object = listeners;
                synchronized (object) {
                    if (listeners.contains(listener)) {
                        listeners.remove(listener);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRuleListener(String key, String dataId, String group, IConfigCallback callback, ConcurrentHashMap<String, Set<IConfigCallback>> vgroupRuleCallbacks) {
        ConcurrentHashMap<Object, Set<Object>> concurrentHashMap;
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group)) {
            return;
        }
        KeyItem fullkey = new KeyItem(group, dataId);
        if (!this.longPollListeners.containsKey(fullkey)) {
            concurrentHashMap = this.longPollListeners;
            synchronized (concurrentHashMap) {
                if (!this.longPollListeners.containsKey(fullkey)) {
                    this.longPollListeners.put(fullkey, new HashSet());
                }
            }
        }
        if (callback != null) {
            Set<IConfigCallback> callbacks;
            if (!vgroupRuleCallbacks.containsKey(key)) {
                concurrentHashMap = vgroupRuleCallbacks;
                synchronized (concurrentHashMap) {
                    if (!vgroupRuleCallbacks.containsKey(key)) {
                        vgroupRuleCallbacks.put(key, new HashSet());
                    }
                }
            }
            Set<IConfigCallback> set = callbacks = vgroupRuleCallbacks.get(key);
            synchronized (set) {
                callbacks.add(callback);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("add rule listener {} for dataId:{}, rule {}", callback, dataId, key);
            }
        }
    }

    public boolean putSingle(String dataId, String group, String content) {
        return this.putSingle0(dataId, group, content, null);
    }

    public boolean putSingle(String dataId, String group, String content, HttpSecurity httpSecurity) {
        if (httpSecurity == null) {
            logger.error(TxcErrCode.ConfigSecurityError.errCode, String.format("putSingle without security dataId:%s group:%s content:%s", dataId, group, content));
            return false;
        }
        return this.putSingle0(dataId, group, content, httpSecurity);
    }

    private boolean putSingle0(String dataId, String group, String content, HttpSecurity httpSecurity) {
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group) || StringUtils.isEmpty((String)content)) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("group", group);
            body.put("dataId", dataId);
            body.put("content", content);
            HashMap<String, String> headers = null;
            if (httpSecurity != null) {
                headers = new HashMap<String, String>();
                if (httpSecurity.getAccessKey() != null) {
                    headers.put("CS-AK", httpSecurity.getAccessKey());
                }
                if (httpSecurity.getAppName() != null) {
                    headers.put("CS-AppName", httpSecurity.getAppName());
                }
                if (httpSecurity.getVgroup() != null) {
                    headers.put("CS-Vgroup", httpSecurity.getVgroup());
                }
                if (httpSecurity.getDigest() != null) {
                    headers.put("CS-Digest", httpSecurity.getDigest());
                }
            }
            this.httppost("/cs/api/putSingle.json", headers, JSON.toJSONString(body));
            logger.info(String.format("POST update dataId%s group:%s", dataId, group));
        }
        catch (Exception e) {
            logger.error(TxcErrCode.HttpAccessError.errMessage, String.format("POST update dataId:%s group:%s", dataId, group), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean putAggr(String dataId, String group, String datumId, String content) {
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group) || StringUtils.isEmpty((String)datumId) || StringUtils.isEmpty((String)content)) {
            logger.warn("empty argument when putAaggr");
            return false;
        }
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("group", group);
            body.put("dataId", dataId);
            body.put("member", datumId);
            body.put("content", content);
            this.httppost("/cs/api/putMember.json", null, JSON.toJSONString(body));
            logger.info(String.format("POST putAggr dataId:%s, group:%s, member:%s, content:%s", dataId, group, datumId, content));
        }
        catch (Exception e) {
            logger.error(TxcErrCode.HttpAccessError.errMessage, String.format("failed to POST putAggr dataId:%s group:%s, member:%s, content:%s", dataId, group, datumId, content), (Throwable)e);
            return false;
        }
        return true;
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        if (StringUtils.isEmpty((String)dataId) || StringUtils.isEmpty((String)group) || StringUtils.isEmpty((String)datumId)) {
            logger.warn("empty argument when removeAggr");
            return false;
        }
        try {
            HashMap<String, String> body = new HashMap<String, String>();
            body.put("group", group);
            body.put("dataId", dataId);
            body.put("member", datumId);
            this.httppost("/cs/api/removeMember.json", null, JSON.toJSONString(body));
            logger.info(String.format("POST removeAggr dataId:%s, group:%s, member:%s", dataId, group, datumId));
        }
        catch (Exception e) {
            logger.error(TxcErrCode.HttpAccessError.errMessage, String.format("failed to POST removeAggr dataId:%s, group:%s, member:%s", dataId, group, datumId), (Throwable)e);
            return false;
        }
        return true;
    }

    public String getServerRuleValue(String vgroupName, String key) {
        if (this.serverRuleConfig == null) {
            return null;
        }
        return this.serverRuleConfig.getRuleValue(vgroupName, key);
    }

    public String getRuleValue(String vgroupName, String key) {
        String value = System.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        return this.getRuleValue0(vgroupName, key, this.vgroupRuleCache, this.globalRuleCache, "com.taobao.txc.rules.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRuleValue0(String vgroupName, String key, ConcurrentHashMap<String, String> vgroupRuleCache, ConcurrentHashMap<String, String> globalRuleCache, String prefix) {
        String vgroupValue;
        String globalRuleValue = this.getRuleDynamicInternal0("global", key, null, vgroupRuleCache, globalRuleCache, prefix, null);
        if (StringUtils.isNotEmpty((String)vgroupName) && !vgroupName.equals("global") && !((ConcurrentHashMap.KeySetView)vgroupRuleCache.keySet()).contains(key)) {
            ConcurrentHashMap<String, String> concurrentHashMap = vgroupRuleCache;
            synchronized (concurrentHashMap) {
                if (!((ConcurrentHashMap.KeySetView)vgroupRuleCache.keySet()).contains(key)) {
                    this.getRuleDynamicInternal0(vgroupName, key, null, vgroupRuleCache, globalRuleCache, prefix, null);
                }
            }
        }
        if (vgroupRuleCache.containsKey(key) && !StringUtils.isEmpty((String)(vgroupValue = vgroupRuleCache.get(key)))) {
            return vgroupValue;
        }
        return globalRuleValue;
    }

    public void addRuleDynamic(String key, String vgroupName, IConfigCallback callback) {
        String value = System.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            callback.callback(value);
            return;
        }
        String globalResult = this.getRuleDynamicInternal("global", key, null);
        String vgroupResult = null;
        if (!StringUtils.isEmpty((String)vgroupName) && !vgroupName.equals("global")) {
            vgroupResult = this.getRuleDynamicInternal(vgroupName, key, callback);
        }
        if (vgroupResult != null) {
            callback.callback(vgroupResult);
        } else if (globalResult != null) {
            callback.callback(globalResult);
        }
    }

    private String getRuleDynamicInternal(String vgroupName, String key, IConfigCallback callback) {
        return this.getRuleDynamicInternal0(vgroupName, key, callback, this.vgroupRuleCache, this.globalRuleCache, "com.taobao.txc.rules.", this.vgroupRuleCallbacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRuleDynamicInternal0(String vgroupName, String key, IConfigCallback callback, ConcurrentHashMap<String, String> vgroupRuleCache, ConcurrentHashMap<String, String> globalRuleCache, String prefix, ConcurrentHashMap<String, Set<IConfigCallback>> vgroupRuleCallbacks) {
        if (StringUtils.isEmpty((String)vgroupName) || StringUtils.isEmpty((String)key)) {
            return null;
        }
        String result = null;
        String dataId = prefix + vgroupName;
        try {
            ConcurrentHashMap<String, String> rulecache = null;
            rulecache = vgroupName.equals("global") ? globalRuleCache : vgroupRuleCache;
            if (rulecache.containsKey(key)) {
                result = rulecache.get(key);
            } else {
                ConcurrentHashMap<String, String> concurrentHashMap;
                if (rulecache.isEmpty()) {
                    concurrentHashMap = rulecache;
                    synchronized (concurrentHashMap) {
                        if (rulecache.isEmpty()) {
                            String content = this.getConfig(dataId, "TXC_GROUP");
                            HashMap<String, String> rules = new HashMap<String, String>();
                            this.parseRules(rules, content);
                            rulecache.putAll(rules);
                        }
                    }
                }
                if (!rulecache.containsKey(key)) {
                    concurrentHashMap = rulecache;
                    synchronized (concurrentHashMap) {
                        if (!rulecache.containsKey(key)) {
                            rulecache.put(key, FAKE_CONTENT);
                        }
                    }
                }
            }
            if (result == null) {
                result = rulecache.get(key);
            }
            this.addRuleListener(key, dataId, "TXC_GROUP", callback, vgroupRuleCallbacks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static void main(String[] args) {
    }

    static {
        CONFIG_SERVER_URL_ENV = "txc.configserver.url";
        LONG_POLL_TIMEOUT = "30000";
        LONG_POLL_PERIOD_MS = 10L;
        LONG_POLL_FAILED_DELAY = 30000L;
        FAKE_CONTENT = "";
        objCount = 0;
        serverRulePrefix = null;
    }

    private class MultiRuleConfig {
        private ConcurrentHashMap<String, String> globalRules;
        private Map<String, ConcurrentHashMap<String, String>> vgroupRules;
        private Map<String, ConcurrentHashMap<String, String>> vgroupRuleCaches = new Hashtable<String, ConcurrentHashMap<String, String>>();
        private ConcurrentHashMap<String, String> globalRuleCache = new ConcurrentHashMap();
        private String prefix;
        private int preCount = 0;

        public MultiRuleConfig(String prefix) {
            this.prefix = prefix;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getRuleValue(String vgroupName, String key) {
            if (!this.vgroupRuleCaches.containsKey(vgroupName)) {
                Map<String, ConcurrentHashMap<String, String>> map = this.vgroupRuleCaches;
                synchronized (map) {
                    if (!this.vgroupRuleCaches.containsKey(vgroupName)) {
                        this.vgroupRuleCaches.put(vgroupName, new ConcurrentHashMap());
                    }
                }
            }
            ConcurrentHashMap<String, String> vgroupRuleCache = this.vgroupRuleCaches.get(vgroupName);
            ConcurrentHashMap<String, String> gcache = this.globalRuleCache;
            return ConsoleConfig.this.getRuleValue0(vgroupName, key, vgroupRuleCache, gcache, this.prefix);
        }

        public void mergeRulesAndNotify() {
            this.preCount = 0;
            if (this.vgroupRules != null && !this.vgroupRules.isEmpty()) {
                for (Map.Entry<String, ConcurrentHashMap<String, String>> entry : this.vgroupRules.entrySet()) {
                    String vgroup = entry.getKey();
                    ConcurrentHashMap<String, String> rules = entry.getValue();
                    if (rules == null || rules.isEmpty()) continue;
                    try {
                        this.mergeRulesAndNotify(vgroup, rules, this.globalRules);
                    }
                    catch (Throwable e) {
                        logger.error("", String.format("failed to notify rules of %s", vgroup), e);
                    }
                    this.vgroupRuleCaches.put(vgroup, rules);
                }
            }
            this.vgroupRules = null;
            if (this.globalRules != null && !this.globalRules.isEmpty()) {
                this.globalRuleCache = this.globalRules;
            }
            this.globalRules = null;
        }

        private void mergeRulesAndNotify(String vgroup, Map<String, String> vgroupRules, Map<String, String> globalRules) {
        }

        public boolean preProcessRules(String group, String dataId, String content) {
            if (this.preCount == 0) {
                this.vgroupRules = new HashMap<String, ConcurrentHashMap<String, String>>();
                this.globalRules = new ConcurrentHashMap();
            }
            ++this.preCount;
            if (!dataId.startsWith(this.prefix) || !group.equals("TXC_GROUP")) {
                return false;
            }
            String vgroup = dataId.substring(this.prefix.length());
            assert (vgroup.length() > 0);
            if (vgroup.equals("global")) {
                if (this.globalRules == null) {
                    this.globalRules = new ConcurrentHashMap();
                }
                ConsoleConfig.this.parseRules(this.globalRules, content);
                return true;
            }
            if (this.vgroupRules == null) {
                this.vgroupRules = new HashMap<String, ConcurrentHashMap<String, String>>();
            }
            if (!this.vgroupRules.containsKey(vgroup)) {
                this.vgroupRules.put(vgroup, new ConcurrentHashMap());
            }
            ConsoleConfig.this.parseRules(this.vgroupRules.get(vgroup), content);
            return true;
        }
    }

    @JSONType
    class KeyItem {
        public String group;
        public String dataId;
        public String version;

        public KeyItem(String group, String dataId) {
            this.group = group;
            this.dataId = dataId;
        }

        public int hashCode() {
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            hashCodeBuilder.append((Object)this.group).append(',').append((Object)this.dataId);
            return hashCodeBuilder.toHashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.hashCode() == obj.hashCode();
        }

        public String toString() {
            return String.format("%s:%s", this.group, this.dataId);
        }
    }
}

