/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.taobao.txc.common.config.DiamondUtil;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class DefaultTxcConfigUtil {
    private static final Cache<String, ConcurrentHashMap<String, String>> configs = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(300000L, TimeUnit.MILLISECONDS).softValues().build();
    private String ruleArea;
    Map<String, IConfigCallback> userCallbacks = new HashMap<String, IConfigCallback>();

    public DefaultTxcConfigUtil(String ruleArea) {
        this.ruleArea = ruleArea;
    }

    public String getValue(String vgroup, String key) {
        String value = System.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            return value;
        }
        if (StringUtils.isNotEmpty((String)vgroup) && StringUtils.isNotEmpty((String)(value = this.gelRules(vgroup).get(key)))) {
            return value;
        }
        return this.gelRules("global").get(key);
    }

    protected String getValue(String key) {
        return this.getValue(null, key);
    }

    public void getValueDynamic(String key, String vgroup, IConfigCallback userCallback) {
        String value = System.getProperty(key);
        if (StringUtils.isNotEmpty((String)value)) {
            userCallback.callback(value);
            return;
        }
        if (StringUtils.isNotEmpty((String)vgroup)) {
            this.getRulesDynamic(vgroup, key, userCallback);
            return;
        }
        this.getRulesDynamic("global", key, userCallback);
    }

    public void cleanRules(String appname) {
        if (StringUtils.isEmpty((String)appname)) {
            return;
        }
        String dataid = this.ruleArea + appname;
        try {
            configs.invalidate((Object)dataid);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Map<String, String> gelRules(String appname) {
        if (StringUtils.isEmpty((String)appname)) {
            return new ConcurrentHashMap<String, String>();
        }
        final String dataid = this.ruleArea + appname;
        Map config = null;
        try {
            config = (Map)configs.get((Object)dataid, (Callable)new Callable<ConcurrentHashMap<String, String>>(){

                @Override
                public ConcurrentHashMap<String, String> call() throws Exception {
                    String rules = DiamondUtil.current().getConfig(dataid, "TXC_GROUP", 6000L);
                    ConcurrentHashMap<String, String> maps = new ConcurrentHashMap<String, String>();
                    if (rules == null) {
                        return maps;
                    }
                    StringTokenizer token = new StringTokenizer(rules, "\r\n");
                    while (token.hasMoreElements()) {
                        String rule = token.nextToken();
                        if (rule == null || rule.trim().length() == 0) continue;
                        int epos = rule.indexOf(61);
                        if (epos <= 0) {
                            throw new TxcException("invalid txc rules", TxcErrCode.TxcRuleError);
                        }
                        maps.put(rule.substring(0, epos), rule.substring(epos + 1));
                    }
                    return maps;
                }
            });
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        if (config == null) {
            throw new TxcException("unexpect", TxcErrCode.NullRuleError);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getRulesDynamic(String vgroup, String key, IConfigCallback userCallback) {
        if (StringUtils.isEmpty((String)vgroup) || StringUtils.isEmpty((String)key)) {
            return;
        }
        String dataid = this.ruleArea + vgroup;
        Map<String, IConfigCallback> map = this.userCallbacks;
        synchronized (map) {
            if (!this.userCallbacks.containsKey(key)) {
                this.userCallbacks.put(key, userCallback);
            }
        }
        if (userCallback != null && DiamondUtil.current() != null) {
            try {
                String result = DiamondUtil.current().getConfig(dataid, "TXC_GROUP");
                if (result != null) {
                    StringTokenizer token = new StringTokenizer(result, "\r\n");
                    while (token.hasMoreElements()) {
                        String rule = token.nextToken();
                        int epos = rule.indexOf(61);
                        if (epos <= 0) {
                            throw new TxcException("invalid txc rules", TxcErrCode.TxcRuleError);
                        }
                        String parseKey = rule.substring(0, epos);
                        String parseValue = rule.substring(epos + 1);
                        if (!parseKey.equals(key)) continue;
                        userCallback.callback(parseValue);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        DiamondUtil.registerDynamicConfigListener(dataid, "TXC_GROUP", new IConfigCallback(){

            @Override
            public void callback(String rules) {
                if (rules == null) {
                    for (String userKey : DefaultTxcConfigUtil.this.userCallbacks.keySet()) {
                        DefaultTxcConfigUtil.this.userCallbacks.get(userKey).callback(null);
                    }
                    return;
                }
                StringTokenizer token = new StringTokenizer(rules, "\r\n");
                while (token.hasMoreElements()) {
                    String rule = token.nextToken();
                    int epos = rule.indexOf(61);
                    if (epos <= 0) {
                        throw new TxcException("invalid txc rules", TxcErrCode.TxcRuleError);
                    }
                    String parseKey = rule.substring(0, epos);
                    String parseValue = rule.substring(epos + 1);
                    if (parseKey == null || !DefaultTxcConfigUtil.this.userCallbacks.containsKey(parseKey)) continue;
                    DefaultTxcConfigUtil.this.userCallbacks.get(parseKey).callback(parseValue);
                }
            }
        });
    }
}

