/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.DiamondTxcEnv;
import com.taobao.txc.common.config.DiamondUtil;

public class DiamondCenterUtil
extends DiamondUtil {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final String DIAMOND_CENTER_IP = "diamond.center.server.ip";
    private static final String DIAMOND_CENTER_PORT = "diamond.center.server.port";
    private static final String DIAMOND_CENTER_DEFAULT_IP = "100.100.17.97";
    private static final int DIAMOND_CENTER_DEFAULT_PORT = 8000;

    public DiamondCenterUtil() {
        String serverIp = System.getProperty(DIAMOND_CENTER_IP);
        String serverPort = System.getProperty(DIAMOND_CENTER_PORT);
        int iServerPort = this.processDiamondPort(8000);
        if (serverPort != null) {
            try {
                iServerPort = this.processDiamondPort(Integer.parseInt(serverPort));
            }
            catch (NumberFormatException e) {
                logger.warn(String.format("serverPort invalid:%s use default:%d", serverPort, 8000));
            }
        }
        if (serverIp == null || serverIp.isEmpty()) {
            logger.info(String.format("try diamond center %s port:%d", DIAMOND_CENTER_DEFAULT_IP, iServerPort));
            this.env = DiamondTxcEnv.create(iServerPort, DIAMOND_CENTER_DEFAULT_IP);
        } else {
            logger.info(String.format("try diamond center %s port:%d", serverIp, iServerPort));
            serverIp = this.processMultiDiamondIp(serverIp);
            this.env = DiamondTxcEnv.create(iServerPort, serverIp);
        }
        this.checkEnv();
    }
}

