/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.client.impl.DiamondEnvRepo;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.DiamondTxcEnv;
import com.taobao.txc.common.config.DiamondUtil;

public class DiamondDefaultUtil
extends DiamondUtil {
    private static final LoggerWrap logger = LoggerInit.logger;

    public DiamondDefaultUtil() {
        String serverIp = System.getProperty("diamond.txc.server.ip");
        if (serverIp == null || serverIp.isEmpty()) {
            serverIp = System.getProperty("diamond.server.ip");
        }
        if (serverIp == null || serverIp.isEmpty()) {
            logger.info("try diamond default");
            this.env = DiamondEnvRepo.defaultEnv;
        } else {
            String serverPort = System.getProperty("diamond.txc.server.port");
            serverIp = this.processMultiDiamondIp(serverIp);
            if (serverPort == null || serverPort.isEmpty()) {
                logger.info("try diamond " + serverIp);
                this.env = new DiamondEnv(new String[]{serverIp});
            } else {
                try {
                    int port = this.processDiamondPort(Integer.parseInt(serverPort));
                    logger.info("try diamond " + serverIp + " port " + port);
                    this.env = DiamondTxcEnv.create(port, serverIp);
                }
                catch (Exception e) {
                    logger.info("try diamond " + serverIp);
                    this.env = new DiamondEnv(new String[]{serverIp});
                }
            }
        }
        this.checkEnv();
    }
}

