/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.taobao.diamond.client.Diamond;
import com.taobao.diamond.client.impl.ClientWorker;
import com.taobao.diamond.client.impl.DiamondEnv;
import com.taobao.diamond.domain.ConfigInfo;
import com.taobao.diamond.manager.ManagerListener;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.ConfigUtil;
import com.taobao.txc.common.config.DiamondCenterUtil;
import com.taobao.txc.common.config.DiamondDefaultUtil;
import com.taobao.txc.common.config.DiamondTxcEnv;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.util.string.TxcString;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;

public abstract class DiamondUtil
implements ConfigUtil {
    protected DiamondEnv env;
    protected static int MAX_CHECK_DIAMOND_COUNT = 1000;
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final String DIAMOND_TXC_JVM_OPTS = "com.taobao.txc.jvm.opts";
    public static ConfigUtil CENTER = null;
    public static ConfigUtil DEFAULT = null;
    protected static ConfigUtil _current = null;
    public static final String SYS_PROP_TENANT_ID = "tenant.id";
    public static final String DEFAULT_TENANT_ID = "";
    public static String CURRENT_DIAMOND_TENANT_ID = null;
    private static Method SET_USER_TENANT_METHOD = null;
    private static Method GET_USER_TENANT_METHOD = null;
    public static Set<String> listenKeys;
    private static Map<String, String> diamondDynamicConfigs;
    protected LinkedHashSet<String> diamondIpList = new LinkedHashSet();
    protected int diamondPort = -1;
    protected String currentDiamondIp = null;
    private static int MAX_DIAMOND_IP_COUNT;
    protected AtomicInteger checkDiamondCount = new AtomicInteger(MAX_CHECK_DIAMOND_COUNT);
    private static Method checkDiamondMethod;

    private static void setUserTenantAndCheck(String tenant) {
        if (SET_USER_TENANT_METHOD == null || tenant == null) {
            logger.warn("Not able to set tenant [" + tenant + "] with " + SET_USER_TENANT_METHOD);
            return;
        }
        try {
            SET_USER_TENANT_METHOD.invoke(null, tenant);
            Object done = GET_USER_TENANT_METHOD.invoke(null, new Object[0]);
            if (!tenant.equals(done)) {
                throw new RuntimeException("tenant setting exception");
            }
            logger.info("user tenant is changed to [" + tenant + "]");
        }
        catch (Throwable ex) {
            logger.warn("Failed to setUserTenantAndCheck to [" + tenant + "]", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConfigUtil current() {
        if (_current != null) return _current;
        Class<DiamondUtil> clazz = DiamondUtil.class;
        synchronized (DiamondUtil.class) {
            if (_current != null || DEFAULT != null) return _current;
            try {
                _current = CENTER = new DiamondCenterUtil();
            }
            catch (TxcException e) {
                if (e.getErrcode() != TxcErrCode.DiamondCenterAccessError) throw e;
                TxcConfigHolder.setConsoleConfig(true);
                logger.warn(String.format("diamond center failed, switch to console config", new Object[0]));
            }
            return _current;
        }
    }

    protected void checkEnv() {
        try {
            String dataId = "com.taobao.txc.rules.global";
            String group = "TXC_GROUP";
            String rule = this.getConfig(dataId, group, 5000L);
            if (rule == null) {
                throw new TxcException(TxcErrCode.DiamondCenterAccessError);
            }
            logger.info("Env " + this.env + " with global rule [" + rule + "]");
        }
        catch (Throwable e) {
            logger.error(DEFAULT_TENANT_ID, "It's NOT a GTS env " + this.env + " since " + e.getMessage(), e);
            throw new TxcException(TxcErrCode.DiamondCenterAccessError);
        }
    }

    @Override
    public boolean publishSingle(String dataId, String group, String content) {
        return this.env.publishSingle(dataId, group, content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(String dataId, String group, ITxcManagerListener listener) {
        if (CURRENT_DIAMOND_TENANT_ID == null) {
            this.addListener0(dataId, group, listener);
        } else {
            try {
                DiamondUtil.setUserTenantAndCheck(DEFAULT_TENANT_ID);
                this.addListener0(dataId, group, listener);
            }
            finally {
                DiamondUtil.setUserTenantAndCheck(CURRENT_DIAMOND_TENANT_ID);
            }
        }
        logger.info("added listener on " + dataId + "(" + group + ")");
    }

    private void addListener0(String dataId, String group, final ITxcManagerListener listener) {
        this.env.addListeners(dataId, group, Arrays.asList(new ManagerListener(){

            public Executor getExecutor() {
                return listener.getExecutor();
            }

            public void receiveConfigInfo(String routeRule) {
                listener.receiveConfigInfo(routeRule);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(String dataId, String group, ITxcManagerListener listener) {
        if (CURRENT_DIAMOND_TENANT_ID == null) {
            this.removeListener0(dataId, group, listener);
        } else {
            try {
                DiamondUtil.setUserTenantAndCheck(DEFAULT_TENANT_ID);
                this.removeListener0(dataId, group, listener);
            }
            finally {
                DiamondUtil.setUserTenantAndCheck(CURRENT_DIAMOND_TENANT_ID);
            }
        }
        logger.info("removed listener on " + dataId + "(" + group + ")");
    }

    private void removeListener0(String dataId, String group, final ITxcManagerListener listener) {
        this.env.removeListener(dataId, group, new ManagerListener(){

            public Executor getExecutor() {
                return listener.getExecutor();
            }

            public void receiveConfigInfo(String routeRule) {
                listener.receiveConfigInfo(routeRule);
            }
        });
    }

    @Override
    public boolean publishAggr(String dataId, String group, String datumId, String content) {
        for (int i = 0; i < 10; ++i) {
            if (!this.env.publishAggr(dataId, group, datumId, content)) continue;
            return true;
        }
        throw new TxcException("publishAggr " + dataId + " timeout", TxcErrCode.DiamondPublishAggrError);
    }

    @Override
    public boolean remove(String dataId, String group) {
        return this.env.remove(dataId, group);
    }

    @Override
    public boolean removeAggr(String dataId, String group, String datumId) {
        return this.env.removeAggr(dataId, group, datumId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigByDiamond(String dataId, String group, long timeoutMs) throws IOException {
        if (CURRENT_DIAMOND_TENANT_ID == null) {
            return Diamond.getConfig((String)dataId, (String)group, (long)timeoutMs);
        }
        try {
            DiamondUtil.setUserTenantAndCheck(DEFAULT_TENANT_ID);
            String string = Diamond.getConfig((String)dataId, (String)group, (long)timeoutMs);
            return string;
        }
        finally {
            DiamondUtil.setUserTenantAndCheck(CURRENT_DIAMOND_TENANT_ID);
        }
    }

    @Override
    public String getConfig(String dataId, String group) {
        long timeoutMs = 5000L;
        while (true) {
            try {
                String data = this.getConfig(dataId, group, timeoutMs);
                return data;
            }
            catch (IOException e) {
                logger.error(TxcErrCode.DiamondGetConfig.errCode, TxcErrCode.DiamondGetConfig.errMessage, e.getMessage());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                }
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        if (CURRENT_DIAMOND_TENANT_ID == null) {
            String content = this.getConfig0(dataId, group, timeoutMs);
            logger.info("getConfig on " + dataId + "(" + group + ") = " + content);
            return content;
        }
        try {
            DiamondUtil.setUserTenantAndCheck(DEFAULT_TENANT_ID);
            String content = this.getConfig0(dataId, group, timeoutMs);
            logger.info("getConfig on " + dataId + "(" + group + ") = " + content);
            String string = content;
            return string;
        }
        finally {
            DiamondUtil.setUserTenantAndCheck(CURRENT_DIAMOND_TENANT_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getConfig0(String dataId, String group, long timeoutMs) throws IOException {
        String data = this.env.getConfig(dataId, group, timeoutMs);
        if (this.checkDiamondCount.incrementAndGet() > MAX_CHECK_DIAMOND_COUNT) {
            DiamondUtil diamondUtil = this;
            synchronized (diamondUtil) {
                if (this.checkDiamondCount.get() > MAX_CHECK_DIAMOND_COUNT) {
                    this.checkDiamondCount.set(0);
                    data = this.retryUpdateDiamondEnv(dataId, group, timeoutMs);
                }
            }
        }
        logger.info(String.format("dataid:%s,group:%s,result:%s", dataId, group, data));
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDynamicConfigListener(final String dataId, final String group, final IConfigCallback configCallback) {
        final String diamondId = TxcString.genUniqDiamondId(dataId, group);
        if (listenKeys == null) {
            listenKeys = new HashSet<String>();
        }
        if (listenKeys.contains(diamondId)) {
            return;
        }
        if (_current == null || !_current.isValid()) {
            return;
        }
        Set<String> set = listenKeys;
        synchronized (set) {
            if (listenKeys.contains(diamondId)) {
                return;
            }
            listenKeys.add(diamondId);
            DiamondUtil.current().addListener(dataId, group, new ITxcManagerListener(){

                @Override
                public Executor getExecutor() {
                    return null;
                }

                @Override
                public void receiveConfigInfo(String configInfo) {
                    if (configInfo == null) {
                        configCallback.callback(configInfo);
                        DiamondUtil.current().removeListener(dataId, group, this);
                        listenKeys.remove(diamondId);
                    } else {
                        configCallback.callback(configInfo);
                    }
                }
            });
        }
    }

    @Override
    public boolean isValid() {
        return this.env != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processMultiDiamondIp(String serverIp) {
        this.currentDiamondIp = serverIp;
        StringTokenizer stringTokenizer = new StringTokenizer(serverIp, ",");
        while (stringTokenizer.hasMoreElements()) {
            String ip = stringTokenizer.nextToken().trim();
            DiamondUtil diamondUtil = this;
            synchronized (diamondUtil) {
                if (!StringUtils.isEmpty((String)ip)) {
                    this.diamondIpList.add(ip);
                }
            }
        }
        if (this.diamondIpList.size() > 1) {
            this.currentDiamondIp = (String)this.diamondIpList.iterator().next();
        }
        return this.currentDiamondIp;
    }

    protected int processDiamondPort(int port) {
        this.diamondPort = port;
        return this.diamondPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String retryUpdateDiamondEnv(String dataId, String group, long timeoutMs) {
        try {
            Object rt;
            if (checkDiamondMethod == null) {
                Class<DiamondUtil> clazz = DiamondUtil.class;
                // MONITORENTER : com.taobao.txc.common.config.DiamondUtil.class
                if (checkDiamondMethod == null) {
                    checkDiamondMethod = ClientWorker.class.getDeclaredMethod("getServerConfig", DiamondEnv.class, String.class, String.class, Long.TYPE);
                    checkDiamondMethod.setAccessible(true);
                }
                // MONITOREXIT : clazz
            }
            if ((rt = checkDiamondMethod.invoke(null, this.env, dataId, group, timeoutMs)) == null) {
                return null;
            }
            if (rt instanceof String) {
                return (String)rt;
            }
            if (!(rt instanceof ConfigInfo)) throw new RuntimeException("Unknown return Type of " + checkDiamondMethod);
            return ((ConfigInfo)rt).getContent();
        }
        catch (InvocationTargetException e) {
            if (!(e.getTargetException() instanceof ConnectException)) return null;
            if (this.diamondIpList.size() > 1) {
                try {
                    return this.updateDiamondAndGetConfig(dataId, group, timeoutMs);
                }
                catch (Exception e1) {
                    logger.error(TxcErrCode.DiamondGetConfigTryAll.errCode, TxcErrCode.DiamondGetConfigTryAll.errMessage, e1.getMessage());
                }
            }
            this.checkDiamondCount.set(MAX_CHECK_DIAMOND_COUNT);
            return null;
        }
        catch (Exception e) {
            logger.warn("invoke check Diamond method exception", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateDiamondAndGetConfig(String dataId, String group, long timeout) throws IOException {
        String ip = this.getNextDiamondIp(this.currentDiamondIp);
        StringBuffer usedIps = new StringBuffer();
        for (int i = 0; !StringUtils.isEmpty((String)ip) && !ip.equals(this.currentDiamondIp) && i < MAX_DIAMOND_IP_COUNT; ++i) {
            DiamondEnv newEnv = this.diamondPort == -1 ? new DiamondEnv(new String[]{ip}) : DiamondTxcEnv.create(this.diamondPort, ip);
            try {
                String data = (String)checkDiamondMethod.invoke(null, newEnv, dataId, group, timeout);
                DiamondUtil diamondUtil = this;
                synchronized (diamondUtil) {
                    this.currentDiamondIp = ip;
                    this.env = newEnv;
                }
                return data;
            }
            catch (Exception e) {
                usedIps.append(ip).append(' ');
                ip = this.getNextDiamondIp(ip);
                continue;
            }
        }
        throw new RuntimeException(usedIps.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextDiamondIp(String currentIp) {
        if (this.diamondIpList.size() <= 1) {
            return null;
        }
        Iterator iter = this.diamondIpList.iterator();
        String headIp = null;
        int i = 0;
        DiamondUtil diamondUtil = this;
        synchronized (diamondUtil) {
            while (iter.hasNext()) {
                String ip = (String)iter.next();
                if (headIp == null) {
                    headIp = ip;
                }
                if (StringUtils.isEmpty((String)currentIp)) {
                    return headIp;
                }
                if (ip.equals(currentIp)) {
                    if (iter.hasNext()) {
                        String nextIp = (String)iter.next();
                        return nextIp;
                    }
                    return headIp;
                }
                if (i > MAX_DIAMOND_IP_COUNT) {
                    return null;
                }
                ++i;
            }
        }
        return null;
    }

    static {
        if (!TxcConfigHolder.isConsoleConfig()) {
            logger.info("Init Diamond Env on 2.8.69");
            String tenantId = System.getProperty(SYS_PROP_TENANT_ID);
            if (tenantId != null && !tenantId.isEmpty()) {
                CURRENT_DIAMOND_TENANT_ID = tenantId;
                logger.info("Working in Diamond Env of tenant [" + CURRENT_DIAMOND_TENANT_ID + "]");
                try {
                    Class<?> tenantUtilClz = Class.forName("com.taobao.diamond.client.impl.TenantUtil");
                    SET_USER_TENANT_METHOD = tenantUtilClz.getMethod("setUserTenant", String.class);
                    GET_USER_TENANT_METHOD = tenantUtilClz.getMethod("getUserTenant", new Class[0]);
                }
                catch (Throwable ex) {
                    logger.warn("Diamond Tenant Check Failed ", ex);
                }
            } else {
                logger.info("Working in Diamond Env of default tenant");
            }
            try {
                String jvmOpts = DiamondUtil.getConfigByDiamond(DIAMOND_TXC_JVM_OPTS, "TXC_GROUP", 5000L);
                if (!StringUtils.isEmpty((String)jvmOpts)) {
                    logger.info("get txc jvm opts: " + jvmOpts);
                    Properties properties = System.getProperties();
                    Map<String, String> opts = TxcString.parseTxcJvmOpts(jvmOpts);
                    for (String key : opts.keySet()) {
                        properties.put(key, opts.get(key));
                    }
                    System.setProperties(properties);
                }
            }
            catch (Throwable e) {
                logger.info("Ignore Default Env init failed since " + e.getMessage() + " cause " + e.getCause());
            }
            try {
                _current = DEFAULT = new DiamondDefaultUtil();
            }
            catch (Throwable e) {
                logger.warn("Init failed on default diamond since " + e.getMessage() + " cause " + e.getCause());
            }
        }
        diamondDynamicConfigs = new HashMap<String, String>();
        MAX_DIAMOND_IP_COUNT = 50;
        checkDiamondMethod = null;
    }
}

