/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.config;

import com.taobao.middleware.logger.Level;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcIsolation;
import com.taobao.txc.common.config.ConsoleConfig;
import com.taobao.txc.common.config.DefaultTxcConfigUtil;
import com.taobao.txc.common.config.DiamondUtil;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.util.http.HttpSecurity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TxcConfigHolder {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final TxcConfigHolder instance = new TxcConfigHolder();
    public static final String FORCE_CONSOLE = "txc.force.console";
    public static final String loggerLevelKey = "txc.log.level";
    public static final String checkAuthKey = "txc.check.auth";
    public static final String cleanOldUndoLogDaysKey = "txc.clean.days";
    public static final String weightKey = "txc.weight";
    public static final String vipSkipKey = "txc.vip.skip";
    public static final String skipVipKey = "txc.skip.vip";
    public static final String enableDegrade = "txc.degrade.enable";
    public static final String degradeCount = "txc.degrade.count";
    public static final String upgradeCount = "txc.upgrade.count";
    public static final String enableClusterSwitch = "txc.cluster.switch.enable";
    public static final String clusterSwitchThreshold = "txc.cluster.switch.threshold";
    public static final String disableTxc = "txc.disable";
    public static final String reentry4drds = "txc.drds.reentry";
    public static final String enableAnalyze = "txc.analyze.enable";
    public static final String analyzeClean = "txc.analyze.clean";
    public static final String tableKeywordsKey = "txc.table.keywords";
    public static final String checkAuthLevel = "txc.check.authlevel";
    public static final String dummyRule = "txc.dummy";
    public static final String rollbackTimeout = "txc.rollback.timeout";
    private static final String tidInterval = "txc.tid.interval";
    private static final String backlogKey = "txc.backlog";
    private static final String recordLimitWarnKey = "txc.recordlimit.warn";
    private static final String recordLimitErrorKey = "txc.recordlimit.error";
    private static final String hexUndoLogKey = "txc.hex.undolog";
    private static final String serverlimitTimesKey = "txc.limit.times";
    private static final String maxConnectRetry = "txc.connect.retry";
    public static boolean isConsoleConfig = false;
    private boolean lastReentry4drds = true;
    private static String group = null;
    private static int recordLimitWarn = 0;
    private static int recordLimitError = 0;
    private static int maxConnectRetryTime = 500;
    private long sendAlertLastTime = 0L;
    private static int sendAlertMaxInterval;
    public static final String ALERT_DIAMOND_KEY = "com.taobao.txc.alert.%s";
    private static final int ALARM_MAX_LEN = 1024;
    private ExecutorService sendAlertExecutor = Executors.newSingleThreadExecutor();
    private ReentrantLock sendAlertLock = new ReentrantLock();
    private AtomicInteger sendAlertCount = new AtomicInteger(0);
    private AtomicInteger sendAlertTotalScore = new AtomicInteger(0);
    private StringBuffer alarmMessage = new StringBuffer();
    public static final int CRITICAL_ALARM_SCORE = 10;
    public static final int MINOR_ALARM_SCORE = 2;
    public static final int WARNING_SCORE = 1;
    private static final int SEND_ALARM_MIN_SCORE = 20;
    private DefaultTxcConfigUtil diamondConfig = new DefaultTxcConfigUtil("com.taobao.txc.rules.");
    private DefaultTxcConfigUtil serverDiamondConfig = null;
    private static String instanceId;
    private static ConcurrentHashMap<String, List<Pattern>> patternsMap;
    private volatile Map<String, String> ripToVipMap = new ConcurrentHashMap<String, String>();
    private volatile Map<String, String> vipToRipMap = new ConcurrentHashMap<String, String>();
    private boolean vipCanBeSkipped = true;

    public static String getInstanceId() {
        if (instanceId == null || instanceId.length() == 0) {
            instanceId = System.getProperty("instanceId");
        }
        if (instanceId == null || instanceId.length() == 0) {
            instanceId = System.getProperty("cluster");
        }
        return instanceId;
    }

    public static String getGroup() {
        return group;
    }

    public static void setGroup(String group) {
        TxcConfigHolder.group = group;
        LoggerInit.logger.getDynamicLogLevel();
        recordLimitWarn = instance.getRecordLimitWarn0();
        recordLimitError = instance.getRecordLimitError0();
        maxConnectRetryTime = instance.getMaxConnectRetryTime0();
    }

    public int getRecordLimitWarn() {
        return recordLimitWarn;
    }

    public int getRecordLimitError() {
        return recordLimitError;
    }

    public int getMaxConnectRetryTime() {
        return maxConnectRetryTime;
    }

    public static void setConsoleConfig(boolean isConsoleConfig) {
        String consoleConfig = System.getProperty("txc.console.config");
        try {
            if (!StringUtils.isEmpty((String)consoleConfig) && !Boolean.parseBoolean(consoleConfig)) {
                System.out.println("Manually turn off console config");
            } else {
                TxcConfigHolder.isConsoleConfig = isConsoleConfig;
            }
        }
        catch (Exception e) {
            TxcConfigHolder.isConsoleConfig = isConsoleConfig;
        }
    }

    public static void setConsoleConfig(boolean isConsoleConfig, String url) {
        String consoleConfig = System.getProperty("txc.console.config");
        try {
            if (!StringUtils.isEmpty((String)consoleConfig) && !Boolean.parseBoolean(consoleConfig)) {
                System.out.println("Manually turn off console config");
            } else {
                TxcConfigHolder.isConsoleConfig = isConsoleConfig;
            }
        }
        catch (Exception e) {
            TxcConfigHolder.isConsoleConfig = isConsoleConfig;
        }
        if (TxcConfigHolder.isConsoleConfig) {
            new ConsoleConfig(url);
        }
    }

    public static boolean isConsoleConfig() {
        return isConsoleConfig;
    }

    public static TxcConfigHolder getInstance() {
        return instance;
    }

    public String getConfig(String dataId, String group, long timeoutMs) throws IOException {
        if (isConsoleConfig) {
            return ConsoleConfig.getInstance().getConfig(dataId, group, timeoutMs);
        }
        return DiamondUtil.current().getConfig(dataId, group, timeoutMs);
    }

    public String getConfig(String dataId, String group) {
        if (isConsoleConfig) {
            return ConsoleConfig.getInstance().getConfig(dataId, group);
        }
        return DiamondUtil.current().getConfig(dataId, group);
    }

    public void getRuleDynamic(String key, String group, IConfigCallback userCallback) {
        if (isConsoleConfig) {
            ConsoleConfig.getInstance().addRuleDynamic(key, group, userCallback);
        } else {
            this.diamondConfig.getValueDynamic(key, group, userCallback);
        }
    }

    public boolean putSingle(String dataId, String group, String content) {
        if (isConsoleConfig) {
            return ConsoleConfig.getInstance().putSingle(dataId, group, content);
        }
        return DiamondUtil.current().publishSingle(dataId, group, content);
    }

    public boolean putSingle(String dataId, String group, String content, HttpSecurity httpSecurity) {
        if (isConsoleConfig) {
            return ConsoleConfig.getInstance().putSingle(dataId, group, content, httpSecurity);
        }
        return DiamondUtil.current().publishSingle(dataId, group, content);
    }

    public boolean putAggr(String dataId, String group, String datumId, String content) {
        if (TxcConfigHolder.isConsoleConfig()) {
            return ConsoleConfig.getInstance().putAggr(dataId, group, datumId, content);
        }
        return DiamondUtil.current().publishAggr(dataId, group, datumId, content);
    }

    public boolean removeAggr(String dataId, String group, String datumId) {
        if (TxcConfigHolder.isConsoleConfig()) {
            return ConsoleConfig.getInstance().removeAggr(dataId, group, datumId);
        }
        return DiamondUtil.current().removeAggr(dataId, group, datumId);
    }

    public void addListener(String dataId, String group, ITxcManagerListener listener) {
        if (isConsoleConfig) {
            ConsoleConfig.getInstance().addListener(dataId, group, listener);
        } else {
            DiamondUtil.current().addListener(dataId, group, listener);
        }
    }

    public void removeListener(String dataId, String group, ITxcManagerListener listener) {
        if (isConsoleConfig) {
            ConsoleConfig.getInstance().removeListener(dataId, group, listener);
        } else {
            DiamondUtil.current().removeListener(dataId, group, listener);
        }
    }

    public String getRuleValue(String vgroupname, String key) {
        if (isConsoleConfig) {
            return ConsoleConfig.getInstance().getRuleValue(vgroupname, key);
        }
        return this.diamondConfig.getValue(vgroupname, key);
    }

    public boolean isTxcDisable(String vgroupname) {
        String isTxcDisable = this.getRuleValue(vgroupname, disableTxc);
        return isTxcDisable != null && isTxcDisable.equalsIgnoreCase("true");
    }

    public void checkTxcDisable(String vgroup, IConfigCallback userCallback) {
        this.getRuleDynamic(disableTxc, vgroup, userCallback);
    }

    public void checkTxcDegradeCount(String vgroup, IConfigCallback userCallback) {
        this.getRuleDynamic(degradeCount, vgroup, userCallback);
    }

    public void checkTxcUpgradeCount(String vgroup, IConfigCallback userCallback) {
        this.getRuleDynamic(upgradeCount, vgroup, userCallback);
    }

    public void checkTxcClusterSwitchThreshold(String vgroup, IConfigCallback userCallback) {
        this.getRuleDynamic(clusterSwitchThreshold, vgroup, userCallback);
    }

    public Integer getCleanOldUndoLogDays(String vgroup) {
        String cleanOldUndoLogInterval = null;
        cleanOldUndoLogInterval = this.getRuleValue(vgroup, cleanOldUndoLogDaysKey);
        if (StringUtils.isEmpty((String)cleanOldUndoLogInterval)) {
            return null;
        }
        Integer result = null;
        try {
            result = Integer.parseInt(cleanOldUndoLogInterval);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public void getLoggerLevelDynamic(IConfigCallback userCallback) {
        this.getRuleDynamic(loggerLevelKey, group, userCallback);
    }

    public void getTableKeywordsDynamic(IConfigCallback userCallback) {
        this.getRuleDynamic(tableKeywordsKey, group, userCallback);
    }

    public void getCheckAuthFlag(IConfigCallback userCallback) {
        this.getRuleDynamic(checkAuthKey, group, userCallback);
    }

    public long getCheckAuthLevel() {
        try {
            String level = this.getRuleValue(group, checkAuthLevel);
            if (StringUtils.isNumeric((String)level)) {
                return Long.parseLong(level);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1L;
    }

    public void getWeightDynamic(IConfigCallback userCallback) {
        this.getRuleDynamic(weightKey, group, userCallback);
    }

    public void getEnableDegrade(IConfigCallback userCallback) {
        this.getRuleDynamic(enableDegrade, group, userCallback);
    }

    public void getEnableClusterSwitch(IConfigCallback userCallback) {
        this.getRuleDynamic(enableClusterSwitch, group, userCallback);
    }

    public static Level convertLoggerLevel(String logLevel) {
        if (StringUtils.isEmpty((String)logLevel)) {
            return Level.INFO;
        }
        if (logLevel.equalsIgnoreCase("DEBUG")) {
            return Level.DEBUG;
        }
        if (logLevel.equalsIgnoreCase("WARN")) {
            return Level.WARN;
        }
        if (logLevel.equalsIgnoreCase("ERROR")) {
            return Level.ERROR;
        }
        return Level.INFO;
    }

    public boolean isSupportReGetXid() {
        String reentry = this.getRuleValue(group, reentry4drds);
        if (StringUtils.isEmpty((String)reentry)) {
            return this.lastReentry4drds;
        }
        if (reentry.equalsIgnoreCase("true")) {
            this.lastReentry4drds = true;
            return true;
        }
        this.lastReentry4drds = false;
        return false;
    }

    public long getTxcTimeOut(String vgroup) {
        try {
            String time = this.getRuleValue(vgroup, "txc.timeout");
            if (StringUtils.isNumeric((String)time)) {
                return Long.parseLong(time);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 600000L;
    }

    public int getRetryTimesWhenLockConflict(String vgroup) {
        try {
            String times = this.getRuleValue(vgroup, "txc.retry.times");
            if (StringUtils.isNumeric((String)times)) {
                return Integer.parseInt(times);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 10;
    }

    public boolean getDefaultMtStatus(String vgroup) {
        try {
            String status = this.getRuleValue(vgroup, "txc.mt.default.status");
            if (StringUtils.isEmpty((String)status)) {
                return true;
            }
            return !status.equalsIgnoreCase("false");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getHotDataStrategy(String vgroupname) {
        String strategy = this.getRuleValue(vgroupname, "txc.hot.data.strategy");
        return strategy;
    }

    public TxcIsolation getTxcGolbalLockMode(String vgroupname) {
        TxcIsolation trxLevel = TxcIsolation.READ_COMMITED;
        String isolation = this.getRuleValue(vgroupname, "txc.globallock");
        if (StringUtils.isNotEmpty((String)isolation) && StringUtils.isNumeric((String)isolation)) {
            trxLevel = TxcIsolation.valueOf(Integer.parseInt(isolation));
        }
        return trxLevel;
    }

    public List<Pattern> getTablePatterns(String vgroupname) {
        String value = this.getRuleValue(vgroupname, "txc.table.patterns");
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        List<Pattern> patternList = patternsMap.get(value);
        if (patternList == null) {
            String[] patternStrs;
            patternList = new ArrayList<Pattern>();
            for (String patternStr : patternStrs = value.split(";")) {
                patternList.add(Pattern.compile(patternStr));
            }
            patternsMap.putIfAbsent(value, patternList);
        }
        return patternList;
    }

    public static boolean getSkipVip(boolean defaultValue) {
        String value = System.getProperty(vipSkipKey);
        if (StringUtils.isEmpty((String)value) && StringUtils.isEmpty((String)(value = System.getProperty(skipVipKey)))) {
            return defaultValue;
        }
        boolean ret = defaultValue;
        try {
            ret = Boolean.parseBoolean(value);
        }
        catch (Exception ignore) {
            logger.warn("illegal value for [txc.vip.skip/txc.skip.vip]: " + value);
        }
        return ret;
    }

    public boolean isAnalyzeEnabled() {
        try {
            String value = this.getRuleValue(group, enableAnalyze);
            if ("true".equalsIgnoreCase(value)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int getAnalyzeClean() {
        try {
            String value = this.getRuleValue(group, analyzeClean);
            if (StringUtils.isEmpty((String)value)) {
                return 7;
            }
            return Integer.parseInt(value);
        }
        catch (Exception exception) {
            return 7;
        }
    }

    public int getBacklog() {
        try {
            String v = this.getRuleValue(group, backlogKey);
            if (!StringUtils.isEmpty((String)v)) {
                return Integer.parseInt(v);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public long getTidInterval() {
        try {
            long vl;
            String v = this.getRuleValue(group, tidInterval);
            if (!StringUtils.isEmpty((String)v) && (vl = (long)Integer.parseInt(v)) > 999999L && vl < 500000001L) {
                return vl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 200000000L;
    }

    private int getRecordLimitWarn0() {
        try {
            String v = this.getRuleValue(group, recordLimitWarnKey);
            if (!StringUtils.isEmpty((String)v)) {
                int l = Integer.parseInt(v);
                if (l < 100 && l != 0) {
                    return 0;
                }
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 10000;
    }

    private int getRecordLimitError0() {
        try {
            String v = this.getRuleValue(group, recordLimitErrorKey);
            if (!StringUtils.isEmpty((String)v)) {
                int l = Integer.parseInt(v);
                if (l < 100 && l != 0) {
                    return 0;
                }
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 50000;
    }

    private int getMaxConnectRetryTime0() {
        try {
            String value = this.getRuleValue(group, maxConnectRetry);
            if (!StringUtils.isEmpty((String)value)) {
                int l = Integer.parseInt(value);
                if (l < 10) {
                    l = 10;
                }
                return l;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1000;
    }

    public boolean isHexUndoLog() {
        try {
            String v = this.getRuleValue(group, hexUndoLogKey);
            if (!StringUtils.isEmpty((String)v) && (v.equals("1") || Boolean.valueOf(v).booleanValue())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAlertWithDelay(String group, String content, int severityScore, final HttpSecurity httpSecurity) {
        block10: {
            if (group == null) {
                return;
            }
            try {
                long currTime;
                this.sendAlertCount.incrementAndGet();
                this.sendAlertTotalScore.addAndGet(severityScore);
                if (this.alarmMessage.length() < 1024) {
                    this.alarmMessage.append('\n').append(Calendar.getInstance().getTime()).append('\t').append(content);
                }
                if ((currTime = System.currentTimeMillis()) - this.sendAlertLastTime <= (long)sendAlertMaxInterval || this.sendAlertTotalScore.get() < 20) break block10;
                try {
                    this.sendAlertLock.lock();
                    if (currTime - this.sendAlertLastTime > (long)sendAlertMaxInterval && this.sendAlertTotalScore.get() >= 20) {
                        this.sendAlertLastTime = currTime;
                        final String dataId = String.format(ALERT_DIAMOND_KEY, group);
                        final String finalContent = "Alarm times:" + this.sendAlertCount.intValue() + this.alarmMessage.toString();
                        this.alarmMessage.setLength(0);
                        this.sendAlertCount.set(0);
                        this.sendAlertTotalScore.set(0);
                        this.sendAlertExecutor.submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (httpSecurity == null) {
                                        TxcConfigHolder.getInstance().putSingle(dataId, "TXC_GROUP", finalContent);
                                    } else {
                                        TxcConfigHolder.getInstance().putSingle(dataId, "TXC_GROUP", finalContent, httpSecurity);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    this.sendAlertLock.unlock();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void enableServerRule(String prefix) {
        this.serverDiamondConfig = new DefaultTxcConfigUtil(prefix);
        ConsoleConfig.enableServerRule(prefix);
    }

    private int getServerIntRuleValue(String vgroupname, String key, int def) {
        try {
            String str = isConsoleConfig ? ConsoleConfig.getInstance().getServerRuleValue(vgroupname, key) : this.serverDiamondConfig.getValue(vgroupname, key);
            if (StringUtils.isNumeric((String)str)) {
                return Integer.parseInt(str);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    public int getServerLimitationTimes(String vgroupname) {
        return this.getServerIntRuleValue(vgroupname, serverlimitTimesKey, 0);
    }

    public boolean isVipCanBeSkipped() {
        return this.vipCanBeSkipped;
    }

    public void setVipCanBeSkipped(boolean vipCanBeSkipped) {
        this.vipCanBeSkipped = vipCanBeSkipped;
    }

    public String lookupVIP(String rip) {
        return this.ripToVipMap.get(rip);
    }

    public String lookupRIP(String vip) {
        return this.vipToRipMap.get(vip);
    }

    public void updateVIPMapping(String serverAddress, String vipAddress) {
        if (vipAddress == null) {
            String oldVIP = this.ripToVipMap.remove(serverAddress);
            if (oldVIP != null) {
                this.vipToRipMap.remove(oldVIP);
            }
            logger.info("no vip for " + serverAddress + ": " + oldVIP);
        } else {
            this.ripToVipMap.put(serverAddress, vipAddress);
            this.vipToRipMap.put(vipAddress, serverAddress);
            logger.info(String.format("add new vip server mapping:%s ==> %s", serverAddress, vipAddress));
        }
    }

    public Long getRollbackTimeoutInMillisecond() {
        try {
            String value = this.getRuleValue(group, rollbackTimeout);
            if (!StringUtils.isEmpty((String)value) && StringUtils.isNumeric((String)value.trim())) {
                return Long.parseLong(value.trim());
            }
        }
        catch (Exception ignore) {
            logger.warn("invalid %s value, use default config: %d", rollbackTimeout, 30000L);
        }
        return 30000L;
    }

    public static void main(String[] args) {
        boolean reentry = TxcConfigHolder.getInstance().isSupportReGetXid();
        System.out.println(reentry);
        TxcConfigHolder.setGroup("xunmo");
        while (true) {
            reentry = TxcConfigHolder.getInstance().isSupportReGetXid();
            System.out.println("" + System.currentTimeMillis() + ":" + reentry);
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    static {
        try {
            String forceConsole = System.getProperty(FORCE_CONSOLE);
            if (!StringUtils.isEmpty((String)forceConsole) && (forceConsole.equals("1") || Boolean.valueOf(forceConsole).booleanValue())) {
                isConsoleConfig = true;
                System.out.println("txc force console config is true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        sendAlertMaxInterval = 600000;
        instanceId = null;
        patternsMap = new ConcurrentHashMap();
    }
}

