/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.context;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.context.ITxcContextOperate;
import com.taobao.txc.common.context.TxcContextOperateByThreadLocal;
import com.taobao.txc.common.util.serviceloader.EnhancedServiceLoader;

public class TxcContextOperateHelper {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static ITxcContextOperate txcContext = null;

    public static String getUserData(String key) {
        return txcContext.getUserData(key);
    }

    public static String putUserData(String key, String value) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[Thread:%d] set Thread Context [%s:%s]", Thread.currentThread().getId(), key, value));
        }
        return txcContext.putUserData(key, value);
    }

    public static String removeUserData(String key) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[Thread:%d] del Thread Context [%s]", Thread.currentThread().getId(), key));
        }
        return txcContext.removeUserData(key);
    }

    public static Object getRpcContext() {
        return txcContext.getRpcContext();
    }

    static {
        txcContext = EnhancedServiceLoader.load(ITxcContextOperate.class);
        if (txcContext != null && txcContext.isSucessed()) {
            logger.info("EnhancedServiceLoader load txcContext engine:" + txcContext.getClass());
        } else {
            logger.warn("EnhancedServiceLoader load txcContext engine error, use default.");
            txcContext = new TxcContextOperateByThreadLocal();
        }
    }
}

