/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.exception;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.message.ResultCode;
import java.sql.SQLException;

public class TxcException
extends RuntimeException {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final long serialVersionUID = 5531074229174745826L;
    private final int result;
    private final TxcErrCode errcode;

    public TxcException(int result, String msg) {
        this(null, msg, result, TxcErrCode.UnknownAppError);
    }

    public TxcException() {
        this(TxcErrCode.UnknownAppError);
    }

    public TxcException(TxcErrCode err) {
        this(err.errMessage, err);
    }

    public TxcException(String msg) {
        this(msg, TxcErrCode.UnknownAppError);
    }

    public TxcException(String msg, TxcErrCode errCode) {
        this(null, msg, ResultCode.SYSTEMERROR.getValue(), errCode);
    }

    public TxcException(Throwable th, String msg, TxcErrCode errCode) {
        this(th, msg, ResultCode.SYSTEMERROR.getValue(), errCode);
    }

    public TxcException(Throwable th) {
        this(th, th.getMessage());
    }

    public TxcException(Throwable th, String msg) {
        this(th, msg, ResultCode.SYSTEMERROR.getValue(), TxcErrCode.UnknownAppError);
    }

    public TxcException(Throwable cause, String msg, int result, TxcErrCode errCode) {
        super(msg, cause);
        this.result = result;
        this.errcode = errCode;
    }

    public int getResult() {
        return this.result;
    }

    public TxcErrCode getErrcode() {
        return this.errcode;
    }

    public static TxcException nestedException(Throwable e) {
        return TxcException.nestedException("", e);
    }

    public static TxcException nestedException(String msg, Throwable e) {
        if (e instanceof TxcException) {
            return (TxcException)e;
        }
        return new TxcException(e, msg);
    }

    public static SQLException nestedSQLException(Throwable e) {
        return TxcException.nestedSQLException("", e);
    }

    public static SQLException nestedSQLException(String msg, Throwable e) {
        logger.error(msg, e.getMessage(), e);
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return new SQLException(e);
    }
}

