/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.lifecycle;

import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.lifecycle.Lifecycle;

public class AbstractLifecycle
implements Lifecycle {
    protected final Object lock = new Object();
    protected volatile boolean isInited = false;
    protected boolean useTryLock = false;
    private volatile boolean locked = false;
    private volatile boolean available = true;
    private Throwable lastError = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        boolean needReleaseLock = this.checkAvailableAndGetLock();
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.isInited()) {
                    return;
                }
                try {
                    this.doInit();
                    this.isInited = true;
                    this.available = true;
                }
                catch (Throwable e) {
                    this.lastError = e;
                    this.available = false;
                    try {
                        this.doDestroy();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw TxcException.nestedException(e);
                }
            }
            finally {
                if (needReleaseLock) {
                    this.clearLock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isInited()) {
                return;
            }
            this.doDestroy();
            this.isInited = false;
        }
    }

    @Override
    public boolean isInited() {
        return this.isInited;
    }

    protected void doInit() {
    }

    protected void doDestroy() {
    }

    boolean isLocked() {
        return this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAvailableAndGetLock() {
        if (!this.useTryLock) {
            return false;
        }
        if (this.available) {
            return false;
        }
        if (this.locked) {
            throw TxcException.nestedException(this.getNotAvailableErrorMsg(), this.lastError);
        }
        AbstractLifecycle abstractLifecycle = this;
        synchronized (abstractLifecycle) {
            if (this.locked) {
                throw TxcException.nestedException(this.getNotAvailableErrorMsg(), this.lastError);
            }
            this.locked = true;
            return true;
        }
    }

    void clearLock() {
        this.locked = false;
    }

    protected String getNotAvailableErrorMsg() {
        return this.getClass().getSimpleName() + " is not available, please check and try again later.";
    }

    public Throwable getLastError() {
        return this.lastError;
    }
}

