/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.message;

import com.taobao.txc.common.message.AbstractResultMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.message.TxcMsgHandler;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

public class RedressMessage
extends TxcMessage {
    private static final long serialVersionUID = -2213516219582268198L;
    public ByteBuffer byteBuffer = ByteBuffer.allocate(0x2000000);
    private String msg;

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public short getTypeCode() {
        return 121;
    }

    @Override
    public byte[] encode() {
        if (this.msg != null) {
            byte[] bs = this.msg.getBytes(UTF8);
            this.byteBuffer.putInt(bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int i = in.readableBytes();
        if (i < 4) {
            return false;
        }
        i -= 4;
        int len = in.readInt();
        if (len > 0) {
            if (i < len) {
                return false;
            }
            i -= len;
            byte[] bs = new byte[len];
            in.readBytes(bs);
            this.setMsg(new String(bs, UTF8));
        }
        return true;
    }

    @Override
    public void handleMessage(long msgId, String dbKeys, String clientIp, String clientAppName, String vgroupName, TxcMessage message, AbstractResultMessage[] results, int idx) {
        ((TxcMsgHandler)this.handler).handleMessage(msgId, dbKeys, clientIp, clientAppName, vgroupName, this, results, idx);
    }
}

