/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.message;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.AbstractResultMessage;
import com.taobao.txc.common.message.BeginMessage;
import com.taobao.txc.common.message.BeginRetryBranchMessage;
import com.taobao.txc.common.message.GlobalCommitMessage;
import com.taobao.txc.common.message.GlobalRollbackMessage;
import com.taobao.txc.common.message.MergeMessage;
import com.taobao.txc.common.message.QueryLockMessage;
import com.taobao.txc.common.message.RegisterMessage;
import com.taobao.txc.common.message.ReportStatusMessage;
import com.taobao.txc.common.message.ReportUdataMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.message.TxcMsgHandler;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class TxcMergeMessage
extends TxcMessage
implements Serializable,
MergeMessage {
    private static final long serialVersionUID = -5758802337446717090L;
    public List<TxcMessage> msgs = new ArrayList<TxcMessage>();
    public List<Long> msgIds = new ArrayList<Long>();
    private static final LoggerWrap logger = LoggerInit.logger;

    @Override
    public short getTypeCode() {
        return 19;
    }

    @Override
    public byte[] encode() {
        int bufferSize = this.msgs.size() * 1024;
        for (TxcMessage txcMessage : this.msgs) {
            String key;
            if (!(txcMessage instanceof RegisterMessage) || (key = ((RegisterMessage)txcMessage).getBusinessKey()) == null || key.length() <= 512) continue;
            int i = key.getBytes(UTF8).length;
            logger.info("get one huge registermessage, businesskey bytes:" + i);
            bufferSize += i;
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(bufferSize);
        byteBuffer.putShort((short)this.msgs.size());
        for (TxcMessage msg : this.msgs) {
            msg.setChannelHandlerContext(this.ctx);
            byte[] data = msg.encode();
            byteBuffer.putShort(msg.getTypeCode());
            byteBuffer.put(data);
        }
        byteBuffer.flip();
        int n = byteBuffer.limit();
        byte[] content = new byte[n + 4];
        TxcMergeMessage.intToBytes(n, content, 0);
        byteBuffer.get(content, 4, n);
        if (this.msgs.size() > 20 && logger.isDebugEnabled()) {
            logger.debug("msg in one packet:" + this.msgs.size() + ",buffer size:" + content.length);
        }
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int i = in.readableBytes();
        if (i < 4) {
            return false;
        }
        int length = in.readInt();
        if ((i -= 4) < length) {
            return false;
        }
        byte[] buffer = new byte[length];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(byteBuffer);
        return true;
    }

    public void decode(ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            TxcMessage message = null;
            switch (typeCode) {
                case 1: {
                    message = new BeginMessage();
                    break;
                }
                case 15: {
                    message = new BeginRetryBranchMessage();
                    break;
                }
                case 11: {
                    message = new RegisterMessage();
                    break;
                }
                case 13: {
                    message = new ReportStatusMessage();
                    break;
                }
                case 17: {
                    message = new ReportUdataMessage();
                    break;
                }
                case 7: {
                    message = new GlobalCommitMessage();
                    break;
                }
                case 9: {
                    message = new GlobalRollbackMessage();
                    break;
                }
                case 21: {
                    message = new QueryLockMessage();
                    break;
                }
                default: {
                    String className = TxcMessage.typeMap.get(typeCode);
                    throw new TxcException("unknown class:" + className + " in txc merge message.", TxcErrCode.MergeMessageError);
                }
            }
            ((TxcMessage)message).setChannelHandlerContext(this.ctx);
            message.decode(byteBuffer);
            this.msgs.add(message);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TxcMergeMessage ");
        for (TxcMessage msg : this.msgs) {
            sb.append(msg.toString()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public void handleMessage(long msgId, String dbKeys, String clientIp, String clientAppName, String vgroupName, TxcMessage message, AbstractResultMessage[] results, int idx) {
        ((TxcMsgHandler)this.handler).handleMessage(msgId, dbKeys, clientIp, clientAppName, vgroupName, this, results, idx);
    }
}

