/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.message;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.AbstractResultMessage;
import com.taobao.txc.common.message.BeginResultMessage;
import com.taobao.txc.common.message.BeginRetryBranchResultMessage;
import com.taobao.txc.common.message.BranchCommitResultMessage;
import com.taobao.txc.common.message.BranchRollbackResultMessage;
import com.taobao.txc.common.message.GlobalCommitResultMessage;
import com.taobao.txc.common.message.GlobalRollbackResultMessage;
import com.taobao.txc.common.message.MergeMessage;
import com.taobao.txc.common.message.QueryLockResultMessage;
import com.taobao.txc.common.message.RegisterResultMessage;
import com.taobao.txc.common.message.ReportStatusResultMessage;
import com.taobao.txc.common.message.ReportUdataResultMessage;
import com.taobao.txc.common.message.TxcMessage;
import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;

public class TxcMergeResultMessage
extends TxcMessage
implements MergeMessage {
    private static final long serialVersionUID = -7719219648774528552L;
    public AbstractResultMessage[] msgs;
    private static final LoggerWrap logger = LoggerInit.logger;

    public AbstractResultMessage[] getMsgs() {
        return this.msgs;
    }

    public void setMsgs(AbstractResultMessage[] msgs) {
        this.msgs = msgs;
    }

    @Override
    public short getTypeCode() {
        return 20;
    }

    @Override
    public byte[] encode() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.msgs.length * 1024);
        byteBuffer.putShort((short)this.msgs.length);
        for (AbstractResultMessage msg : this.msgs) {
            msg.setChannelHandlerContext(this.ctx);
            byte[] data = msg.encode();
            byteBuffer.putShort(msg.getTypeCode());
            byteBuffer.put(data);
        }
        byteBuffer.flip();
        int length = byteBuffer.limit();
        byte[] content = new byte[length + 4];
        TxcMergeResultMessage.intToBytes(length, content, 0);
        byteBuffer.get(content, 4, length);
        if (this.msgs.length > 20 && logger.isDebugEnabled()) {
            logger.debug("msg in one txc merge packet:" + this.msgs.length + ",buffer size:" + content.length);
        }
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int i = in.readableBytes();
        if (i < 4) {
            return false;
        }
        int length = in.readInt();
        if ((i -= 4) < length) {
            return false;
        }
        byte[] buffer = new byte[length];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        this.decode(byteBuffer);
        return true;
    }

    public void decode(ByteBuffer byteBuffer) {
        int msgNum = byteBuffer.getShort();
        this.msgs = new AbstractResultMessage[msgNum];
        for (int idx = 0; idx < msgNum; ++idx) {
            short typeCode = byteBuffer.getShort();
            AbstractResultMessage message = null;
            switch (typeCode) {
                case 2: {
                    message = new BeginResultMessage();
                    break;
                }
                case 16: {
                    message = new BeginRetryBranchResultMessage();
                    break;
                }
                case 12: {
                    message = new RegisterResultMessage();
                    break;
                }
                case 14: {
                    message = new ReportStatusResultMessage();
                    break;
                }
                case 18: {
                    message = new ReportUdataResultMessage();
                    break;
                }
                case 4: {
                    message = new BranchCommitResultMessage();
                    break;
                }
                case 6: {
                    message = new BranchRollbackResultMessage();
                    break;
                }
                case 8: {
                    message = new GlobalCommitResultMessage();
                    break;
                }
                case 10: {
                    message = new GlobalRollbackResultMessage();
                    break;
                }
                case 22: {
                    message = new QueryLockResultMessage();
                    break;
                }
                default: {
                    String className = TxcMessage.typeMap.get(typeCode);
                    throw new TxcException("unknown class:" + className + " in txc merge result message.", TxcErrCode.MergeResultMessageError);
                }
            }
            ((TxcMessage)message).setChannelHandlerContext(this.ctx);
            message.decode(byteBuffer);
            this.msgs[idx] = message;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TxcMergeResultMessage ");
        for (AbstractResultMessage msg : this.msgs) {
            sb.append(msg.toString()).append("\n");
        }
        return sb.toString();
    }
}

