/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.sequence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class TxcSequenceWorker {
    private final long twepoch = 1420041600000L;
    private final long workerIdBits = 3L;
    private final long datacenterIdBits = 3L;
    private final long maxWorkerId = 7L;
    private final long maxDatacenterId = 7L;
    private final long sequenceBits = 16L;
    private final long workerIdShift = 16L;
    private final long datacenterIdShift = 19L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 65535L;
    private long workerId;
    private long datacenterId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;
    private volatile long currentTimestamp;

    public TxcSequenceWorker(long workerId, long datacenterId) {
        if (workerId > 7L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", 7L));
        }
        if (datacenterId > 7L || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", 7L));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    TxcSequenceWorker.this.currentTimestamp = System.currentTimeMillis();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }, 0L, 10L, TimeUnit.MICROSECONDS);
    }

    public synchronized long nextId() {
        long timestamp = this.getCurrentTimestamp();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - 1420041600000L << 22 | this.datacenterId << 19 | this.workerId << 16 | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.getCurrentTimestamp();
        while (timestamp <= lastTimestamp) {
            timestamp = this.getCurrentTimestamp();
        }
        return timestamp;
    }

    private long getCurrentTimestamp() {
        return this.currentTimestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        final TxcSequenceWorker idWorker = new TxcSequenceWorker(0L, 0L);
        int threadNum = 100;
        long loop = 1000000L;
        System.out.println("threadNum:" + threadNum);
        long start = System.currentTimeMillis();
        final CountDownLatch countDownLatch = new CountDownLatch(threadNum);
        for (int i = 0; i < threadNum; ++i) {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        for (long j = 0L; j < 1000000L; ++j) {
                            idWorker.nextId();
                        }
                    }
                    finally {
                        countDownLatch.countDown();
                    }
                }
            };
            thread.start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            System.out.println("tps:" + 1000000L * (long)threadNum * 1000L / (System.currentTimeMillis() - start) + " times.");
        }
    }
}

