/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Timer;
import java.util.TimerTask;

public class CommandStreamReader {
    private InputStream istream;
    private InputStream estream;
    private Process p;
    private static long DEFAULT_TIMEOUT = 5000L;

    public void execute(String[] command, StreamType consume) throws IOException {
        if (this.p != null) {
            this.destroy();
        }
        this.p = Runtime.getRuntime().exec(command);
        this.workInner(consume);
    }

    public void execute(String command, StreamType consume) throws IOException {
        if (this.p != null) {
            this.destroy();
        }
        this.p = Runtime.getRuntime().exec(command);
        this.workInner(consume);
    }

    private void workInner(StreamType consume) throws IOException {
        this.istream = this.p.getInputStream();
        this.estream = this.p.getErrorStream();
        if (consume != null) {
            InputStream stream;
            if (consume == StreamType.INPUT_STREAM) {
                stream = this.istream;
                this.istream = null;
            } else {
                stream = this.estream;
                this.estream = null;
            }
            if (stream != null) {
                Thread consumeThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
                        try {
                            while (bufferedReader.readLine() != null) {
                            }
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                });
                consumeThread.start();
            }
        }
    }

    public String readContent(StreamType source) throws Exception {
        return this.readContent(source, DEFAULT_TIMEOUT);
    }

    public String readContent(StreamType source, long timeout) throws Exception {
        if (source == null) {
            return null;
        }
        InputStream stream = source == StreamType.INPUT_STREAM ? this.istream : this.estream;
        if (stream == null) {
            return null;
        }
        final boolean[] isStopped = new boolean[]{false};
        InputStreamReader inputStreamReader = new InputStreamReader(stream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        final Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                isStopped[0] = true;
            }
        }, timeout);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            while (!isStopped[0] && stream.available() == 0 || stream.available() > 0) {
                if (stream.available() > 0) {
                    stringBuilder.append(bufferedReader.readLine()).append("\n");
                    continue;
                }
                if (stream.markSupported()) {
                    stream.mark(1);
                    if (stream.read() == -1) {
                        break;
                    }
                    stream.reset();
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            timer.cancel();
        }
        return stringBuilder.toString();
    }

    public void destroy() {
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.istream = null;
        }
        if (this.estream != null) {
            try {
                this.estream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.estream = null;
        }
        if (this.p != null) {
            this.p.destroy();
            this.p = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String command = "ping -t www.baidu.com";
        command = "ping -t www.baidu.com";
        CommandStreamReader commandStreamReader = new CommandStreamReader();
        try {
            commandStreamReader.execute(command, StreamType.ERROR_STREAM);
            String result = commandStreamReader.readContent(StreamType.INPUT_STREAM);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            commandStreamReader.destroy();
        }
        CommandStreamReader commandStreamReader1 = new CommandStreamReader();
        try {
            commandStreamReader1.execute(command, null);
            String result = commandStreamReader1.readContent(StreamType.INPUT_STREAM, 10000L);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            commandStreamReader1.destroy();
        }
    }

    public static enum StreamType {
        INPUT_STREAM,
        ERROR_STREAM;

    }
}

