/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.gzip;

import com.taobao.txc.common.exception.TxcException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class GzipUtil {
    public static String CHARACTERSET = "ISO-8859-1";
    private static boolean bCompressValid = false;

    public static String compress(String str) {
        if (!bCompressValid) {
            return str;
        }
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes());
            gzip.close();
            return out.toString(CHARACTERSET);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (TxcException)e;
        }
    }

    public static String uncompress(String str) {
        if (!bCompressValid) {
            return str;
        }
        if (str == null || str.length() == 0) {
            return str;
        }
        try {
            int n;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ByteArrayInputStream in = new ByteArrayInputStream(str.getBytes(CHARACTERSET));
            GZIPInputStream gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return out.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw (TxcException)e;
        }
    }
}

