/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.http;

import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;

public class HttpUtil {
    public static final int connTimeout = 10000;
    public static final int readTimeout = 60000;
    public static final String charset = "UTF-8";
    private static HttpClient client = null;
    private static String clientAddr;

    public static String toString(InputStream input, String encoding) throws IOException {
        return null == encoding ? HttpUtil.toString(new InputStreamReader(input)) : HttpUtil.toString(new InputStreamReader(input, encoding));
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        HttpUtil.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        int n;
        char[] buffer = new char[4096];
        long count = 0L;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    private static CloseableHttpClient createSSLInsecureClient() throws GeneralSecurityException {
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

            public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                return true;
            }
        }).build();
        SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslSession) {
                return true;
            }
        });
        return HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String get(String url, String charset, Integer connTimeout, Integer readTimeout) throws IOException, GeneralSecurityException {
        CloseableHttpClient client = null;
        HttpGet get = new HttpGet(url);
        String result = "";
        try {
            get.addHeader("CS-ClientAddr", clientAddr);
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            get.setConfig(customReqConf.build());
            HttpResponse res = null;
            if (url.startsWith("https")) {
                client = HttpUtil.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)get);
            } else {
                client = HttpUtil.client;
                res = client.execute((HttpUriRequest)get);
            }
            if (res.getStatusLine().getStatusCode() == 404) {
                throw new TxcException(TxcErrCode.HttpDataNotExistError);
            }
            if (res.getStatusLine().getStatusCode() >= 300) {
                throw new RuntimeException("http get failed:" + res.getStatusLine().getStatusCode());
            }
            result = HttpUtil.toString(res.getEntity().getContent(), charset);
        }
        catch (Throwable throwable) {
            get.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        get.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(String url, Map<String, String> headers, String body, String mimeType, String charset, Integer connTimeout, Integer readTimeout) throws IOException, GeneralSecurityException {
        CloseableHttpClient client = null;
        HttpPost post = new HttpPost(url);
        String result = "";
        try {
            HttpResponse res;
            post.addHeader("CS-ClientAddr", clientAddr);
            if (headers != null) {
                for (String key : headers.keySet()) {
                    post.addHeader(key, headers.get(key));
                }
            }
            if (StringUtils.isNotBlank((String)body)) {
                StringEntity entity = new StringEntity(body, ContentType.create((String)mimeType, (String)charset));
                post.setEntity((HttpEntity)entity);
            }
            RequestConfig.Builder customReqConf = RequestConfig.custom();
            if (connTimeout != null) {
                customReqConf.setConnectTimeout(connTimeout.intValue());
            }
            if (readTimeout != null) {
                customReqConf.setSocketTimeout(readTimeout.intValue());
            }
            post.setConfig(customReqConf.build());
            if (url.startsWith("https")) {
                client = HttpUtil.createSSLInsecureClient();
                res = client.execute((HttpUriRequest)post);
            } else {
                client = HttpUtil.client;
                res = client.execute((HttpUriRequest)post);
            }
            if (res.getStatusLine().getStatusCode() >= 300) {
                throw new RuntimeException(String.format("http post failed:%d %s", res.getStatusLine().getStatusCode(), res.getStatusLine().getReasonPhrase()));
            }
            result = HttpUtil.toString(res.getEntity().getContent(), charset);
        }
        catch (Throwable throwable) {
            post.releaseConnection();
            if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
                ((CloseableHttpClient)client).close();
            }
            throw throwable;
        }
        post.releaseConnection();
        if (url.startsWith("https") && client != null && client instanceof CloseableHttpClient) {
            client.close();
        }
        return result;
    }

    public static String get(String url) throws Exception {
        return HttpUtil.get(url, charset, 10000, 60000);
    }

    public static String get(String url, int connTimeout) throws Exception {
        return HttpUtil.get(url, charset, connTimeout, 60000);
    }

    public static String get(String url, String charset) throws Exception {
        return HttpUtil.get(url, charset, 10000, 60000);
    }

    public static String post(String url, Map<String, String> headers, String body) throws Exception {
        return HttpUtil.post(url, headers, body, "json", charset, 10000, 60000);
    }

    public static String post(String url, Map<String, String> headers, String body, String mime) throws Exception {
        return HttpUtil.post(url, headers, body, mime, charset, 10000, 60000);
    }

    static {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setMaxTotal(128);
        cm.setDefaultMaxPerRoute(10);
        client = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();
        try {
            clientAddr = NetUtil.getLocalIp();
        }
        catch (Exception e) {
            clientAddr = "0.0.0.0";
        }
    }
}

