/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.http;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class LocalCache {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static String userHome = "/home/admin";
    private static String TXC_CONFIG_DIR_PREFIX = "/.txc/";

    private static File createFile(String group, String dataId) {
        StringBuilder sb = new StringBuilder(userHome);
        sb.append(TXC_CONFIG_DIR_PREFIX).append(group).append('/').append(dataId);
        File file = new File(sb.toString());
        if (!file.exists()) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                return null;
            }
            try {
                if (!file.createNewFile()) {
                    return null;
                }
            }
            catch (IOException e) {
                logger.error(TxcErrCode.ConfigFileError, e);
                return null;
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean flushCache(String group, String dataId, String content) {
        if (StringUtils.isEmpty((String)content)) {
            return false;
        }
        File file = LocalCache.createFile(group, dataId);
        if (file == null) {
            return false;
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            fout.write(content.getBytes());
        }
        catch (FileNotFoundException e) {
            logger.error(TxcErrCode.ConfigFileError, e);
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            logger.error(TxcErrCode.ConfigFileError, e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFromCache(String group, String dataId) {
        StringBuilder sb = new StringBuilder(userHome);
        sb.append(TXC_CONFIG_DIR_PREFIX).append(group).append('/').append(dataId);
        File file = new File(sb.toString());
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            StringBuilder isb = new StringBuilder();
            String tempStr = null;
            while ((tempStr = reader.readLine()) != null) {
                isb.append(tempStr).append("\r\n");
            }
            String string = isb.toString();
            return string;
        }
        catch (FileNotFoundException e) {
            String string = null;
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        String tempDir = System.getProperty("user.home");
        if (!StringUtils.isEmpty((String)tempDir)) {
            userHome = tempDir;
        }
    }
}

