/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.serviceloader;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.util.serviceloader.EnhancedServiceNotFoundException;
import com.taobao.txc.common.util.serviceloader.LoadLevel;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class EnhancedServiceLoader {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final String SERVICES_DIRECTORY = "META-INF/services/";
    private static final String TXC_DIRECTORY = "META-INF/txc/";
    private static Map<Class, List<Class>> providers = new ConcurrentHashMap<Class, List<Class>>();

    public static <S> S load(Class<S> service, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, loader);
    }

    public static <S> S load(Class<S> service) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, null, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> S load(Class<S> service, String activateName, ClassLoader loader) throws EnhancedServiceNotFoundException {
        return EnhancedServiceLoader.loadFile(service, activateName, loader);
    }

    public static <S> List<Class> getAllExtendsionClass(Class<S> service) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, EnhancedServiceLoader.findClassLoader());
    }

    public static <S> List<Class> getAllExtendsionClass(Class<S> service, ClassLoader loader) {
        return EnhancedServiceLoader.findAllExtensionClass(service, null, loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <S> S loadFile(Class<S> service, String activateName, ClassLoader loader) {
        try {
            boolean foundFromCache = true;
            List<Class> extensions = providers.get(service);
            if (extensions == null) {
                Class<S> clazz = service;
                synchronized (clazz) {
                    extensions = providers.get(service);
                    if (extensions == null) {
                        extensions = EnhancedServiceLoader.findAllExtensionClass(service, activateName, loader);
                        foundFromCache = false;
                        providers.put(service, extensions);
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)activateName)) {
                EnhancedServiceLoader.loadFile(service, TXC_DIRECTORY + activateName.toLowerCase() + "/", loader, extensions);
                ArrayList<Class> activateExtensions = new ArrayList<Class>();
                for (int i = 0; i < extensions.size(); ++i) {
                    Class clz = extensions.get(i);
                    LoadLevel activate = clz.getAnnotation(LoadLevel.class);
                    if (activate == null || !activateName.equals(activate.name())) continue;
                    activateExtensions.add(clz);
                }
                extensions = activateExtensions;
            }
            if (extensions.isEmpty()) {
                throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + "[" + activateName + "] and classloader : " + ObjectUtils.toString((Object)loader));
            }
            Class extension = extensions.get(extensions.size() - 1);
            S result = service.cast(extension.newInstance());
            if (!foundFromCache && logger.isInfoEnabled()) {
                logger.info("load " + service.getSimpleName() + "[" + activateName + "] extension by class[" + extension.getName() + "]");
            }
            return result;
        }
        catch (Throwable e) {
            if (e instanceof EnhancedServiceNotFoundException) {
                throw (EnhancedServiceNotFoundException)((Object)e);
            }
            throw new EnhancedServiceNotFoundException("not found service provider for : " + service.getName() + " caused by " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    private static <S> List<Class> findAllExtensionClass(Class<S> service, String activateName, ClassLoader loader) {
        ArrayList<Class> extensions = new ArrayList<Class>();
        try {
            EnhancedServiceLoader.loadFile(service, SERVICES_DIRECTORY, loader, extensions);
            EnhancedServiceLoader.loadFile(service, TXC_DIRECTORY, loader, extensions);
        }
        catch (IOException e) {
            throw new EnhancedServiceNotFoundException(e);
        }
        if (extensions.isEmpty()) {
            return extensions;
        }
        Collections.sort(extensions, new Comparator<Class>(){

            @Override
            public int compare(Class c1, Class c2) {
                Integer o1 = 0;
                Integer o2 = 0;
                LoadLevel a1 = c1.getAnnotation(LoadLevel.class);
                LoadLevel a2 = c2.getAnnotation(LoadLevel.class);
                if (a1 != null) {
                    o1 = a1.order();
                }
                if (a2 != null) {
                    o2 = a2.order();
                }
                return o1.compareTo(o2);
            }
        });
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadFile(Class<?> service, String dir, ClassLoader classLoader, List<Class> extensions) throws IOException {
        String fileName = dir + service.getName();
        Enumeration<URL> urls = classLoader != null ? classLoader.getResources(fileName) : ClassLoader.getSystemResources(fileName);
        if (urls != null) {
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(url.openStream(), "utf-8"));
                    String line = null;
                    while ((line = reader.readLine()) != null) {
                        int ci = line.indexOf(35);
                        if (ci >= 0) {
                            line = line.substring(0, ci);
                        }
                        if ((line = line.trim()).length() <= 0) continue;
                        extensions.add(Class.forName(line, true, classLoader));
                    }
                }
                catch (ClassNotFoundException line) {
                }
                catch (Throwable e) {
                    logger.warn(e.getMessage());
                }
                finally {
                    try {
                        if (reader == null) continue;
                        reader.close();
                    }
                    catch (IOException line) {}
                }
            }
        }
    }

    private static ClassLoader findClassLoader() {
        return EnhancedServiceLoader.class.getClassLoader();
    }
}

