/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.string;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class ConfigDataMode {
    public static final String CONFIG_MODE = "tddl.config.mode";
    public static final long MAX_DELAY_VALUE = 0x200000000L;
    private static Mode mode;
    private static boolean isServer;
    private static boolean isDRDS;
    private static boolean isQuotaEscape;
    private static Set<String> useTxcAtom;
    private static volatile long refreshConfigTimestamp;

    public static Mode getMode() {
        return mode;
    }

    public static void setMode(Mode mode) {
        ConfigDataMode.mode = mode;
    }

    public static boolean isServer() {
        return isServer;
    }

    public static boolean isCorona() {
        return isServer && !isDRDS;
    }

    public static void setServer(boolean isServer) {
        ConfigDataMode.isServer = isServer;
    }

    public static boolean isDRDS() {
        return isDRDS;
    }

    public static void setDRDS(boolean isDRDS) {
        ConfigDataMode.isDRDS = isDRDS;
    }

    public static boolean isUseTxcAtom(String appname) {
        return useTxcAtom.contains(appname);
    }

    public static void addUseTxcAtom(String appname) {
        useTxcAtom.add(appname);
    }

    public static void removeUseTxcAtom(String appname) {
        useTxcAtom.remove(appname);
    }

    public static long getRefreshConfigTimestamp() {
        return refreshConfigTimestamp;
    }

    public static void setRefreshConfigTimestamp(long refreshConfigTimestamp) {
        ConfigDataMode.refreshConfigTimestamp = refreshConfigTimestamp;
    }

    public static boolean isQuotaEscape() {
        return isQuotaEscape;
    }

    public static void setQuotaEscape(boolean isQuotaEscape) {
        ConfigDataMode.isQuotaEscape = isQuotaEscape;
    }

    static {
        String drds;
        String appname;
        String cmd;
        isServer = false;
        isDRDS = false;
        isQuotaEscape = true;
        useTxcAtom = Collections.synchronizedSet(new HashSet());
        refreshConfigTimestamp = 0L;
        String m = System.getProperty(CONFIG_MODE, "auto");
        mode = Mode.nameOf(m);
        if (mode == null) {
            mode = Mode.AUTO;
        }
        if (StringUtils.equals((String)(cmd = System.getProperty("sun.java.command")), (String)"com.taobao.tddl.server.TddlLauncher")) {
            isServer = true;
        }
        if (StringUtils.isNotEmpty((String)(appname = System.getProperty("appName"))) && appname.startsWith("tddl")) {
            isServer = true;
        }
        if (isServer && StringUtils.isNotEmpty((String)(drds = System.getProperty("drds"))) && BooleanUtils.toBoolean((String)drds)) {
            isDRDS = true;
        }
    }

    public static enum Mode {
        DIAMOND("diamond"),
        MOCK("mock"),
        MANAGER("manager"),
        AUTO(null);

        private String extensionName;

        private Mode(String extensionName) {
            this.extensionName = extensionName;
        }

        public static Mode nameOf(String m) {
            for (Mode mode : Mode.values()) {
                if (!StringUtils.equalsIgnoreCase((String)mode.name(), (String)m)) continue;
                return mode;
            }
            return null;
        }

        public String getExtensionName() {
            return this.extensionName;
        }

        public boolean isMock() {
            return this == MOCK;
        }
    }
}

