/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.string;

import com.taobao.txc.common.util.string.TxcString;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TStringUtil
extends StringUtils {
    private static final long[] pow10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private static Method toPlainStringMethod;
    public static String TRACE;
    public static final String UNIVERSAL_HINT_HEAD = "/*";
    public static final String UNIVERSAL_HINT_TAIL = "*/";

    public static String getBetween(String sql, String start, String end) {
        if (sql == null || start == null || end == null) {
            return null;
        }
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return null;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return null;
        }
        return sql.substring(index0 + start.length(), index1).trim();
    }

    public static String getBetweenWithoutTrim(String sql, String start, String end) {
        if (sql == null || start == null || end == null) {
            return null;
        }
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return null;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return null;
        }
        return sql.substring(index0 + start.length(), index1);
    }

    public static String removeBetween(String sql, String start, String end) {
        if (sql == null) {
            return null;
        }
        if (start == null || end == null) {
            return sql;
        }
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return sql;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, index0));
        sb.append(" ");
        sb.append(sql.substring(index1 + end.length()));
        return sb.toString();
    }

    public static String[] twoPartSplit(String str, String splitor) {
        if (str != null && splitor != null) {
            int index = str.indexOf(splitor);
            if (index != -1) {
                String first = str.substring(0, index);
                String sec = str.substring(index + splitor.length());
                return new String[]{first, sec};
            }
            return new String[]{str};
        }
        return new String[]{str};
    }

    public static List<String> recursiveSplit(String str, String splitor) {
        ArrayList<String> re = new ArrayList<String>();
        String[] strs = TStringUtil.twoPartSplit(str, splitor);
        if (strs.length == 2) {
            re.add(strs[0]);
            re.addAll(TStringUtil.recursiveSplit(strs[1], splitor));
        } else {
            re.add(strs[0]);
        }
        return re;
    }

    public static String fillTabWithSpace(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        int index = 0;
        int index0 = -1;
        int index1 = -1;
        for (int i = 0; i < sz; ++i) {
            char c = str.charAt(i);
            if (!Character.isWhitespace(c)) {
                if (index0 != -1 && (index0 != index1 || str.charAt(i - 1) != ' ')) {
                    buffer.append(str.substring(index, index0)).append(" ");
                    index = index1 + 1;
                }
                index1 = -1;
                index0 = -1;
                continue;
            }
            if (index0 == -1) {
                index0 = index1 = i;
                continue;
            }
            index1 = i;
        }
        buffer.append(str.substring(index));
        return buffer.toString();
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor) {
        return TStringUtil.startsWithIgnoreCaseAndWs(searchIn, searchFor, 0);
    }

    public static boolean startsWithIgnoreCaseAndWs(String searchIn, String searchFor, int beginPos) {
        if (searchIn == null) {
            return searchFor == null;
        }
        int inLength = searchIn.length();
        while (beginPos < inLength && Character.isWhitespace(searchIn.charAt(beginPos))) {
            ++beginPos;
        }
        return TStringUtil.startsWithIgnoreCase(searchIn, beginPos, searchFor);
    }

    public static boolean startsWithIgnoreCase(String searchIn, int startAt, String searchFor) {
        return searchIn.regionMatches(true, startAt, searchFor, 0, searchFor.length());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripComments(String src, String stringOpens, String stringCloses, boolean slashStarComments, boolean slashSlashComments, boolean hashComments, boolean dashDashComments) {
        if (src == null) {
            return null;
        }
        StringBuffer buf = new StringBuffer(src.length());
        StringReader sourceReader = new StringReader(src);
        char contextMarker = '\u0000';
        boolean escaped = false;
        int markerTypeFound = -1;
        int ind = 0;
        char currentChar = '\u0000';
        try {
            block2: while ((currentChar = sourceReader.read()) != '\uffffffff') {
                char prevChar;
                block24: {
                    block25: {
                        block22: {
                            block23: {
                                if (currentChar == '\\') {
                                    escaped = !escaped;
                                } else if (markerTypeFound != -1 && currentChar == stringCloses.charAt(markerTypeFound) && !escaped) {
                                    contextMarker = '\u0000';
                                    markerTypeFound = -1;
                                } else {
                                    ind = stringOpens.indexOf(currentChar);
                                    if (ind != -1 && !escaped && contextMarker == '\u0000') {
                                        markerTypeFound = ind;
                                        contextMarker = currentChar;
                                    }
                                }
                                if (contextMarker != '\u0000' || currentChar != '/' || !slashSlashComments && !slashStarComments) break block22;
                                currentChar = sourceReader.read();
                                if (currentChar != '*' || !slashStarComments) break block23;
                                prevChar = '\u0000';
                                break block24;
                            }
                            if (currentChar == '/' && slashSlashComments) {
                                while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                                }
                            }
                            break block25;
                        }
                        if (contextMarker == '\u0000' && currentChar == '#' && hashComments) {
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        } else if (contextMarker == '\u0000' && currentChar == '-' && dashDashComments) {
                            currentChar = sourceReader.read();
                            if (currentChar == '\uffffffff' || currentChar != '-') {
                                buf.append('-');
                                if (currentChar == '\uffffffff') continue;
                                buf.append((int)currentChar);
                                continue;
                            }
                            while ((currentChar = sourceReader.read()) != '\n' && currentChar != '\r' && currentChar >= '\u0000') {
                            }
                        }
                    }
                    if (currentChar == '\uffffffff') continue;
                    buf.append(currentChar);
                    continue;
                }
                while ((currentChar = sourceReader.read()) != '/' || prevChar != '*') {
                    if (currentChar == '\r') {
                        currentChar = sourceReader.read();
                        if (currentChar == '\n') {
                            currentChar = sourceReader.read();
                        }
                    } else if (currentChar == '\n') {
                        currentChar = sourceReader.read();
                    }
                    if (currentChar < '\u0000') continue block2;
                    prevChar = currentChar;
                }
            }
            return buf.toString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String removeBetweenWithSplitor(String sql, String start, String end) {
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return sql;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, index0));
        sb.append(" ");
        sb.append(sql.substring(index1 + end.length()));
        return sb.toString();
    }

    public static String removeBetweenWithSplitorNotExistNull(String sql, String start, String end) {
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return null;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, index0));
        sb.append(" ");
        sb.append(sql.substring(index1 + end.length()));
        return sb.toString();
    }

    public static boolean isTableFatherAndSon(String fatherTable, String sonTable) {
        if (fatherTable == null || fatherTable.trim().isEmpty() || sonTable == null || sonTable.trim().isEmpty()) {
            return false;
        }
        if (!sonTable.startsWith(fatherTable) || fatherTable.length() + 2 > sonTable.length()) {
            return false;
        }
        String suffix = sonTable.substring(fatherTable.length());
        return suffix.matches("_[\\d]+");
    }

    public static int compareTo(String str1, String str2) {
        if (str1 == null && str2 == null) {
            return 0;
        }
        if (str1 == null) {
            return -str2.compareTo(str1);
        }
        return str1.compareTo(str2);
    }

    public static String replaceWithIgnoreCase(String str, String searchStr, String replaceStr) {
        int index = TStringUtil.indexOfIgnoreCase((String)str, (String)searchStr);
        if (index < 0) {
            return str;
        }
        if (index > 0) {
            return str.substring(0, index) + replaceStr + str.substring(index + searchStr.length());
        }
        return replaceStr + str.substring(searchStr.length());
    }

    public static final String fixDecimalExponent(String dString) {
        char maybeMinusChar;
        int ePos = dString.indexOf("E");
        if (ePos == -1) {
            ePos = dString.indexOf("e");
        }
        if (ePos != -1 && dString.length() > ePos + 1 && (maybeMinusChar = dString.charAt(ePos + 1)) != '-' && maybeMinusChar != '+') {
            StringBuffer buf = new StringBuffer(dString.length() + 1);
            buf.append(dString.substring(0, ePos + 1));
            buf.append('+');
            buf.append(dString.substring(ePos + 1, dString.length()));
            dString = buf.toString();
        }
        return dString;
    }

    public static String consistentToString(BigDecimal decimal) {
        if (decimal == null) {
            return null;
        }
        if (toPlainStringMethod != null) {
            try {
                return (String)toPlainStringMethod.invoke((Object)decimal, (Object[])null);
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return decimal.toString();
    }

    public static String formatNanos(int nanos, boolean serverSupportsFracSecs) {
        if (!serverSupportsFracSecs || nanos == 0) {
            return "0";
        }
        boolean usingMicros = true;
        if (usingMicros) {
            nanos /= 1000;
        }
        int digitCount = usingMicros ? 6 : 9;
        String nanosString = Integer.toString(nanos);
        String zeroPadding = usingMicros ? "000000" : "000000000";
        nanosString = zeroPadding.substring(0, digitCount - nanosString.length()) + nanosString;
        int pos = digitCount - 1;
        while (nanosString.charAt(pos) == '0') {
            --pos;
        }
        nanosString = nanosString.substring(0, pos + 1);
        return nanosString;
    }

    public static String placeHolder(int bit, long table) {
        if (bit > 18) {
            throw new IllegalArgumentException("\u622a\u53d6\u7684\u4f4d\u6570\u4e0d\u80fd\u5927\u4e8e18\u4f4d");
        }
        if (table == 0L) {
            return String.valueOf(pow10[bit]).substring(1);
        }
        if (table >= pow10[bit - 1]) {
            return String.valueOf(table);
        }
        long max = pow10[bit];
        long placedNumber = max + table;
        return String.valueOf(placedNumber).substring(1);
    }

    public static boolean isEmpty(StringBuilder str) {
        return str == null || str.length() == 0;
    }

    public static boolean isEscapeNeededForString(String x, int stringLength) {
        boolean needsHexEscape = false;
        for (int i = 0; i < stringLength; ++i) {
            char c = x.charAt(i);
            switch (c) {
                case '\u0000': {
                    needsHexEscape = true;
                    break;
                }
                case '\n': {
                    needsHexEscape = true;
                    break;
                }
                case '\r': {
                    needsHexEscape = true;
                    break;
                }
                case '\\': {
                    needsHexEscape = true;
                    break;
                }
                case '\'': {
                    needsHexEscape = true;
                    break;
                }
                case '\"': {
                    needsHexEscape = true;
                    break;
                }
                case '\u001a': {
                    needsHexEscape = true;
                }
            }
            if (needsHexEscape) break;
        }
        return needsHexEscape;
    }

    public static String quoteString(String x) {
        String parameterAsString = null;
        boolean usingAnsiMode = false;
        int stringLength = x.length();
        StringBuffer buf = new StringBuffer((int)((double)x.length() * 1.1));
        buf.append('\'');
        if (TStringUtil.isEscapeNeededForString(x, stringLength)) {
            block10: for (int i = 0; i < stringLength; ++i) {
                char c = x.charAt(i);
                switch (c) {
                    case '\u0000': {
                        buf.append('\\');
                        buf.append('0');
                        continue block10;
                    }
                    case '\n': {
                        buf.append('\\');
                        buf.append('n');
                        continue block10;
                    }
                    case '\r': {
                        buf.append('\\');
                        buf.append('r');
                        continue block10;
                    }
                    case '\\': {
                        buf.append('\\');
                        buf.append('\\');
                        continue block10;
                    }
                    case '\'': {
                        buf.append('\\');
                        buf.append('\'');
                        continue block10;
                    }
                    case '\"': {
                        if (usingAnsiMode) {
                            buf.append('\\');
                        }
                        buf.append('\"');
                        continue block10;
                    }
                    case '\u001a': {
                        buf.append('\\');
                        buf.append('Z');
                        continue block10;
                    }
                    case '\u00a5': 
                    case '\u20a9': {
                        return null;
                    }
                    default: {
                        buf.append(c);
                    }
                }
            }
        } else {
            buf.append(x);
        }
        buf.append('\'');
        parameterAsString = buf.toString();
        return parameterAsString;
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(Integer.toHexString(b & 0xFF)).append(" ");
        }
        return sb.toString();
    }

    public static int traceIndex(String sql) {
        int i;
        String temp = sql;
        block3: for (i = 0; i < temp.length(); ++i) {
            switch (temp.charAt(i)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block3;
                }
            }
        }
        if (temp.toLowerCase().startsWith(TRACE, i)) {
            return i + TRACE.length();
        }
        return -1;
    }

    public static boolean containsAny(String str, char[] searchChars) {
        if (TStringUtil.isEmpty((String)str) || searchChars == null || searchChars.length == 0) {
            return false;
        }
        int csLength = str.length();
        int searchLength = searchChars.length;
        int csLast = csLength - 1;
        int searchLast = searchLength - 1;
        for (int i = 0; i < csLength; ++i) {
            char ch = str.charAt(i);
            for (int j = 0; j < searchLength; ++j) {
                if (searchChars[j] != ch) continue;
                if (TStringUtil.isHighSurrogate(ch)) {
                    if (j == searchLast) {
                        return true;
                    }
                    if (i >= csLast || searchChars[j + 1] != str.charAt(i + 1)) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private static boolean isHighSurrogate(char ch) {
        return '\ud800' <= ch && '\udbff' >= ch;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return simpleDateFormat.format(date);
    }

    public static boolean isHexString(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static String[] splitUniversalHint(String sql) {
        String[] ret = new String[2];
        ret[0] = TxcString.getBetween(sql, UNIVERSAL_HINT_HEAD, UNIVERSAL_HINT_TAIL);
        if (ret[0] == null || ret[0].isEmpty()) {
            ret[1] = sql;
            return ret;
        }
        ret[1] = TxcString.removeBetweenWithSplitor(sql, UNIVERSAL_HINT_HEAD, UNIVERSAL_HINT_TAIL).trim();
        return ret;
    }

    public static int makeSqlParams(ArrayList<Object>[] paramsIn, String hint, String sql, int paramFrom, int paramNum, SqlWithParams sqlWithParams) {
        sqlWithParams.sql = !StringUtils.isEmpty((String)hint) ? String.format("/*%s*/ %s", hint, sql) : sql;
        sqlWithParams.params = new ArrayList[paramNum];
        for (int i = 0; i < paramNum && i + paramFrom < paramsIn.length; ++i) {
            sqlWithParams.params[i] = paramsIn[i + paramFrom];
        }
        return paramFrom + paramNum;
    }

    public static List<SqlWithParams> splitMultiSqlWithParams(String sql, ArrayList<Object>[] paramsIn) {
        String str;
        int currPos;
        ArrayList<SqlWithParams> sqls = new ArrayList<SqlWithParams>();
        int singleQuoteNum = 0;
        int doubleQuoteNum = 0;
        int escapeSymbolNum = 0;
        int markPos = 0;
        int paramFrom = 0;
        int paramNum = 0;
        String[] hint = TStringUtil.splitUniversalHint(sql);
        sql = hint[1];
        for (currPos = 0; currPos < sql.length(); ++currPos) {
            char c = sql.charAt(currPos);
            if (c == '\'') {
                ++singleQuoteNum;
                continue;
            }
            if (c == '\"') {
                ++doubleQuoteNum;
                continue;
            }
            if (c == '`') {
                ++escapeSymbolNum;
                continue;
            }
            if (c == '\\') {
                ++currPos;
                continue;
            }
            if (c == '?') {
                if (singleQuoteNum % 2 != 0 || doubleQuoteNum % 2 != 0 || escapeSymbolNum % 2 != 0) continue;
                ++paramNum;
                continue;
            }
            if (c != ';' || singleQuoteNum % 2 != 0 || doubleQuoteNum % 2 != 0 || escapeSymbolNum % 2 != 0) continue;
            String str2 = sql.substring(markPos, currPos);
            if (!StringUtils.isBlank((String)str2)) {
                SqlWithParams sqlWithParams = new SqlWithParams();
                paramFrom = TStringUtil.makeSqlParams(paramsIn, hint[0], str2, paramFrom, paramNum, sqlWithParams);
                paramNum = 0;
                sqls.add(sqlWithParams);
            }
            escapeSymbolNum = 0;
            doubleQuoteNum = 0;
            singleQuoteNum = 0;
            markPos = currPos + 1;
        }
        if (currPos > markPos && !StringUtils.isBlank((String)(str = sql.substring(markPos)))) {
            SqlWithParams sqlWithParams = new SqlWithParams();
            TStringUtil.makeSqlParams(paramsIn, hint[0], str, paramFrom, paramNum, sqlWithParams);
            sqls.add(sqlWithParams);
        }
        return sqls;
    }

    public static List<String> splitMultiSql(String sql) {
        String str;
        int currPos;
        ArrayList<String> sqls = new ArrayList<String>();
        int singleQuoteNum = 0;
        int doubleQuoteNum = 0;
        int escapeSymbolNum = 0;
        int markPos = 0;
        String[] hint = TStringUtil.splitUniversalHint(sql);
        sql = hint[1];
        for (currPos = 0; currPos < sql.length(); ++currPos) {
            char c = sql.charAt(currPos);
            if (c == '\'') {
                ++singleQuoteNum;
                continue;
            }
            if (c == '\"') {
                ++doubleQuoteNum;
                continue;
            }
            if (c == '`') {
                ++escapeSymbolNum;
                continue;
            }
            if (c == '\\') {
                ++currPos;
                continue;
            }
            if (c != ';' || singleQuoteNum % 2 != 0 || doubleQuoteNum % 2 != 0 || escapeSymbolNum % 2 != 0) continue;
            String str2 = sql.substring(markPos, currPos);
            if (!StringUtils.isBlank((String)str2)) {
                if (!StringUtils.isEmpty((String)hint[0])) {
                    sqls.add(String.format("/*%s*/ %s", hint[0], str2));
                } else {
                    sqls.add(str2);
                }
            }
            escapeSymbolNum = 0;
            doubleQuoteNum = 0;
            singleQuoteNum = 0;
            markPos = currPos + 1;
        }
        if (currPos > markPos && !StringUtils.isBlank((String)(str = sql.substring(markPos)))) {
            if (!StringUtils.isEmpty((String)hint[0])) {
                sqls.add(String.format("/*%s*/ %s", hint[0], str));
            } else {
                sqls.add(str);
            }
        }
        return sqls;
    }

    public static void main(String[] args) {
        String sql = "/* 1e1eb43a15015710331601001d2730/9//554cdbce/ */insert into `base_one_db_multi_tb_0` ( `pk`, `int_test`) values ( ?, ?) ;update `base_one_db_multi_tb_1` set `int_test` = ? where (`pk` = ?);delete from `base_one_db_multi_tb_1`  where (`pk` = ?)";
        sql = " insert into `base_one_db_multi_tb_0` ( `pk`, `int_test`) values ( ?, ?) ;update `base_one_db_multi_tb_1` set `int_test` = ? where (`pk` = ?);delete from `base_one_db_multi_tb_1`  where (`pk` = ?)";
        List<String> list = TStringUtil.splitMultiSql(sql);
        System.out.println(list);
        ArrayList[] params = new ArrayList[5];
        for (int i = 0; i < 5; ++i) {
            params[i] = new ArrayList();
            params[i].add(i);
        }
        List<SqlWithParams> sqlWithParams = TStringUtil.splitMultiSqlWithParams(sql, params);
        System.out.println(sqlWithParams);
    }

    static {
        try {
            toPlainStringMethod = BigDecimal.class.getMethod("toPlainString", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        TRACE = "trace ";
    }

    public static class SqlWithParams {
        public String sql;
        public ArrayList<Object>[] params;
    }
}

