/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.string;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class TxcString {
    public static int MAX_TXCINST_LEN = 150;
    public static int MAX_APPNAME_LEN = 50;
    private static ConcurrentHashMap<String, List<Pattern>> patternsMap = new ConcurrentHashMap();

    public static String removeBetweenWithSplitor(String sql, String start, String end) {
        if (sql == null) {
            return null;
        }
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return sql;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return sql;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sql.substring(0, index0));
        sb.append(" ");
        sb.append(sql.substring(index1 + end.length()));
        return sb.toString();
    }

    public static String getBetween(String sql, String start, String end) {
        if (sql == null) {
            return null;
        }
        int index0 = sql.indexOf(start);
        if (index0 == -1) {
            return null;
        }
        int index1 = sql.indexOf(end, index0);
        if (index1 == -1) {
            return null;
        }
        return sql.substring(index0 + start.length(), index1).trim();
    }

    public static List<String> readLineToList(String data) {
        if (data == null) {
            return null;
        }
        try {
            String line;
            LinkedList<String> list = new LinkedList<String>();
            BufferedReader br = new BufferedReader(new StringReader(data));
            while ((line = br.readLine()) != null) {
                list.add(line);
            }
            return list;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toServerAddressVipVPCDataId(String serverAddress) {
        return TxcString.buildVipDataId(serverAddress, "com.taobao.txc.vip.vpc");
    }

    public static String toServerAddressVipDataId(String serverAddress) {
        return TxcString.buildVipDataId(serverAddress, "com.taobao.txc.vip");
    }

    private static String buildVipDataId(String serverAddress, String vipDataidPrefix) {
        int pos = serverAddress.indexOf(":");
        if (pos == -1) {
            return null;
        }
        String ip = serverAddress.substring(0, pos);
        String port = serverAddress.substring(pos + 1);
        return String.format("%s.%s.%s", vipDataidPrefix, ip, port);
    }

    public static String txcInstsToStr(Set<String> txcInsts) {
        if (txcInsts == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        for (String txcInst : txcInsts) {
            if (i == 0) {
                ++i;
                stringBuilder.append(txcInst);
                continue;
            }
            stringBuilder.append(',');
            stringBuilder.append(txcInst);
        }
        return stringBuilder.toString();
    }

    public static Set<String> parseInstsStr(String txcInstsStr) {
        StringTokenizer stringTokenizer = new StringTokenizer(txcInstsStr, ",");
        HashSet<String> ret = new HashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            ret.add(stringTokenizer.nextToken());
        }
        return ret;
    }

    public static String makeTxcAnnoMethodStr(Method method) {
        return TxcString.makeTxcAnnoMethodStr(method.getDeclaringClass().getName(), method.getName());
    }

    public static String limitAppName(String appname) {
        if (appname != null && appname.length() > MAX_APPNAME_LEN) {
            appname = String.format("...%s", appname.substring(appname.length() - MAX_APPNAME_LEN));
        }
        return appname;
    }

    public static String makeTxcAnnoMethodStr(String className, String methodName) {
        String output = String.format("%s.%s", className, methodName);
        if (output.length() > MAX_TXCINST_LEN) {
            output = String.format("...%s", output.substring(output.length() - MAX_TXCINST_LEN));
        }
        return output;
    }

    public static String genUniqDiamondId(String dataId, String group) {
        return String.format("[%s]:[%s]", dataId, group);
    }

    private static InputStream toInputStream(String input) {
        return TxcString.toInputStream(input, Charset.defaultCharset());
    }

    private static InputStream toInputStream(String input, Charset encoding) {
        return new ByteArrayInputStream(input.getBytes(encoding));
    }

    public static boolean isMatchTable(String tableName, String patterns) {
        try {
            List<Pattern> patternList;
            if (tableName.charAt(0) == '`') {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
            if ((patternList = patternsMap.get(patterns)) == null) {
                String ptn;
                patternList = new ArrayList<Pattern>();
                DataInputStream dataInputStream = new DataInputStream(TxcString.toInputStream(patterns));
                while (null != (ptn = dataInputStream.readLine()) && ptn.length() > 0) {
                    patternList.add(Pattern.compile(ptn));
                }
                patternsMap.putIfAbsent(patterns, patternList);
            }
            for (Pattern pattern : patternList) {
                if (!pattern.matcher(tableName).matches()) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String printBytes(byte[] bs) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("(");
        for (byte b : bs) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append("0x").append(Integer.toHexString(b & 0xFF));
        }
        sb.append(")");
        return sb.toString();
    }

    public static String getDateBeforeNow(int pastDays) {
        Calendar timeMark = Calendar.getInstance();
        timeMark.add(6, -pastDays);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(timeMark.getTime());
    }

    public static Map<String, String> parseTxcJvmOpts(String jvmOpts) {
        StringTokenizer stringTokenizer = new StringTokenizer(jvmOpts, "-D");
        HashMap<String, String> ret = new HashMap<String, String>();
        while (stringTokenizer.hasMoreTokens()) {
            String str = stringTokenizer.nextToken();
            int pos = str.indexOf(61);
            if (pos == -1) {
                ret.put(str.trim(), "");
                continue;
            }
            String key = str.substring(0, pos).trim();
            String value = str.substring(pos + 1).trim();
            ret.put(key, value);
        }
        return ret;
    }

    public static void main(String[] args) {
        String strInsts = "a.b.c,c.d.e,e.f.a";
        Set<String> txcInsts = TxcString.parseInstsStr(strInsts);
        System.out.println(txcInsts);
        System.out.println(TxcString.txcInstsToStr(txcInsts));
        strInsts = "a.b.c";
        txcInsts = TxcString.parseInstsStr(strInsts);
        System.out.println(txcInsts);
        System.out.println(TxcString.txcInstsToStr(txcInsts));
        System.out.println(TxcString.makeTxcAnnoMethodStr("aaa.bbb.ddd.eee.fff.ggg", "testme()"));
        StringBuilder patterns = new StringBuilder();
        patterns.append("aaa*").append('\n');
        patterns.append("bbb*").append('\n');
        patterns.append("\\w*_test").append('\n');
        patterns.append("ccc").append('\n');
        patterns.append("students_\\d{4}").append('\n');
        patterns.append("td_task_payment_\\d{4}");
        System.out.println(TxcString.isMatchTable("aaa", patterns.toString()));
        System.out.println(TxcString.isMatchTable("A_test", patterns.toString()));
        System.out.println(TxcString.isMatchTable("1_test", patterns.toString()));
        System.out.println(TxcString.isMatchTable("td_task_payment_", patterns.toString()));
        System.out.println(TxcString.isMatchTable("students_0001", patterns.toString()));
        System.out.println(TxcString.isMatchTable("td_task_payment_1231", patterns.toString()));
    }
}

