/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.version;

public class VerNum {
    private String version;

    public VerNum(String version) {
        if (version == null || version.isEmpty()) {
            throw new RuntimeException(String.format("version %s is invalid", version));
        }
        this.version = version;
    }

    public boolean greaterThan(String version) {
        if (version == null || version.isEmpty()) {
            throw new RuntimeException(String.format("version %s is invalid", version));
        }
        return VerNum.verNum(this.version) > VerNum.verNum(version);
    }

    public boolean smallerThan(String version) {
        if (version == null || version.isEmpty()) {
            throw new RuntimeException(String.format("version %s is invalid", version));
        }
        return VerNum.verNum(this.version) < VerNum.verNum(version);
    }

    public static int verNum(String version) {
        String[] verArray;
        int idx = 0;
        idx = version.indexOf("-");
        if (idx > 0) {
            version = version.substring(0, idx);
        }
        if ((verArray = version.split("\\.")) == null) {
            return -1;
        }
        int[] vers = new int[]{0, 0, 0, 0};
        for (int i = 0; i < verArray.length && i < vers.length; ++i) {
            vers[i] = Integer.parseInt(verArray[i]);
        }
        int num = 0;
        try {
            for (int v : vers) {
                num = num * 100 + v;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return num;
    }

    public static void main(String[] args) {
        String ver = "1.2.13";
        System.out.println(VerNum.verNum(ver));
        ver = "1.3.1";
        System.out.println(VerNum.verNum(ver));
        ver = "1.3";
        System.out.println(VerNum.verNum(ver));
        ver = "1.2.12.1";
        System.out.println(VerNum.verNum(ver));
    }
}

