/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.common.util.version;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.util.version.VersionAnnotation;
import java.net.URL;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public final class Version {
    private static final String VERSION = "2.8.69";
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final Package myPackage = VersionAnnotation.class.getPackage();
    private static final VersionAnnotation va = myPackage.getAnnotation(VersionAnnotation.class);
    private static final String SYS_PROPERTY_VERSION_CHECK = "txc.version.check";

    private Version() {
    }

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersion(Class<?> cls, String defaultVersion) {
        if (va != null) {
            defaultVersion = va.version();
        }
        try {
            String version = cls.getPackage().getImplementationVersion();
            if (version == null || version.length() == 0) {
                version = cls.getPackage().getSpecificationVersion();
            }
            if (version == null || version.length() == 0) {
                CodeSource codeSource = cls.getProtectionDomain().getCodeSource();
                if (codeSource == null) {
                    logger.info("No codeSource for class " + cls.getName() + " when getVersion, use default version " + defaultVersion);
                } else {
                    String file = codeSource.getLocation().getFile();
                    version = Version.getVerionByPath(file);
                }
            }
            if (Version.checkVersionNecessary(version)) {
                return version == null || version.length() == 0 ? defaultVersion : version;
            }
            return defaultVersion;
        }
        catch (Throwable e) {
            logger.error("errorCode", "return default version, ignore exception " + e.getMessage(), e);
            return defaultVersion;
        }
    }

    private static boolean inModules(String file, Set<String> modules) {
        if (modules == null) {
            return false;
        }
        for (String moduleName : modules) {
            if (file.indexOf(moduleName) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean validVersionInner(String name, String path, String minVersion, Set<String> skipModules) {
        block4: {
            try {
                if (minVersion == null) {
                    return true;
                }
                Long minv = Version.convertVersion(minVersion);
                Enumeration<URL> urls = Version.class.getClassLoader().getResources(path);
                while (urls.hasMoreElements()) {
                    Long ver;
                    String file;
                    URL url = urls.nextElement();
                    if (url == null || (file = url.getFile()) == null || file.length() <= 0 || Version.inModules(file, skipModules)) continue;
                    String version = Version.getVerionByPath(file);
                    logger.info(name + " version is " + version + ",url:" + url.toString() + ",path:" + file);
                    if (!Version.checkVersionNecessary(version) || (ver = Version.convertVersion(version)) >= minv) continue;
                    throw new IllegalStateException("check " + name + " version is " + version + " < " + minVersion + "(the minimum version), please upgrade " + name + " jar version");
                }
            }
            catch (Throwable e) {
                logger.error("errorCode", e.getMessage(), e);
                if (!"fastjson".equals(name)) break block4;
                e.printStackTrace();
                System.exit(-1);
            }
        }
        return true;
    }

    public static boolean validVersion(String name, String path, String minVersion) {
        return Version.validVersionInner(name, path, minVersion, null);
    }

    public static boolean validVersion(String name, String path, String minVersion, String skipModule) {
        HashSet<String> skipModules = new HashSet<String>();
        skipModules.add(skipModule);
        return Version.validVersionInner(name, path, minVersion, skipModules);
    }

    public static boolean checkDuplicate(Class<?> cls, boolean failOnError) {
        return Version.checkDuplicate(cls.getName().replace('.', '/') + ".class", failOnError);
    }

    public static boolean checkDuplicate(Class<?> cls) {
        return Version.checkDuplicate(cls, false);
    }

    public static boolean checkDuplicate(String path, boolean failOnError) {
        try {
            Enumeration<URL> urls = Version.class.getClassLoader().getResources(path);
            HashSet<String> files = new HashSet<String>();
            while (urls.hasMoreElements()) {
                String file;
                URL url = urls.nextElement();
                if (url == null || (file = url.getFile()) == null || file.length() <= 0) continue;
                files.add(file);
            }
            if (files.size() > 1) {
                String error = "Duplicate class " + path + " in " + files.size() + " jar " + files;
                if (failOnError) {
                    throw new IllegalStateException(error);
                }
                logger.error("errorCode", error);
                return true;
            }
        }
        catch (Throwable e) {
            logger.error("errorCode", e.getMessage(), e);
        }
        return false;
    }

    public static String getVerionByPath(String file) {
        if (file != null && file.length() > 0 && StringUtils.contains((String)file, (String)".jar")) {
            int index = StringUtils.lastIndexOf((String)file, (String)".jar");
            int i = (file = file.substring(0, index)).lastIndexOf(47);
            if (i >= 0) {
                file = file.substring(i + 1);
            }
            if ((i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            while (file.length() > 0 && !Character.isDigit(file.charAt(0)) && (i = file.indexOf("-")) >= 0) {
                file = file.substring(i + 1);
            }
            return file;
        }
        return null;
    }

    public static Long convertVersion(String version) {
        String[] parts = StringUtils.split((String)version, (char)'.');
        Long result = 0L;
        int i = 1;
        int size = parts.length > 4 ? parts.length : 4;
        for (String part : parts) {
            if (StringUtils.isNumeric((String)part)) {
                result = result + Long.valueOf(part) * Double.valueOf(Math.pow(100.0, size - i)).longValue();
            } else {
                String[] subParts = StringUtils.split((String)part, (char)'-');
                if (StringUtils.isNumeric((String)subParts[0])) {
                    result = result + Long.valueOf(subParts[0]) * Double.valueOf(Math.pow(100.0, size - i)).longValue();
                }
            }
            ++i;
        }
        return result;
    }

    private static boolean checkVersionNecessary(String versionStr) {
        return versionStr != null && !StringUtils.contains((String)versionStr, (String)"with-dependencies") && !StringUtils.contains((String)versionStr, (String)"storm");
    }

    static {
        String value = System.getProperty(SYS_PROPERTY_VERSION_CHECK);
        if (!StringUtils.isEmpty((String)value) && "true".equalsIgnoreCase(value)) {
            Version.checkDuplicate("com/alibaba/druid/pool/DruidDataSource.class", false);
            Version.validVersion("druid", "com/alibaba/druid/pool/DruidDataSource.class", "1.0.9");
            Version.checkDuplicate("com/taobao/diamond/client/Diamond.class", false);
            Version.validVersion("diamond", "com/taobao/diamond/client/Diamond.class", "3.6.8");
            Version.checkDuplicate("com/alibaba/fastjson/JSON.class", false);
            Version.validVersion("fastjson", "com/alibaba/fastjson/JSON.class", "1.1.36");
            Version.checkDuplicate("com/mysql/jdbc/Driver.class", false);
            Version.validVersion("mysql", "com/mysql/jdbc/Driver.class", "5.1.34", "txc-driver");
            Version.checkDuplicate("org/slf4j/impl/StaticLoggerBinder.class", false);
            Version.validVersion("tddl5", "com/taobao/tddl/matrix/jdbc/TDataSource.class", "5.1.23");
        }
    }
}

