/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.datasource.cobar;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcUnSupportException;
import com.taobao.txc.common.util.blob.BlobUtil;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.jdbc.warpper.TxcConnectionExceptionHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.StringUtils;

public class TxcConnection
extends TxcConnectionExceptionHandler {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final int ORACLE_BLOB_WRITE_LIMIT = 1000000;

    public TxcConnection(Connection targetConnection, ITxcDataSource targetDataSource) {
        super(targetConnection, targetDataSource);
    }

    @Override
    public String getEncoding() {
        throw new TxcUnSupportException();
    }

    @Override
    public int cleanOldUndoLog(String txcLogTableName, int cleanOldTxcDays, int cleanRequire) throws SQLException {
        if (cleanRequire < 1) {
            return 0;
        }
        StringBuilder cleanOldSql = new StringBuilder("DELETE FROM ");
        cleanOldSql.append(txcLogTableName);
        String targetDate = TxcString.getDateBeforeNow(cleanOldTxcDays);
        Statement pst = null;
        int totalClean = 0;
        try {
            if (this.getDsType() != TxcDbType.ORACLE) {
                cleanOldSql.append(" WHERE gmt_modified < '").append(targetDate).append("'");
                cleanOldSql.append(" LIMIT ").append(cleanRequire);
            } else {
                cleanOldSql.append(" WHERE gmt_modified < to_date('").append(targetDate).append("','yyyy-mm-dd')");
            }
            Connection targetConnection = this.getTargetConnection();
            boolean originalAutoCommit = targetConnection.getAutoCommit();
            if (!originalAutoCommit) {
                targetConnection.setAutoCommit(true);
            }
            pst = targetConnection.prepareStatement(cleanOldSql.toString());
            totalClean = pst.executeUpdate();
            if (!originalAutoCommit) {
                targetConnection.setAutoCommit(originalAutoCommit);
            }
            logger.info((Object)((Object)this.getDsType()) + " cleanOldUndoLog SQL[" + cleanOldSql.toString() + "] affect row count [" + totalClean + "]");
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
        return totalClean;
    }

    @Override
    public void setEncoding(String encoding) {
        throw new TxcUnSupportException();
    }

    @Override
    public void flushUndoLog(TxcRuntimeContext txcLog, String txcLogTableName) throws SQLException {
        block28: {
            PreparedStatement pst;
            long branchID;
            String xid;
            block26: {
                String serverAddr;
                block27: {
                    block25: {
                        if (txcLog == null) {
                            logger.error("", "txcLog is null");
                            return;
                        }
                        xid = txcLog.getXid();
                        branchID = txcLog.getBranchId();
                        serverAddr = txcLog.getServer();
                        TxcDbType dbType = this.getDsType();
                        if (dbType == TxcDbType.ORACLE) break block27;
                        StringBuilder insertSql = new StringBuilder("INSERT INTO ");
                        insertSql.append(txcLogTableName);
                        insertSql.append("(id, xid, branch_id, rollback_info, ");
                        insertSql.append("gmt_create, gmt_modified, status, server)");
                        insertSql.append(" VALUES(");
                        insertSql.append("?,");
                        insertSql.append("?,");
                        insertSql.append("?,");
                        insertSql.append("?,");
                        insertSql.append("now(),");
                        insertSql.append("now(),");
                        insertSql.append(txcLog.getStatus());
                        insertSql.append(",?)");
                        PreparedStatement pst2 = null;
                        try {
                            pst2 = this.getTargetConnection().prepareStatement(insertSql.toString());
                            pst2.setLong(1, branchID);
                            pst2.setString(2, xid);
                            pst2.setLong(3, branchID);
                            if (dbType != TxcDbType.POSTGRESQL) {
                                pst2.setBlob(4, BlobUtil.string2blob(txcLog.encode()));
                            } else {
                                logger.debug("before insert rollbackInfo:" + txcLog.encode());
                                pst2.setBytes(4, txcLog.encode().getBytes(Charset.forName("UTF-8")));
                            }
                            pst2.setString(5, serverAddr);
                            pst2.executeUpdate();
                            if (logger.isDebugEnabled()) {
                                logger.debug(txcLog.getXid());
                                logger.debug("" + txcLog.getBranchId());
                                logger.debug("size:" + txcLog.getInforList().size());
                                for (RollbackInfor i : txcLog.getInforList()) {
                                    logger.debug(i.toString());
                                }
                                logger.debug(txcLog.encode());
                            }
                            if (pst2 == null) break block25;
                        }
                        catch (Exception e) {
                            try {
                                logger.error(String.format("%s:%d %s", xid, branchID, txcLog.encode()), TxcErrCode.InsertTxcLogError, (Throwable)e);
                                if (e instanceof SQLException) {
                                    throw (SQLException)e;
                                }
                                throw new SQLException(e);
                            }
                            catch (Throwable throwable) {
                                if (pst2 != null) {
                                    pst2.close();
                                }
                                logger.info(String.format("[%d:%d] insertUndoLog cost %d ms", TxcXID.getTransactionId(xid), branchID, txcLog.getRTFromLastPoint()));
                                throw throwable;
                            }
                        }
                        pst2.close();
                    }
                    logger.info(String.format("[%d:%d] insertUndoLog cost %d ms", TxcXID.getTransactionId(xid), branchID, txcLog.getRTFromLastPoint()));
                    break block28;
                }
                StringBuilder insertSql = new StringBuilder("INSERT INTO ");
                insertSql.append(txcLogTableName);
                insertSql.append("(id, xid, branch_id, rollback_info, ");
                insertSql.append("gmt_create, gmt_modified, status, server)");
                insertSql.append(" VALUES(");
                insertSql.append("?,");
                insertSql.append("?,");
                insertSql.append("?,");
                insertSql.append("empty_blob(),");
                insertSql.append("sysdate,");
                insertSql.append("sysdate,");
                insertSql.append(txcLog.getStatus());
                insertSql.append(",?)");
                pst = null;
                ResultSet rs = null;
                Object blob = null;
                try {
                    pst = this.getTargetConnection().prepareStatement(insertSql.toString());
                    pst.setLong(1, branchID);
                    pst.setString(2, xid);
                    pst.setLong(3, branchID);
                    pst.setString(4, serverAddr);
                    pst.executeUpdate();
                    pst.close();
                    String sql = "SELECT rollback_info FROM " + txcLogTableName + " WHERE id = " + branchID + " FOR UPDATE";
                    pst = this.getTargetConnection().prepareStatement(sql);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        blob = rs.getBlob(1);
                    }
                    OutputStream out = (OutputStream)blob.getClass().getMethod("setBinaryStream", Long.TYPE).invoke(blob, 1L);
                    String log = txcLog.encode();
                    byte[] bs = log.getBytes();
                    if (bs.length > 1000000) {
                        int begin = 0;
                        int remain = bs.length;
                        int limit = 1000000;
                        while (remain > 0) {
                            out.write(bs, begin, limit);
                            begin += limit;
                            limit = (remain -= limit) < limit ? remain : limit;
                        }
                    } else {
                        out.write(bs, 0, bs.length);
                    }
                    out.close();
                    if (logger.isDebugEnabled()) {
                        logger.debug(txcLog.getXid());
                        logger.debug("" + txcLog.getBranchId());
                        logger.debug("size:" + txcLog.getInforList().size());
                        for (RollbackInfor i : txcLog.getInforList()) {
                            logger.debug(i.toString());
                        }
                        logger.debug(txcLog.encode());
                    }
                    if (rs == null) break block26;
                }
                catch (Exception e) {
                    try {
                        logger.error(String.format("%s:%d %s", xid, branchID, txcLog.encode()), TxcErrCode.InsertTxcLogError, (Throwable)e);
                        if (e instanceof SQLException) {
                            throw (SQLException)e;
                        }
                        throw new SQLException(e);
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            rs.close();
                        }
                        if (pst != null) {
                            pst.close();
                        }
                        logger.info(String.format("[%d:%d] insertUndoLog cost %d ms", TxcXID.getTransactionId(xid), branchID, txcLog.getRTFromLastPoint()));
                        throw throwable;
                    }
                }
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
            logger.info(String.format("[%d:%d] insertUndoLog cost %d ms", TxcXID.getTransactionId(xid), branchID, txcLog.getRTFromLastPoint()));
        }
    }

    @Override
    public String getUndoLog(ITxcConnection conn, String sql) throws SQLException, IOException {
        if (StringUtils.isEmpty((String)sql)) {
            logger.error("", "txc sql is null");
            return null;
        }
        Blob b = null;
        byte[] bytesInfo = null;
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.getTargetConnection().prepareStatement(sql);
            rs = pst.executeQuery();
            if (rs.next()) {
                if (this.getDsType() == TxcDbType.POSTGRESQL) {
                    bytesInfo = rs.getBytes("rollback_info");
                } else {
                    b = rs.getBlob("rollback_info");
                }
            }
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (pst != null) {
                pst.close();
            }
        }
        if (this.getDsType() != TxcDbType.ORACLE) {
            if (this.getDsType() == TxcDbType.POSTGRESQL) {
                if (null != bytesInfo && bytesInfo.length > 0) {
                    return new String(bytesInfo, "UTF-8");
                }
                return null;
            }
            return BlobUtil.blob2string(b);
        }
        if (b == null) {
            return null;
        }
        try {
            InputStream in = (InputStream)b.getClass().getMethod("getBinaryStream", new Class[0]).invoke((Object)b, new Object[0]);
            String log = BlobUtil.inputStream2String(in);
            in.close();
            return log;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

