/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.datasource.cobar;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.exception.TxcUnSupportException;
import com.taobao.txc.datasource.cobar.TxcConnection;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;

public class TxcDataSource
implements ITxcDataSource {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final String DRUID_DATASOURCE_CLASS = "com.alibaba.druid.pool.DruidDataSource";
    private static final String DRUID_DATASOURCE_MARKER = "DruidDataSource";
    private static final String HIKARI_DATASOURCE_CLASS = "com.zaxxer.hikari.HikariDataSource";
    private final DataSource targetDataSource;
    private volatile boolean isInit = false;
    private final TxcAtomDataSourceHelper dsHelper = new TxcAtomDataSourceHelper();
    private String dbType;
    private String validateQuery = "SELECT 'x'";
    private Method setDriverClassName;
    private Method setUrl;
    private Method setUsername;
    private Method setPassword;
    private Method setDbType;
    private Method setValidateQuery;
    private Method getDbName;
    private Method getUserName;
    private TxcException unsupportedDataSourceException = null;

    @Deprecated
    public TxcDataSource() {
        this.targetDataSource = this.initDruidDataSource();
        this.initDruidMethods(this.targetDataSource.getClass());
        this.setValidateQuery(this.validateQuery);
    }

    public TxcDataSource(DataSource dataSource) {
        this.targetDataSource = dataSource;
        if (!this.isSupportedDataSource(dataSource)) {
            throw this.getUnsupportedDataSourceException();
        }
        this.initDbType(this.targetDataSource);
    }

    private void initDbType(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            this.dbType = conn.getMetaData().getDatabaseProductName();
        }
        catch (SQLException exx) {
            logger.error("getConnError", exx.getMessage());
            throw new RuntimeException("get conn error," + exx.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException exx) {
                    logger.error("closeConnError", exx.getMessage());
                }
            }
        }
    }

    private DataSource initDruidDataSource() {
        try {
            Class<?> clz = Class.forName(DRUID_DATASOURCE_CLASS);
            Constructor<?> constructor = clz.getConstructor(new Class[0]);
            return (DataSource)constructor.newInstance(new Object[0]);
        }
        catch (Exception ex) {
            String errorMessage = "Failed to loadDefaultDataSource";
            logger.error("Unknown", errorMessage, (Throwable)ex);
            throw new TxcException(errorMessage + " " + ex.getMessage());
        }
    }

    private void invokeSetterMethod(Method method, String param) {
        if (method == null) {
            throw this.getUnsupportedDataSourceException();
        }
        try {
            method.invoke((Object)this.targetDataSource, param);
        }
        catch (Exception ex) {
            String errorMessage = "Failed to " + method;
            logger.error("Unknown", errorMessage, (Throwable)ex);
            throw new TxcException(errorMessage + " " + ex.getMessage());
        }
    }

    private String invokeGetterMethod(Method method) {
        if (method == null) {
            throw this.getUnsupportedDataSourceException();
        }
        try {
            return (String)method.invoke((Object)this.targetDataSource, new Object[0]);
        }
        catch (Exception ex) {
            String errorMessage = "Failed to " + method;
            logger.error("Unknown", errorMessage, (Throwable)ex);
            throw new TxcException(errorMessage + " " + ex.getMessage());
        }
    }

    private boolean isSupportedDataSource(DataSource dataSource) {
        Class<?> dataSourceClz = dataSource.getClass();
        if (dataSourceClz.getName().contains(DRUID_DATASOURCE_MARKER)) {
            this.initDruidMethods(dataSourceClz);
            return true;
        }
        if (HIKARI_DATASOURCE_CLASS.equals(dataSourceClz.getName())) {
            this.initHikariMethods(dataSourceClz);
            return true;
        }
        return false;
    }

    private void initHikariMethods(Class dataSourceClz) {
        try {
            this.setDriverClassName = dataSourceClz.getMethod("setDriverClassName", String.class);
            this.setUrl = dataSourceClz.getMethod("setJdbcUrl", String.class);
            this.setUsername = dataSourceClz.getMethod("setUsername", String.class);
            this.setPassword = dataSourceClz.getMethod("setPassword", String.class);
            this.setDbType = null;
            this.setValidateQuery = dataSourceClz.getMethod("setConnectionTestQuery", String.class);
            this.getDbName = dataSourceClz.getMethod("getJdbcUrl", new Class[0]);
            this.getUserName = dataSourceClz.getMethod("getUsername", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Unknown", ex.getMessage());
            throw new TxcException(ex);
        }
    }

    private void initDruidMethods(Class dataSourceClz) {
        try {
            this.setDriverClassName = dataSourceClz.getMethod("setDriverClassName", String.class);
            this.setUrl = dataSourceClz.getMethod("setUrl", String.class);
            this.setUsername = dataSourceClz.getMethod("setUsername", String.class);
            this.setPassword = dataSourceClz.getMethod("setPassword", String.class);
            this.setDbType = dataSourceClz.getMethod("setDbType", String.class);
            this.setValidateQuery = dataSourceClz.getMethod("setValidationQuery", String.class);
            this.getDbName = dataSourceClz.getMethod("getUrl", new Class[0]);
            this.getUserName = dataSourceClz.getMethod("getUsername", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Unknown", ex.getMessage());
            throw new TxcException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isInit) {
            TxcDataSource txcDataSource = this;
            synchronized (txcDataSource) {
                if (!this.isInit) {
                    String dbName = this.getDbName();
                    this.dsHelper.init(this, dbName, null);
                    logger.info("TxcDataSource:[" + dbName + "] init success.");
                    this.isInit = true;
                }
            }
        }
        Connection tddlConn = this.targetDataSource.getConnection();
        return new TxcConnection(tddlConn, this);
    }

    @Override
    public DataSource getTargetDataSource() throws SQLException {
        return this.targetDataSource;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.targetDataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.targetDataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.targetDataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.targetDataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.targetDataSource.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.targetDataSource.isWrapperFor(iface);
    }

    public void setDriverClassName(String driverClass) {
        this.invokeSetterMethod(this.setDriverClassName, driverClass);
    }

    public void setUrl(String jdbcUrl) {
        this.invokeSetterMethod(this.setUrl, jdbcUrl);
    }

    public void setUsername(String username) {
        this.invokeSetterMethod(this.setUsername, username);
    }

    public void setPassword(String password) {
        this.invokeSetterMethod(this.setPassword, password);
    }

    public void setDbType(String dbType) {
        this.invokeSetterMethod(this.setDbType, dbType);
    }

    @Override
    public String getDBType() {
        return this.dbType;
    }

    @Override
    public void setDBType(String dbType) {
        this.dbType = dbType;
    }

    @Override
    public String getDbName() {
        String jdbcUrl = this.invokeGetterMethod(this.getDbName);
        if (null != this.getDBType() && this.getDBType().equalsIgnoreCase(TxcDbType.ORACLE.name())) {
            jdbcUrl = jdbcUrl + "?userName=";
            jdbcUrl = jdbcUrl + this.invokeGetterMethod(this.getUserName);
        }
        return jdbcUrl;
    }

    @Override
    public String getAppName() {
        return System.getProperty("appName");
    }

    @Override
    public String getSchemaName() {
        return System.getProperty("schemaName");
    }

    @Override
    public String getGroupKey() {
        return null;
    }

    public String getValidateQuery() {
        return this.validateQuery;
    }

    public void setValidateQuery(String validateQuery) {
        this.validateQuery = validateQuery;
        this.invokeSetterMethod(this.setValidateQuery, validateQuery);
    }

    private TxcException getUnsupportedDataSourceException() {
        if (this.unsupportedDataSourceException == null) {
            this.unsupportedDataSourceException = new TxcException("Unsupported DataSource " + this.targetDataSource.getClass() + ":" + this.targetDataSource);
        }
        return this.unsupportedDataSourceException;
    }
}

