/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.algorithm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.TreeSet;

public class IntKeyScopeMerge {
    private TreeSet<Long> values = new TreeSet();
    private List<Scope> scopeList = new ArrayList<Scope>();
    public String column;

    public IntKeyScopeMerge(String column) {
        this.column = column;
    }

    public void insert(long value) {
        this.values.add(value);
    }

    private void calc() {
        this.scopeList.clear();
        for (long v : this.values) {
            Scope scope = this.getLastScopeIfPresent(v);
            if (scope.max == v) continue;
            if (scope.max + 1L == v) {
                ++scope.max;
                continue;
            }
            scope = new Scope(v, v);
            this.scopeList.add(scope);
        }
    }

    public Scope getLastScopeIfPresent(long v) {
        if (this.scopeList.size() == 0) {
            Scope scope = new Scope(v, v);
            this.scopeList.add(scope);
            return scope;
        }
        return this.scopeList.get(this.scopeList.size() - 1);
    }

    public void printScope() {
        this.calc();
        for (int i = 0; i < this.scopeList.size(); ++i) {
            System.out.println(this.scopeList.get(i));
        }
    }

    public static void printExcept(TreeSet<Integer> skipValues) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Integer> integerIterator = skipValues.iterator();
        while (integerIterator.hasNext()) {
            stringBuilder.append(integerIterator.next()).append(' ');
        }
        System.out.println(stringBuilder.toString());
    }

    public String toString() {
        this.calc();
        StringBuilder stringBuilder = new StringBuilder();
        boolean orFlag = false;
        for (int i = 0; i < this.scopeList.size(); ++i) {
            Scope scope = this.scopeList.get(i);
            if (orFlag) {
                stringBuilder.append(" OR ");
            } else {
                orFlag = true;
            }
            if (scope.min == scope.max) {
                stringBuilder.append(this.column).append(" = ").append(scope.min);
                continue;
            }
            stringBuilder.append('(').append(this.column).append(" >= ").append(scope.min).append(" AND ").append(this.column).append(" <= ").append(scope.max).append(')');
        }
        return stringBuilder.toString();
    }

    public static void randomTest() {
        int MAX_INT_NUM = 1000;
        int TEST_MINUS = 50;
        Random random = new Random();
        TreeSet<Integer> skipSet = new TreeSet<Integer>();
        for (int i = 0; i < 50; ++i) {
            skipSet.add(random.nextInt(1000) - 50);
        }
        IntKeyScopeMerge intKeyScopeMerge = new IntKeyScopeMerge("test");
        for (int i = 0; i < 1000; ++i) {
            if (skipSet.contains(i - 50)) continue;
            intKeyScopeMerge.insert(i - 50);
        }
        intKeyScopeMerge.printScope();
        IntKeyScopeMerge.printExcept(skipSet);
    }

    public static void LargeToSmallTest() {
        int MAX_INT_NUM = 1000;
        int TEST_MINUS = 50;
        Random random = new Random();
        TreeSet<Integer> skipSet = new TreeSet<Integer>();
        for (int i = 0; i < 50; ++i) {
            skipSet.add(random.nextInt(1000) - 50);
        }
        IntKeyScopeMerge intKeyScopeMerge = new IntKeyScopeMerge("test");
        for (int i = 0; i < 1000; ++i) {
            int num = 1000 - i - 50;
            if (skipSet.contains(num)) continue;
            intKeyScopeMerge.insert(num);
        }
        intKeyScopeMerge.calc();
        intKeyScopeMerge.printScope();
        IntKeyScopeMerge.printExcept(skipSet);
    }

    public static void randomList() {
        int i;
        IntKeyScopeMerge intKeyScopeMerge = new IntKeyScopeMerge("test");
        for (i = 100; i > 87; --i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 20; i < 31; ++i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 57; i > 35; --i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 63; i < 65; ++i) {
            intKeyScopeMerge.insert(i);
        }
        System.out.println(intKeyScopeMerge.toString());
    }

    public static void randomList2() {
        int i;
        IntKeyScopeMerge intKeyScopeMerge = new IntKeyScopeMerge("test");
        for (i = 100; i > 87; --i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 20; i < 31; ++i) {
            intKeyScopeMerge.insert(i);
        }
        intKeyScopeMerge.insert(200L);
        for (i = 57; i > 35; --i) {
            intKeyScopeMerge.insert(i);
        }
        intKeyScopeMerge.insert(33L);
        for (i = 300; i > 230; --i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 63; i < 65; ++i) {
            intKeyScopeMerge.insert(i);
        }
        for (i = 66; i > 62; --i) {
            intKeyScopeMerge.insert(i);
        }
        System.out.println(intKeyScopeMerge.toString());
    }

    public static void main(String[] args) {
        IntKeyScopeMerge.randomTest();
        System.out.println("-----------------");
        IntKeyScopeMerge.LargeToSmallTest();
        System.out.println("-----------------");
        IntKeyScopeMerge.randomList();
        System.out.println("------------------");
        IntKeyScopeMerge.randomList2();
    }

    public class Scope {
        public long min;
        public long max;

        public Scope(long min, long max) {
            this.min = min;
            this.max = max;
        }

        public String toString() {
            return String.format("[min:%d, max:%d]", this.min, this.max);
        }
    }
}

