/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.ast.stmt.visitor;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.TableRefFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLOutputASTVisitor;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.SQLParserException;
import com.taobao.txc.parser.ast.stmt.visitor.DMLStatementVisitorFactory;
import com.taobao.txc.parser.ast.stmt.visitor.TxcDmlVisitor;
import com.taobao.txc.parser.visitor.api.SQLASTVisitor;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DMLSelectStatementVisitor
implements TxcDmlVisitor {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final DMLSelectStatement statement;
    private final StringBuilder appendable = new StringBuilder();
    private final SQLASTVisitor SQLASTVisitor = new MySQLOutputASTVisitor(this.appendable);

    public DMLSelectStatementVisitor(DMLSelectStatement statement) {
        this.statement = statement;
    }

    @Override
    public String getSql() throws SQLParserException {
        this.appendable.append("SELECT ");
        DMLSelectStatement.SelectOption option = this.statement.getOption();
        switch (option.resultDup) {
            case ALL: {
                break;
            }
            case DISTINCT: {
                this.appendable.append("DISTINCT ");
                break;
            }
            case DISTINCTROW: {
                this.appendable.append("DISTINCTROW ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.highPriority) {
            this.appendable.append("HIGH_PRIORITY ");
        }
        if (option.straightJoin) {
            this.appendable.append("STRAIGHT_JOIN ");
        }
        switch (option.resultSize) {
            case SQL_BIG_RESULT: {
                this.appendable.append("SQL_BIG_RESULT ");
                break;
            }
            case SQL_SMALL_RESULT: {
                this.appendable.append("SQL_SMALL_RESULT ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlBufferResult) {
            this.appendable.append("SQL_BUFFER_RESULT ");
        }
        switch (option.queryCache) {
            case SQL_CACHE: {
                this.appendable.append("SQL_CACHE ");
                break;
            }
            case SQL_NO_CACHE: {
                this.appendable.append("SQL_NO_CACHE ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlCalcFoundRows) {
            this.appendable.append("SQL_CALC_FOUND_ROWS ");
        }
        boolean isFst = true;
        List<Pair<Expression, String>> exprList = this.statement.getSelectExprList();
        for (Pair<Expression, String> p : exprList) {
            String alias;
            if (isFst) {
                isFst = false;
            } else {
                this.appendable.append(", ");
            }
            if (p.getKey() instanceof DMLSelectStatement) {
                this.appendable.append("(");
            }
            p.getKey().accept(this.SQLASTVisitor);
            if (p.getKey() instanceof DMLSelectStatement) {
                this.appendable.append(")");
            }
            if ((alias = p.getValue()) == null) continue;
            this.appendable.append(" AS ").append(alias);
        }
        TableReferences from = this.statement.getTables();
        if (from != null) {
            this.appendable.append(" FROM ");
            TableReferences tRefs = this.statement.getTables();
            if (!tRefs.isSingleTable()) {
                throw new SQLParserException("getTableName error, unsupported complex sql.");
            }
            TableRefFactor table = (TableRefFactor)tRefs.getTableReferenceList().get(0);
            if (StringUtils.isNotEmpty((String)table.getAlias())) {
                this.appendable.append(String.format("`%s` AS `%s`", table.getTable().getIdTextUpUnescape(), table.getAliasUpUnEscape()));
            } else {
                this.appendable.append(String.format("`%s`", table.getTable().getIdTextUpUnescape()));
            }
        }
        Expression where = this.statement.getWhere();
        this.getWhere(where, null);
        GroupBy group = this.statement.getGroup();
        this.getGroupBy(group);
        Expression having = this.statement.getHaving();
        this.getHaving(having);
        OrderBy order = this.statement.getOrder();
        this.getOrderBy(order);
        Limit limit = this.statement.getLimit();
        this.getLimit(limit);
        this.fixOption(this.statement);
        if (logger.isDebugEnabled()) {
            logger.debug(this.appendable.toString());
        }
        return this.appendable.toString();
    }

    String getWhere(Expression where, String extraWhereCondition) {
        if (where != null) {
            this.appendable.append(" WHERE ");
            where.accept(this.SQLASTVisitor);
            if (extraWhereCondition != null && !extraWhereCondition.isEmpty()) {
                this.appendable.append(" AND ");
                this.appendable.append(extraWhereCondition);
            }
        } else if (extraWhereCondition != null && !extraWhereCondition.isEmpty()) {
            this.appendable.append(" WHERE ");
            this.appendable.append(extraWhereCondition);
        }
        return this.appendable.toString();
    }

    String fixOption(DMLSelectStatement node) {
        DMLSelectStatement.SelectOption option = node.getOption();
        switch (option.lockMode) {
            case FOR_UPDATE: {
                this.appendable.append(" FOR UPDATE");
                break;
            }
            case LOCK_IN_SHARE_MODE: {
                this.appendable.append(" LOCK IN SHARE MODE");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        return this.appendable.toString();
    }

    String getLimit(Limit limit) {
        if (limit != null) {
            this.appendable.append(' ');
            limit.accept(this.SQLASTVisitor);
        }
        return this.appendable.toString();
    }

    String getOrderBy(OrderBy order) {
        if (order != null) {
            this.appendable.append(' ');
            order.accept(this.SQLASTVisitor);
        }
        return this.appendable.toString();
    }

    String getHaving(Expression having) {
        if (having != null) {
            this.appendable.append(" HAVING ");
            having.accept(this.SQLASTVisitor);
        }
        return this.appendable.toString();
    }

    String getGroupBy(GroupBy group) {
        if (group != null) {
            this.appendable.append(' ');
            group.accept(this.SQLASTVisitor);
        }
        return this.appendable.toString();
    }

    public static void main(String[] args) {
        ArrayList<String> sqls = new ArrayList<String>(){
            {
                this.add("select id,name from student AS a where a.id > 10");
                this.add("SELECT * FROM Persons");
                this.add("select a,b,c from a where a IN (select d from b )");
                this.add("select * from table1 where time between time1 and time2");
                this.add("select * from table1 where a not in (\u2018\u503c1\u2019,\u2019\u503c2\u2019,\u2019\u503c4\u2019,\u2019\u503c6\u2019)");
                this.add("select * from \u65e5\u7a0b\u5b89\u6392 where datediff('minute',f\u5f00\u59cb\u65f6\u95f4,getdate())>5");
            }
        };
        try {
            for (String sql : sqls) {
                System.out.println("====================================");
                System.out.println(sql);
                System.out.println(DMLStatementVisitorFactory.createSQLStatement(sql).getSql());
            }
        }
        catch (Exception e) {
            System.out.print(e);
        }
    }
}

