/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.hint;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.util.string.TxcString;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class TddlHint {
    public static final String TDDL_HINT_HEAD = "/*+TDDL(";
    public static final String TDDL_HINT_TAIL = ")*/";
    public static final String TXC_XID = "TXC_XID";

    public static String getTddlHint(String sql) {
        return TxcString.getBetween(sql, TDDL_HINT_HEAD, TDDL_HINT_TAIL);
    }

    public static String removeTddlHint(String sql) {
        String hint = TddlHint.getTddlHint(sql);
        if (hint == null || hint.isEmpty()) {
            return sql;
        }
        return TxcString.removeBetweenWithSplitor(sql, TDDL_HINT_HEAD, TDDL_HINT_TAIL).trim();
    }

    public static Map<String, String> getTddlHintMap(String sql) {
        String hint = TddlHint.getTddlHint(sql);
        if (hint == null || hint.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, String> hintmap = new LinkedHashMap<String, String>();
        try {
            Map split = (Map)JSON.parseObject((String)hint, Map.class);
            for (String key : split.keySet()) {
                Object obj = split.get(key);
                hintmap.put(key, obj.toString());
            }
        }
        catch (Exception e) {
            throw new TxcException(e, "hint parse error");
        }
        return hintmap;
    }

    public static String buildHintSql(Map<String, String> maps, String sql) {
        if (maps == null || maps.size() == 0) {
            return sql;
        }
        return TddlHint.buildTddlHint(maps) + " " + TddlHint.removeTddlHint(sql);
    }

    public static String buildTddlHint(Map<String, String> maps) {
        if (maps == null || maps.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TDDL_HINT_HEAD);
        sb.append(JSON.toJSONString(maps, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.UseSingleQuotes}));
        sb.append(TDDL_HINT_TAIL);
        return sb.toString();
    }

    public static String getTxcXid(String sql) {
        Map<String, String> maps = TddlHint.getTddlHintMap(sql);
        if (maps == null || maps.size() == 0) {
            return null;
        }
        String xid = "";
        try {
            xid = maps.get(TXC_XID);
            if (xid == null || xid.length() == 0) {
                return null;
            }
        }
        catch (Exception e) {
            throw new TxcException(e, "xid parse error");
        }
        return xid;
    }

    public static String addTxcXid(String xid, String sql) {
        Map<String, String> maps = TddlHint.getTddlHintMap(sql);
        if (maps == null || maps.size() == 0) {
            maps = new LinkedHashMap<String, String>();
        }
        maps.put(TXC_XID, String.format("%s", xid));
        return TddlHint.buildHintSql(maps, sql);
    }

    public static String removeTxcXid(String sql) {
        Map<String, String> maps = TddlHint.getTddlHintMap(sql);
        if (maps == null || maps.size() == 0) {
            return sql;
        }
        maps.remove(TXC_XID);
        return TddlHint.buildHintSql(maps, sql);
    }

    public static void main(String[] args) {
        ArrayList<String> sqls = new ArrayList<String>(){
            {
                this.add("/*+TDDL({'type':'direct','dbid':'EUNOMIA_GROUP'})*/    /* 1e1ea42514598375209111023d4eee/9// */ update indicator_category     a inner join category b on a.category_id = b.id set a.category_code=b.category_uniq_code;");
                this.add("/*+TDDL({'extra':{'FORCE_GROUPBY_SHARD_COLUMNS':true}})*/ SELECT a.aab001 AS aab001, COUNT(b.acb210) AS zzcount, date_format(a.aae396, '%Y-%m-%d') AS aae396, 0 AS mscount FROM ab01 a LEFT JOIN cb21 b ON a.aab001 = b.aab001 AND b.aae100 = 0 AND b.ycb211 = 0 AND b.ycb202 = 1 WHERE 1 = 1     AND a.aab019 = 10 GROUP BY a.aab001 ORDER BY aae396 DESC LIMIT 0, 9");
                this.add("/*+TDDL({'type':'direct','vtab':'AB01,AB02,ABB1','realtabs':['AB01_0000,AB02_0000,ABB1_0000'],'dbid':'LEAF_BIZ_1456816396752FQHHLEAF_BIZ_VENE_0000_RDS'})*/ select * from a");
            }
        };
        for (String sql : sqls) {
            String newSQL = TddlHint.addTxcXid("127.0.0.1:8080:8888883", sql);
            System.out.println("============================");
            System.out.println("\u539f\u59cbSQL       \uff1a" + sql);
            System.out.println("SQL with XID:  " + newSQL);
            System.out.println("SQL del   XID:  " + TddlHint.removeTxcXid(newSQL));
            System.out.println("XID         \uff1a" + TddlHint.getTxcXid(newSQL));
            Map<String, String> m = TddlHint.getTddlHintMap(newSQL);
            for (String key : m.keySet()) {
                System.out.println("\u83b7\u53d6hint      \uff1a" + key + "------" + m.get(key));
            }
            System.out.println("\u6839\u636emap\uff0c\u6784\u5efaTDDL hint\uff1a" + TddlHint.buildTddlHint(m));
            System.out.println("\u53d6\u6d88TDDL hint\uff0c\u5f97\u5230\u539f\u59cbSQL\uff1a" + TddlHint.removeTddlHint(newSQL));
        }
    }
}

