/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.hint;

import com.taobao.txc.common.util.string.TxcString;
import java.util.HashMap;
import java.util.Map;

public class TxcHint {
    public static String insulateLevel = "'level'";
    public static String readuncommited = "'readuncommited'";
    public static String readcommited = "'readcommited'";

    public static Map<String, Object> hint2map(String hintString) {
        if (hintString == null) {
            return null;
        }
        String hint = null;
        while ((hint = TxcHint.relpaceStok(hintString)) != null) {
            hintString = hint;
        }
        return TxcHint.hint2map0(hintString, ",");
    }

    public static boolean isReadCommited(String sql) {
        return readcommited.equals(TxcHint.getInsulate(sql));
    }

    public static String getInsulate(String sql) {
        Map<String, Object> map = TxcHint.hint2map(TxcHint.getTxcHintString(sql));
        if (map == null) {
            return null;
        }
        return (String)map.get(insulateLevel);
    }

    public static String getTddlHintString(String sql) {
        return TxcString.getBetween(sql.toLowerCase(), "/*+tddl({", "})*/");
    }

    public static String getTxcHintString(String sql) {
        return TxcString.getBetween(sql.toLowerCase(), "/*+txc({", "})*/");
    }

    public static String getTxcRule(String sql) {
        return TxcString.getBetween(sql.toLowerCase(), "/*+txcrule(", ")*/");
    }

    public static String removeTxcHintString(String sql) {
        String tddlHint = TxcHint.getTxcHintString(sql);
        if (null == tddlHint || "".equals(tddlHint)) {
            return sql;
        }
        return TxcString.removeBetweenWithSplitor(sql.toLowerCase(), "/*+txc({", "})*/");
    }

    public static String buildTxcHint(String hint) {
        return "/*+TXC({" + hint + "})*/";
    }

    private static String relpaceStok(String hintString) {
        int index1 = hintString.indexOf(123);
        int index2 = hintString.indexOf(125);
        if (index1 == -1) {
            return null;
        }
        char[] bytes = hintString.toCharArray();
        for (int i = index1; i < index2; ++i) {
            if (bytes[i] != ',') continue;
            bytes[i] = 94;
        }
        bytes[index1] = 91;
        bytes[index2] = 93;
        return String.valueOf(bytes);
    }

    private static Map<String, Object> hint2map0(String hintString, String regex) {
        String[] piece;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String s : piece = hintString.split(regex)) {
            int index = s.indexOf(58);
            if (index == -1) continue;
            String key = s.substring(0, index);
            String value = s.substring(index + 1, s.length());
            char[] valueOfCharArray = value.toCharArray();
            if (valueOfCharArray[0] == '[' && valueOfCharArray[value.length() - 1] == ']') {
                map.put(key, TxcHint.hint2map0(String.copyValueOf(valueOfCharArray, 1, value.length() - 2), "\\^"));
                continue;
            }
            map.put(key, value);
        }
        return map;
    }

    public static void main(String[] args) {
        String hint0 = "'RULES':{'TYPE':'SECKILL','CONTENT':'ACCOUNT=ACCOUNT+3'}";
        String sql = TxcHint.buildTxcHint(hint0) + "select * from student";
        System.out.println(TxcHint.removeTxcHintString(sql));
        String hint = TxcHint.getTxcHintString(sql);
        System.out.println(hint);
        System.out.println(TxcHint.hint2map(hint));
        System.out.println("-----------------------------");
        hint0 = "'LEVEL':'READUNCOMMITED'";
        sql = TxcHint.buildTxcHint(hint0) + "select * from student";
        System.out.println(TxcHint.removeTxcHintString(sql));
        hint = TxcHint.getTxcHintString(sql);
        System.out.println(hint);
        System.out.println(TxcHint.hint2map(hint));
        System.out.println(TxcHint.isReadCommited(sql));
        System.out.println("-----------------------------");
        hint0 = "'LEVEL':'READCOMMITED'";
        sql = TxcHint.buildTxcHint(hint0) + "select * from student";
        System.out.println(TxcHint.removeTxcHintString(sql));
        hint = TxcHint.getTxcHintString(sql);
        System.out.println(hint);
        System.out.println(TxcHint.hint2map(hint));
        System.out.println(TxcHint.isReadCommited(sql));
    }
}

