/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.struct;

import com.taobao.txc.common.util.string.TddlToStringStyle;
import com.taobao.txc.parser.struct.ParameterContext;
import com.taobao.txc.parser.struct.ParameterMethod;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class Parameters {
    private List<Map<Integer, ParameterContext>> batchParams = null;
    private boolean batch = false;
    private Map<Integer, ParameterContext> params = new HashMap<Integer, ParameterContext>();
    private int batchSize = 0;
    private int batchIndex = 0;
    private AtomicInteger sequenceSize = new AtomicInteger(0);
    private AtomicInteger sequenceIndex = new AtomicInteger(0);

    public Parameters() {
    }

    public Parameters(Map<Integer, ParameterContext> currentParameter, boolean isBatch) {
        this.params = currentParameter;
        this.batch = isBatch;
    }

    public Map<Integer, ParameterContext> getCurrentParameter() {
        return this.params;
    }

    public Map<Integer, ParameterContext> getFirstParameter() {
        if (!this.batch) {
            return this.params;
        }
        return this.batchParams.get(0);
    }

    public List<Map<Integer, ParameterContext>> getBatchParameters() {
        if (this.isBatch() && this.batchParams != null) {
            return this.batchParams;
        }
        return Arrays.asList(this.params);
    }

    public Parameters cloneByBatchIndex(int batchIndex) {
        List<Map<Integer, ParameterContext>> batchs = this.getBatchParameters();
        if (batchIndex >= batchs.size()) {
            throw new IllegalArgumentException("batchIndex is invalid");
        }
        Parameters parameters = new Parameters(batchs.get(batchIndex), this.isBatch());
        parameters.setBatchSize(this.batchSize);
        parameters.setBatchIndex(batchIndex);
        parameters.setSequenceSize(this.sequenceSize);
        return parameters;
    }

    public void addBatch() {
        if (this.batchParams == null) {
            this.batchParams = new ArrayList<Map<Integer, ParameterContext>>();
        }
        this.batchParams.add(this.params);
        this.batchSize = this.batchParams.size();
        this.params = new HashMap<Integer, ParameterContext>();
        this.batch = true;
    }

    public boolean isBatch() {
        return this.batch;
    }

    public void setBatchIndex(int batchIndex) {
        this.batchIndex = batchIndex;
    }

    public int getBatchIndex() {
        return this.batchIndex;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public AtomicInteger getSequenceSize() {
        return this.sequenceSize;
    }

    public void setSequenceSize(AtomicInteger sequenceSize) {
        this.sequenceSize = sequenceSize;
    }

    public static void setParameters(PreparedStatement ps, Map<Integer, ParameterContext> parameterSettings) throws SQLException {
        ParameterMethod.setParameters((Statement)ps, parameterSettings);
    }

    public void clear() {
        if (this.isBatch() && this.batchParams != null) {
            this.batchParams.clear();
            this.batch = false;
        } else {
            this.params.clear();
        }
    }

    public String toString() {
        if (!this.isBatch()) {
            if (this.params == null || this.params.isEmpty()) {
                return null;
            }
            return this.params.values().toString();
        }
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)TddlToStringStyle.DEFAULT_STYLE);
    }

    public AtomicInteger getSequenceIndex() {
        return this.sequenceIndex;
    }

    public void setSequenceIndex(AtomicInteger sequenceIndex) {
        this.sequenceIndex = sequenceIndex;
    }
}

