/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.struct;

import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.util.string.TStringUtil;
import com.taobao.txc.parser.struct.SqlType;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SqlTypeParser {
    private static final Pattern SELECT_FOR_UPDATE_PATTERN = Pattern.compile("^\\s*select\\s+.*\\s+for\\s+update.*$", 34);
    private static final Pattern SELECT_FROM_UPDATE_PATTERN = Pattern.compile("^\\s*select\\s+.*\\s+from\\s+update.*$", 34);
    private static final Pattern CALL_PATTERN = Pattern.compile("^\\{\\s*call.*$", 34);
    private static final Pattern UNION_PATTERN = Pattern.compile("^.*[\\)\\s]+union\\s.*$", 34);
    private static final Pattern INSERT_ON_DUPLICATE_UPDATE_PATTERN = Pattern.compile("^\\s*insert\\s+.*\\s+on\\s+duplicate\\s+key\\s+update\\s*.*$", 34);

    public static boolean isReadSql(String sql) {
        SqlType sqlType = SqlTypeParser.getSqlType(sql);
        return SqlTypeParser.isReadSqlType(sqlType);
    }

    public static boolean isReadSqlType(SqlType sqlType) {
        return sqlType == SqlType.SELECT || sqlType == SqlType.SHOW || sqlType == SqlType.TDDL_SHOW || sqlType == SqlType.DESC || sqlType == SqlType.DUMP || sqlType == SqlType.DEBUG || sqlType == SqlType.EXPLAIN || sqlType == SqlType.SELECT_LAST_INSERT_ID || sqlType == SqlType.SELECT_WITHOUT_TABLE || sqlType == SqlType.SELECT_UNION;
    }

    public static boolean isQuerySql(String sql) {
        SqlType sqlType = SqlTypeParser.getSqlType(sql);
        return SqlTypeParser.isQuerySqlType(sqlType);
    }

    public static boolean isQuerySqlType(SqlType sqlType) {
        return SqlTypeParser.isReadSqlType(sqlType) || sqlType == SqlType.SELECT_FOR_UPDATE || sqlType == SqlType.PROCEDURE || sqlType == SqlType.SELECT_FROM_UPDATE;
    }

    public static boolean isInsertSql(String sql) {
        String noCommentsSql = sql;
        if (sql.contains("/*")) {
            noCommentsSql = TStringUtil.stripComments(sql, "'\"", "'\"", true, false, true, true).trim();
        }
        if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "insert")) {
            return true;
        }
        return TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "replace");
    }

    public static SqlType getSqlType(String sql) {
        int trace = TStringUtil.traceIndex(sql);
        if (trace > 0) {
            sql = sql.substring(trace);
        }
        SqlType sqlType = null;
        String noCommentsSql = sql;
        if (sql.contains("/*")) {
            noCommentsSql = TStringUtil.stripComments(sql, "'\"", "'\"", true, false, true, true).trim();
        }
        if (StringUtils.isEmpty((String)noCommentsSql)) {
            sqlType = SqlType.SET;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "select")) {
            sqlType = TStringUtil.containsIgnoreCase((String)noCommentsSql, (String)"for") && SELECT_FOR_UPDATE_PATTERN.matcher(noCommentsSql.toLowerCase()).matches() ? SqlType.SELECT_FOR_UPDATE : (TStringUtil.containsIgnoreCase((String)noCommentsSql, (String)"update") && SELECT_FROM_UPDATE_PATTERN.matcher(noCommentsSql).matches() ? SqlType.SELECT_FROM_UPDATE : SqlType.SELECT);
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "insert")) {
            sqlType = TStringUtil.containsIgnoreCase((String)noCommentsSql, (String)"duplicate") && INSERT_ON_DUPLICATE_UPDATE_PATTERN.matcher(noCommentsSql.toLowerCase()).matches() ? SqlType.INSERT_ON_DUPLICATE_UPDATE : SqlType.INSERT;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "update")) {
            sqlType = SqlType.UPDATE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "delete")) {
            sqlType = SqlType.DELETE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "show")) {
            sqlType = SqlType.SHOW;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "replace")) {
            sqlType = SqlType.REPLACE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "truncate")) {
            sqlType = SqlType.TRUNCATE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "create")) {
            sqlType = SqlType.CREATE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "drop")) {
            sqlType = SqlType.DROP;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "load")) {
            sqlType = SqlType.LOAD;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "merge")) {
            sqlType = SqlType.MERGE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "alter")) {
            sqlType = SqlType.ALTER;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "rename")) {
            sqlType = SqlType.RENAME;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "dump")) {
            sqlType = SqlType.DUMP;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "debug")) {
            sqlType = SqlType.DEBUG;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "savepoint")) {
            sqlType = SqlType.SAVE_POINT;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "release")) {
            sqlType = SqlType.SAVE_POINT;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "rollback")) {
            sqlType = SqlType.SAVE_POINT;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "explain")) {
            sqlType = SqlType.EXPLAIN;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "desc")) {
            sqlType = SqlType.DESC;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "call") || CALL_PATTERN.matcher(noCommentsSql).matches()) {
            sqlType = SqlType.PROCEDURE;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "set")) {
            sqlType = SqlType.SET;
        } else if (UNION_PATTERN.matcher(noCommentsSql).matches()) {
            sqlType = SqlType.SELECT_UNION;
        } else if (TStringUtil.startsWithIgnoreCaseAndWs(noCommentsSql, "reload")) {
            sqlType = SqlType.RELOAD;
        } else {
            throw new TxcException("SqlType is Not Support ," + noCommentsSql);
        }
        return sqlType;
    }
}

