/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.struct;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcLine;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TxcRuntimeContext {
    private static final LoggerWrap logger = LoggerInit.logger;
    public long id = 0L;
    public String xid;
    public String writeKeys;
    public long branchId = 0L;
    @JSONField(serialize=false)
    private List<RollbackInfor> inforList = new ArrayList<RollbackInfor>();
    @JSONField(serialize=false)
    private List<RollbackInfoCost> inforCostList = new ArrayList<RollbackInfoCost>();
    public RollbackInfor[] info;
    public int status;
    public String server;
    @JSONField(serialize=false)
    private final long start;
    @JSONField(serialize=false)
    private long start0;
    @JSONField(serialize=false)
    private boolean noRecordLimitWarn = true;
    @JSONField(serialize=false)
    private int changedRecord = 0;
    @JSONField(serialize=false)
    private RollbackInfoCost rollbackInfoCost = new RollbackInfoCost();
    private boolean undoLogFlushed = false;

    public TxcRuntimeContext() {
        this.start = System.currentTimeMillis();
        this.start0 = System.currentTimeMillis();
    }

    public TxcRuntimeContext setFrontImageCost(long cost) {
        this.rollbackInfoCost.frontImage = cost;
        return this;
    }

    public TxcRuntimeContext setRearImageCost(long cost) {
        this.rollbackInfoCost.rearImage = cost;
        return this;
    }

    public TxcRuntimeContext setSqlCost(long cost) {
        this.rollbackInfoCost.self = cost;
        return this;
    }

    public String encode() {
        this.info = new RollbackInfor[this.inforList.size()];
        this.inforList.toArray(this.info);
        for (RollbackInfor rollbackInfor : this.info) {
            TxcTable t = rollbackInfor.frontImage;
            t.line = new TxcLine[t.getLinesList().size()];
            t.getLinesList().toArray(t.line);
            for (TxcLine line : t.line) {
                line.fields = new TxcField[line.getFieldsList().size()];
                line.getFieldsList().toArray(line.fields);
            }
            t = rollbackInfor.rearImage;
            t.line = new TxcLine[t.getLinesList().size()];
            t.getLinesList().toArray(t.line);
            for (TxcLine line : t.line) {
                line.fields = new TxcField[line.getFieldsList().size()];
                line.getFieldsList().toArray(line.fields);
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug(rollbackInfor.toString1());
        }
        return JSON.toJSONString((Object)this, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
    }

    public static TxcRuntimeContext decode(String jsonString) {
        TxcRuntimeContext c = (TxcRuntimeContext)JSON.parseObject((String)jsonString, TxcRuntimeContext.class);
        if (c.info != null && c.info.length > 0) {
            c.inforList.clear();
            for (RollbackInfor r : c.info) {
                TxcTable t = r.getFrontImage();
                if (t.line != null && t.line.length > 0) {
                    t.getLinesList().clear();
                    for (TxcLine line : t.line) {
                        if (line.fields != null && line.fields.length > 0) {
                            line.getFieldsList().clear();
                            for (TxcField field : line.fields) {
                                line.getFieldsList().add(field);
                            }
                        }
                        t.getLinesList().add(line);
                    }
                }
                t = r.getRearImage();
                if (t.line != null && t.line.length > 0) {
                    t.getLinesList().clear();
                    for (TxcLine line : t.line) {
                        if (line.fields != null && line.fields.length > 0) {
                            line.getFieldsList().clear();
                            for (TxcField field : line.fields) {
                                line.getFieldsList().add(field);
                            }
                        }
                        t.getLinesList().add(line);
                    }
                }
                c.inforList.add(r);
            }
        }
        return c;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getXid() {
        return this.xid;
    }

    public void setXid(String xid) {
        this.xid = xid;
    }

    public long getBranchId() {
        return this.branchId;
    }

    public void setBranchId(long branch_id) {
        this.branchId = branch_id;
    }

    public void setInforList(List<RollbackInfor> rollback_infor) {
        this.inforList = rollback_infor;
    }

    public List<RollbackInfor> getInforList() {
        return this.inforList;
    }

    public void addInfor(RollbackInfor undoLogInfor) {
        int recordLimitWarn = TxcConfigHolder.getInstance().getRecordLimitWarn();
        int recordLimitError = TxcConfigHolder.getInstance().getRecordLimitError();
        if (recordLimitWarn > 0 || recordLimitError > 0) {
            int num = 0;
            TxcTable table = undoLogInfor.getFrontImage();
            if (table != null) {
                num = table.linesNum();
            }
            if (num < 1 && (table = undoLogInfor.getRearImage()) != null) {
                num = table.linesNum();
            }
            this.changedRecord += num;
            if (recordLimitError > 0 && this.changedRecord > recordLimitError) {
                throw new TxcException(String.format("[%s] too many records(%d:%d) changed in the transaction", this.xid, this.changedRecord, recordLimitError), TxcErrCode.RecordLimitError);
            }
            if (recordLimitWarn > 0 && this.changedRecord > recordLimitWarn && this.noRecordLimitWarn) {
                this.noRecordLimitWarn = false;
                logger.warn(TxcErrCode.RecordLimitWarn.errCode, String.format("[%s] too many records(%d:%d) changed in the transaction", this.xid, this.changedRecord, recordLimitWarn));
            }
        }
        this.inforList.add(undoLogInfor);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getWriteKeys() {
        return this.writeKeys;
    }

    public void setWriteKeys(String writeKeys) {
        this.writeKeys = writeKeys;
    }

    public void appendWriteKeys(String writeKeys) {
        if (StringUtils.isEmpty((String)writeKeys)) {
            return;
        }
        this.writeKeys = StringUtils.isEmpty((String)this.writeKeys) ? writeKeys : String.format("%s;%s", this.writeKeys, writeKeys);
    }

    public long getRT() {
        return System.currentTimeMillis() - this.start;
    }

    public boolean isRegistBranch() {
        return this.branchId > 0L;
    }

    public boolean isUndoLogFlushed() {
        return this.undoLogFlushed;
    }

    public void setUndoLogFlushed(boolean undoLogFlushed) {
        this.undoLogFlushed = undoLogFlushed;
    }

    public long getRTFromLastPoint() {
        long fromLastPoint = System.currentTimeMillis() - this.start0;
        this.start0 = System.currentTimeMillis();
        return fromLastPoint;
    }

    public void addUndoLog(ITxcVisitor sqlVisitor) throws SQLException {
        TxcTable front = sqlVisitor.getFrontImage();
        TxcTable rear = sqlVisitor.getRearImage();
        if (front.linesNum() == 0 && rear.linesNum() == 0) {
            logger.info("front and rear image affect zero.");
            return;
        }
        RollbackInfor txcLog = new RollbackInfor();
        txcLog.setSql(sqlVisitor.getSQLExplain().getInputSql());
        txcLog.setSqlType(sqlVisitor.getSQLExplain().getSqlType());
        txcLog.setSelectSql(sqlVisitor.getSelectSql());
        txcLog.setFrontImage(front);
        txcLog.setRearImage(rear);
        txcLog.setRollbackRule(sqlVisitor.getRollbackRule());
        switch (sqlVisitor.getSQLExplain().getSqlType()) {
            case DELETE: {
                txcLog.setWhereCondition(sqlVisitor.getWhereCondition(front));
                break;
            }
            case UPDATE: {
                txcLog.setWhereCondition(sqlVisitor.getWhereCondition(front));
                break;
            }
            case INSERT: {
                txcLog.setWhereCondition(sqlVisitor.getWhereCondition(rear));
                break;
            }
            case INSERT_ON_DUPLICATE_UPDATE: {
                txcLog.setWhereCondition(sqlVisitor.getWhereCondition(rear));
                break;
            }
            default: {
                throw new SQLException("unsupported sqltype:" + sqlVisitor.getSQLExplain().getSqlType().value());
            }
        }
        txcLog.txcLogChecker();
        this.addInfor(txcLog);
        this.addInforCost();
    }

    private void addInforCost() {
        if (logger.isAnalyzeEnabled()) {
            this.rollbackInfoCost.sequence = AnalyzeLogger.getInstance().getNextSequence();
            this.inforCostList.add(this.rollbackInfoCost);
            this.rollbackInfoCost = new RollbackInfoCost();
        }
    }

    @JSONField(serialize=false)
    public String getInforCosts() {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (RollbackInfoCost cost : this.inforCostList) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(",");
            }
            sb.append(cost.sequence).append('/').append(cost.frontImage).append('/').append(cost.self).append('/').append(cost.rearImage);
        }
        return sb.toString();
    }

    private class RollbackInfoCost {
        public long sequence = 0L;
        public long frontImage = 0L;
        public long self = 0L;
        public long rearImage = 0L;

        private RollbackInfoCost() {
        }
    }
}

