/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.struct;

import com.alibaba.fastjson.annotation.JSONField;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcLine;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class TxcTable {
    private static final LoggerWrap logger = LoggerInit.logger;
    @JSONField(serialize=false)
    private TxcTableMeta tableMeta;
    public String schemaName;
    public String tableName;
    public String alias;
    @JSONField(serialize=false)
    private List<TxcLine> linesList = new ArrayList<TxcLine>();
    public TxcLine[] line;

    public TxcLine[] getLine() {
        return this.line;
    }

    public void setLine(TxcLine[] line) {
        this.line = line;
    }

    public void clear() {
        this.linesList.clear();
    }

    public int linesNum() {
        return this.linesList.size();
    }

    public List<TxcLine> getLinesList() {
        return this.linesList;
    }

    public void addLine(TxcLine line) {
        this.linesList.add(line);
    }

    public void addLine(ResultSet rs, ResultSetMetaData rsmd, int column) throws SQLException {
        ArrayList<TxcField> fields = new ArrayList<TxcField>(column);
        for (int i = 1; i <= column; ++i) {
            String colName = rsmd.getColumnName(i).toUpperCase();
            TxcColumnMeta col = this.tableMeta.getColumnMeta(colName);
            TxcField field = new TxcField();
            field.setName(col.getColumnName());
            field.setType(col.getDataType());
            switch (col.getDataType()) {
                case 91: {
                    try {
                        Date d = rs.getDate(i);
                        if ("YEAR".equalsIgnoreCase(col.getDataTypeName())) {
                            field.setType(4);
                            field.setValue(d == null ? null : Integer.valueOf(d.getYear() + 1900));
                            break;
                        }
                        field.setValue(d);
                        break;
                    }
                    catch (SQLException e) {
                        if (e.getMessage().indexOf("'0000-00-00' can not be represented as java.sql.Date") != -1) {
                            field.setValue(null);
                            break;
                        }
                        logger.error("Failed to handle DATE value", e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                case 93: {
                    try {
                        field.setValue(rs.getObject(i));
                        break;
                    }
                    catch (SQLException e) {
                        if (e.getMessage().indexOf("'0000-00-00 00:00:00' can not be represented as java.sql.Timestamp") != -1) {
                            field.setValue(null);
                            break;
                        }
                        logger.error("Failed to handle TIMESTAMP value", e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                case -7: 
                case -6: {
                    try {
                        if (rs.getObject(i) == null) {
                            field.setValue(null);
                            break;
                        }
                        field.setValue(rs.getInt(i));
                        break;
                    }
                    catch (SQLException e) {
                        logger.error("Failed to get BIT/TINYINT value", e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
                default: {
                    try {
                        field.setValue(rs.getObject(i));
                        break;
                    }
                    catch (SQLException e) {
                        logger.error("Failed to get DataType[" + col.getDataType() + "]", e.getMessage(), (Throwable)e);
                        throw e;
                    }
                }
            }
            fields.add(field);
        }
        TxcLine line = new TxcLine();
        line.setTableMeta(this.getTableMeta());
        line.setFields(fields);
        this.linesList.add(line);
    }

    public void addLines(ITxcConnection txcConn, String sql) throws SQLException {
        this.linesList.clear();
        Connection conn = txcConn.getTargetConnection();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = txcConn.getDsType() == TxcDbType.MYSQL ? conn.createStatement(1005, 1008) : conn.createStatement();
            rs = st.executeQuery(sql);
            ResultSetMetaData rsmd = rs.getMetaData();
            int column = rsmd.getColumnCount();
            if (txcConn.getDsType() == TxcDbType.MYSQL) {
                int recordLimitWarn = TxcConfigHolder.getInstance().getRecordLimitWarn();
                int recordLimitError = TxcConfigHolder.getInstance().getRecordLimitError();
                if (recordLimitWarn > 0 || recordLimitError > 0) {
                    rs.last();
                    int changedRecord = rs.getRow();
                    if (recordLimitError > 0 && changedRecord > recordLimitError) {
                        String xid = txcConn.getTxcRuntimeContext().getXid();
                        throw new TxcException(String.format("[%s] too many records(%d:%d) changed in the transaction", xid, changedRecord, recordLimitError), TxcErrCode.RecordLimitError);
                    }
                    if (recordLimitWarn > 0 && changedRecord > recordLimitWarn) {
                        String xid = txcConn.getTxcRuntimeContext().getXid();
                        logger.warn(TxcErrCode.RecordLimitWarn.errCode, String.format("[%s] too many records(%d:%d) changed in the transaction", xid, changedRecord, recordLimitWarn));
                    }
                    rs.beforeFirst();
                }
            }
            while (rs.next()) {
                this.addLine(rs, rsmd, column);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    public List<TxcField> pkRows() {
        final String pkName = this.getTableMeta().getPkName();
        return new ArrayList<TxcField>(){
            {
                block0: for (TxcLine line : TxcTable.this.linesList) {
                    List<TxcField> fields = line.getFieldsList();
                    for (TxcField field : fields) {
                        if (!field.getName().equalsIgnoreCase(pkName)) continue;
                        this.add(field);
                        continue block0;
                    }
                }
            }
        };
    }

    public TxcTableMeta getTableMeta() {
        return this.tableMeta;
    }

    public void setTableMeta(TxcTableMeta tableMeta) {
        this.tableMeta = tableMeta;
    }

    public String toString() {
        StringBuilder appender = new StringBuilder();
        for (int i = 0; i < this.linesList.size(); ++i) {
            List<TxcField> line = this.linesList.get(i).getFieldsList();
            for (TxcField obj : line) {
                switch (obj.getType()) {
                    case -15: 
                    case -9: 
                    case -6: 
                    case -5: 
                    case 1: 
                    case 2: 
                    case 4: 
                    case 12: 
                    case 2003: {
                        appender.append(obj.getValue()).append(',');
                    }
                }
            }
        }
        return appender.toString();
    }

    public String toString1() {
        StringBuilder sb = new StringBuilder();
        for (TxcLine l : this.line) {
            sb.append(l.toString()).append("\n");
        }
        return sb.toString();
    }

    public String toStringWithEndl() {
        StringBuilder appender = new StringBuilder();
        for (int i = 0; i < this.linesList.size(); ++i) {
            List<TxcField> line = this.linesList.get(i).getFieldsList();
            for (TxcField obj : line) {
                appender.append(obj.getValue()).append(":");
            }
            appender.append("\n");
        }
        return appender.toString();
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }
}

