/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.struct;

import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.struct.IndexType;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcIndexMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TxcTableMeta {
    private String schemaName;
    private String tableName;
    private String alias;
    private Map<String, TxcColumnMeta> allColumns = new HashMap<String, TxcColumnMeta>();
    private Map<String, TxcIndexMeta> allIndexes = new HashMap<String, TxcIndexMeta>();

    public TxcTableMeta() {
    }

    public TxcTableMeta(TxcTableMeta meta) {
        this.schemaName = meta.schemaName;
        this.tableName = meta.tableName;
        this.alias = meta.alias;
        this.allColumns = meta.allColumns;
        this.allIndexes = meta.allIndexes;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public TxcColumnMeta getColumnMeta(String colName) {
        String s = colName.toUpperCase();
        TxcColumnMeta col = this.allColumns.get(s);
        if (col == null) {
            col = colName.charAt(0) == '`' ? this.allColumns.get(s.substring(1, colName.length() - 1)) : this.allColumns.get("`" + s + "`");
        }
        return col;
    }

    public Map<String, TxcColumnMeta> getAllColumns() {
        return this.allColumns;
    }

    public Map<String, TxcIndexMeta> getAllIndexes() {
        return this.allIndexes;
    }

    public TxcColumnMeta getAutoIncreaseColumn() {
        for (Map.Entry<String, TxcColumnMeta> entry : this.allColumns.entrySet()) {
            TxcColumnMeta col = entry.getValue();
            if (!"YES".equalsIgnoreCase(col.getIsAutoincrement())) continue;
            return col;
        }
        return null;
    }

    public TxcColumnMeta getPrimaryKeyColumn() {
        Map<String, TxcColumnMeta> columnMetaMap = this.getPrimaryKeyMap();
        if (columnMetaMap.size() == 0) {
            return null;
        }
        return columnMetaMap.values().iterator().next();
    }

    public Map<String, TxcColumnMeta> getPrimaryKeyMap() {
        HashMap<String, TxcColumnMeta> pk = new HashMap<String, TxcColumnMeta>();
        for (Map.Entry<String, TxcIndexMeta> entry : this.allIndexes.entrySet()) {
            TxcIndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.PRIMARY.value()) continue;
            for (TxcColumnMeta col : index.getValues()) {
                pk.put(col.getColumnName().toUpperCase(), col);
            }
        }
        if (pk.size() > 1) {
            throw new TxcException("multi pks not support yet.");
        }
        return pk;
    }

    public Map<String, TxcColumnMeta> getUnionKeyMap() {
        HashMap<String, TxcColumnMeta> pk = new HashMap<String, TxcColumnMeta>();
        for (Map.Entry<String, TxcIndexMeta> entry : this.allIndexes.entrySet()) {
            TxcIndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.Unique.value()) continue;
            for (TxcColumnMeta col : index.getValues()) {
                pk.put(col.getColumnName().toUpperCase(), col);
            }
        }
        return pk;
    }

    public Map<String, Map<String, TxcColumnMeta>> getUnionKeyGroupMap() {
        HashMap<String, Map<String, TxcColumnMeta>> groupMap = new HashMap<String, Map<String, TxcColumnMeta>>();
        for (Map.Entry<String, TxcIndexMeta> entry : this.allIndexes.entrySet()) {
            TxcIndexMeta index = entry.getValue();
            if (index.getIndextype().value() != IndexType.Unique.value()) continue;
            HashMap<String, TxcColumnMeta> uk = new HashMap<String, TxcColumnMeta>();
            for (TxcColumnMeta col : index.getValues()) {
                uk.put(col.getColumnName().toUpperCase(), col);
            }
            groupMap.put(entry.getKey(), uk);
        }
        return groupMap;
    }

    public List<String> getPrimaryKeyOnlyName() {
        return new ArrayList<String>(){
            {
                for (Map.Entry<String, TxcColumnMeta> entry : TxcTableMeta.this.getPrimaryKeyMap().entrySet()) {
                    this.add(entry.getKey());
                }
            }
        };
    }

    public String getPkName() {
        return this.getPrimaryKeyOnlyName().get(0);
    }

    public boolean isContainsPriKey(List<String> cols) {
        if (cols == null) {
            return false;
        }
        List<String> pk = this.getPrimaryKeyOnlyName();
        if (pk.isEmpty()) {
            return false;
        }
        return cols.containsAll(pk);
    }

    public boolean isContainsUnionKey(List<String> cols) {
        if (cols == null || cols.isEmpty()) {
            return false;
        }
        Map<String, TxcColumnMeta> unionKeyMap = this.getUnionKeyMap();
        if (unionKeyMap.size() == 0) {
            return false;
        }
        for (String unionKey : unionKeyMap.keySet()) {
            for (String col : cols) {
                if (!col.equalsIgnoreCase(unionKey)) continue;
                return true;
            }
        }
        return false;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getCreateTableSQL() {
        StringBuilder sb = new StringBuilder("CREATE TABLE");
        sb.append(String.format(" `%s` ", this.getTableName()));
        sb.append("(");
        boolean flag = true;
        Map<String, TxcColumnMeta> allColumns = this.getAllColumns();
        for (Map.Entry<String, TxcColumnMeta> entry : allColumns.entrySet()) {
            if (flag) {
                flag = false;
            } else {
                sb.append(",");
            }
            TxcColumnMeta col = entry.getValue();
            sb.append(String.format(" `%s` ", col.getColumnName()));
            sb.append(col.getDataTypeName());
            if (col.getColumnSize() > 0) {
                sb.append(String.format("(%d)", col.getColumnSize()));
            }
            if (col.getColumnDef() != null && col.getColumnDef().length() > 0) {
                sb.append(String.format(" default '%s'", col.getColumnDef()));
            }
            if (col.getIsNullAble() == null || col.getIsNullAble().length() <= 0) continue;
            sb.append(" ");
            sb.append(col.getIsNullAble());
        }
        Map<String, TxcIndexMeta> allIndexes = this.getAllIndexes();
        for (Map.Entry<String, TxcIndexMeta> entry : allIndexes.entrySet()) {
            sb.append(", ");
            TxcIndexMeta index = entry.getValue();
            switch (index.getIndextype()) {
                case FullText: {
                    break;
                }
                case Normal: {
                    sb.append(String.format("KEY `%s`", index.getIndexName()));
                    break;
                }
                case PRIMARY: {
                    sb.append(String.format("PRIMARY KEY", new Object[0]));
                    break;
                }
                case Unique: {
                    sb.append(String.format("UNIQUE KEY `%s`", index.getIndexName()));
                    break;
                }
            }
            sb.append(" (");
            boolean f = true;
            for (TxcColumnMeta c : index.getValues()) {
                if (f) {
                    f = false;
                } else {
                    sb.append(",");
                }
                sb.append(String.format("`%s`", c.getColumnName()));
            }
            sb.append(")");
        }
        sb.append(")");
        return sb.toString();
    }
}

