/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor;

import com.alibaba.txc.parser.recognizer.mysql.syntax.MySQLOutputASTVisitor;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.algorithm.IntKeyScopeMerge;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcLine;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.parser.visitor.cache.TxcMetaCache;
import com.taobao.txc.parser.visitor.cobar.TxcObjectWapper;
import com.taobao.txc.resourcemanager.RmRpcClient;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.IDbTypeAware;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcPrepareStatement;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public abstract class BaseVisitor
extends MySQLOutputASTVisitor
implements ITxcVisitor,
IDbTypeAware {
    private static final LoggerWrap logger = LoggerInit.logger;
    private String rollbackRule = null;
    private TxcTable frontImage = new TxcTable();
    private TxcTable rearImage = new TxcTable();
    private ITxcStatement txcStatement = null;
    private static int MIN_RECORDS_TO_MERGE = 1000;
    private TxcDbType dbType;

    @Override
    public TxcDbType getDbType() {
        return this.dbType;
    }

    @Override
    public void setDbType(TxcDbType dbType) {
        this.dbType = dbType;
    }

    public ITxcStatement getTxcStatement() {
        return this.txcStatement;
    }

    @Override
    public void setTxcStatement(ITxcStatement txcStatement) {
        this.txcStatement = txcStatement;
    }

    @Override
    public Object getParameterValue(int paraIndex, int valueIndex) throws SQLException {
        ITxcStatement iTxcStatement = this.getTxcStatement();
        if (iTxcStatement instanceof ITxcPrepareStatement) {
            return ((ITxcPrepareStatement)iTxcStatement).getParameterValue(paraIndex, valueIndex);
        }
        throw new SQLException("param invalid paraIndex:" + paraIndex + " valueIndex:" + valueIndex);
    }

    @Override
    public int getParaRow() throws SQLException {
        ITxcStatement iTxcStatement = this.getTxcStatement();
        if (iTxcStatement instanceof ITxcPrepareStatement) {
            return ((ITxcPrepareStatement)this.getTxcStatement()).getParaRow();
        }
        return 0;
    }

    @Override
    public int getParaCount() throws SQLException {
        ITxcStatement iTxcStatement = this.getTxcStatement();
        if (iTxcStatement instanceof ITxcPrepareStatement) {
            return ((ITxcPrepareStatement)this.getTxcStatement()).getParaCount();
        }
        return 0;
    }

    public BaseVisitor() {
        super(new StringBuilder());
    }

    private TxcTable execute(ITxcStatement st, String sql) throws SQLException {
        TxcTable table = this.newTxcTable();
        table.addLines(st.getTxcConnection(), sql);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxcTable executeFront(ITxcStatement st, String sql) throws SQLException {
        TxcTable txcTable;
        if (logger.isDebugEnabled()) {
            logger.debug("will get front image, sql:" + sql);
        }
        try {
            txcTable = this.execute(st, sql);
        }
        catch (Throwable throwable) {
            logger.info(String.format("[get front image] [%d] [%s] [%s]", TxcContext.getTransactionId(), sql, st.getRtFromStart()));
            throw throwable;
        }
        logger.info(String.format("[get front image] [%d] [%s] [%s]", TxcContext.getTransactionId(), sql, st.getRtFromStart()));
        return txcTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxcTable executeRear(ITxcStatement st, String sql) throws SQLException {
        TxcTable txcTable;
        if (logger.isDebugEnabled()) {
            logger.debug("will get rear image");
        }
        try {
            txcTable = this.execute(st, sql);
        }
        catch (Throwable throwable) {
            logger.info(String.format("[get rear image] [%d] [%s] [%s]", TxcContext.getTransactionId(), sql, st.getRtFromStart()));
            throw throwable;
        }
        logger.info(String.format("[get rear image] [%d] [%s] [%s]", TxcContext.getTransactionId(), sql, st.getRtFromStart()));
        return txcTable;
    }

    @Override
    public void setFrontImage(TxcTable table) throws SQLException {
        this.frontImage = table;
    }

    @Override
    public void setRearImage(TxcTable table) throws SQLException {
        this.rearImage = table;
    }

    @Override
    public TxcTable getFrontImage() {
        return this.frontImage;
    }

    @Override
    public TxcTable getRearImage() {
        return this.rearImage;
    }

    @Override
    public String getRollbackRule() {
        return this.rollbackRule;
    }

    public void setRollbackRule(String rollbackRule) {
        this.rollbackRule = rollbackRule;
    }

    @Override
    public String getWhereCondition(TxcTable table) throws SQLException {
        int i;
        int type;
        Iterator<String> it;
        StringBuilder appender = new StringBuilder();
        Map<String, TxcColumnMeta> tableKeys = this.getTableMeta().getPrimaryKeyMap();
        if (tableKeys.size() <= 0) {
            throw new SQLException("table[" + this.getTableMeta().getTableName() + "] should has prikey, contact DBA please.");
        }
        List<TxcLine> lines = table.getLinesList();
        if (lines.size() > 0) {
            appender.append(" WHERE ");
        }
        boolean canMergeId = false;
        String pkName = null;
        TxcColumnMeta pk = null;
        if (lines.size() > MIN_RECORDS_TO_MERGE && (it = tableKeys.keySet().iterator()).hasNext() && !StringUtils.isEmpty((String)(pkName = it.next())) && ((type = (pk = tableKeys.get(pkName)).getDataType()) == 5 || type == -5 || type == 4 || type == -6)) {
            canMergeId = true;
        }
        if (canMergeId) {
            IntKeyScopeMerge intKeyScopeMerge = new IntKeyScopeMerge(pkName.toUpperCase());
            for (i = 0; i < lines.size(); ++i) {
                TxcLine line = lines.get(i);
                List<TxcField> fields = line.getFieldsList();
                if (fields == null) continue;
                this.appendKeyScope(pkName, pk, fields, intKeyScopeMerge);
            }
            appender.append(intKeyScopeMerge.toString());
        } else {
            boolean bOrFlag = true;
            for (i = 0; i < lines.size(); ++i) {
                TxcLine line = lines.get(i);
                List<TxcField> fields = line.getFieldsList();
                if (fields == null) continue;
                if (bOrFlag) {
                    bOrFlag = false;
                } else {
                    appender.append(" OR ");
                }
                this.printKeyList(tableKeys, fields, appender);
            }
        }
        return appender.toString();
    }

    private void appendKeyScope(String pkName, TxcColumnMeta pk, List<TxcField> fields, IntKeyScopeMerge intKeyScopeMerge) throws SQLException {
        for (int i = 0; i < fields.size(); ++i) {
            TxcField field = fields.get(i);
            if (!pkName.equalsIgnoreCase(field.getName())) continue;
            int type = pk.getDataType();
            if ((type == 5 || type == 4 || type == -6 || type == -5) && field.getValue() != null && field.getValue() instanceof Number) {
                intKeyScopeMerge.insert(((Number)field.getValue()).longValue());
                break;
            }
            throw new TxcException(String.format("failed to merge pk type=%d, field.name=%s, field.value.type=%s, field.value=%s", type, field.getName().toUpperCase(), field.getValue().getClass().toString(), field.getValue()));
        }
    }

    public TxcTableMeta getTableMeta() throws SQLException {
        TxcTableMeta meta = TxcMetaCache.getTableMeta(this, this.getTxcStatement().getTxcConnection());
        return meta;
    }

    @Override
    public String getSelectSql() throws SQLException {
        return this.getSelectSql(false);
    }

    @Override
    public String getSelectSql(boolean onlyKeys) throws SQLException {
        StringBuilder selectSqlAppender = this.getNullSqlAppenderBuilder();
        selectSqlAppender.append("SELECT ");
        selectSqlAppender.append(this.printColumns(onlyKeys));
        selectSqlAppender.append(" FROM ");
        String tableName = this.getSQLExplain().getTableName();
        if (RmRpcClient.tableKeywords != null && RmRpcClient.tableKeywords.contains(tableName.toUpperCase())) {
            selectSqlAppender.append("`").append(tableName).append("`");
        } else {
            selectSqlAppender.append(tableName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("selectSqlAppender:" + selectSqlAppender.toString());
        }
        return selectSqlAppender.toString();
    }

    protected String printColumns(boolean onlyKeys) throws SQLException {
        StringBuilder appender = new StringBuilder();
        Collection<TxcColumnMeta> list = onlyKeys ? this.getTableMeta().getPrimaryKeyMap().values() : this.getTableMeta().getAllColumns().values();
        boolean isFst = true;
        for (TxcColumnMeta obj : list) {
            if (isFst) {
                isFst = false;
            } else if (obj instanceof TxcColumnMeta) {
                appender.append(",");
            }
            appender.append(this.getSQLExplain().getTableName());
            appender.append(".");
            appender.append(obj.getColumnName());
        }
        return appender.toString();
    }

    protected StringBuilder getNullSqlAppenderBuilder() {
        StringBuilder appender = this.appendable;
        appender.delete(0, appender.length());
        return appender;
    }

    protected TxcTable newTxcTable() throws SQLException {
        TxcTableMeta meta = this.getTableMeta();
        TxcTable table = new TxcTable();
        table.setTableMeta(meta);
        table.setTableName(meta.getTableName());
        table.setAlias(meta.getAlias());
        table.setSchemaName(meta.getSchemaName());
        return table;
    }

    private void printKeyList(Map<String, TxcColumnMeta> tableKeys, List<TxcField> fields, StringBuilder appender) throws SQLException {
        boolean bAndFlag = true;
        for (int i = 0; i < fields.size(); ++i) {
            TxcField field = fields.get(i);
            if (!tableKeys.containsKey(field.getName().toUpperCase())) continue;
            if (bAndFlag) {
                bAndFlag = false;
            } else {
                appender.append(" AND ");
            }
            appender.append(field.getName());
            appender.append("=");
            TxcObjectWapper.appendParamMarkerObject(field.getValue(), appender);
        }
    }
}

