/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.parser.struct.SqlTypeParser;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.parser.visitor.cobar.CobarBaseVisitor;
import com.taobao.txc.parser.visitor.cobar.DefaultVisitor;
import com.taobao.txc.parser.visitor.cobar.DeleteVisitor;
import com.taobao.txc.parser.visitor.cobar.InsertDupKeyVisitor;
import com.taobao.txc.parser.visitor.cobar.InsertVisitor;
import com.taobao.txc.parser.visitor.cobar.SelectVisitor;
import com.taobao.txc.parser.visitor.cobar.TxcAstNode;
import com.taobao.txc.parser.visitor.cobar.UpdateVisitor;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.IDbTypeAware;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class TxcVisitorFactory {
    private static final LoggerWrap logger = LoggerInit.logger;

    public static boolean isQuerySql(String sql) {
        return SqlTypeParser.isQuerySql(sql);
    }

    public static boolean isTddlParser() {
        return false;
    }

    public static ITxcVisitor getSqlVisitor(TxcDbType dbType, String sql) throws SQLException {
        ITxcVisitor v = null;
        if (TxcVisitorFactory.isTddlParser()) {
            try {
                Class<?> cls = Class.forName("com.taobao.txc.parser.visitor.tddl.TxcVisitorHelper");
                Method m = cls.getDeclaredMethod("getTddlParserVisitor", String.class);
                v = (ITxcVisitor)m.invoke(cls, sql);
            }
            catch (Exception e) {
                logger.error("", e.getMessage(), (Throwable)e);
            }
        }
        if (v == null) {
            TxcAstNode node = new TxcAstNode(sql);
            v = TxcVisitorFactory.getCobarParserVisitor(node);
        }
        if (dbType != null && v != null && v instanceof IDbTypeAware) {
            ((IDbTypeAware)((Object)v)).setDbType(dbType);
        }
        return v;
    }

    public static ITxcVisitor getSqlVisitor(String sql) throws SQLException {
        return TxcVisitorFactory.getSqlVisitor(null, sql);
    }

    private static ITxcVisitor getCobarParserVisitor(TxcAstNode node) throws SQLException {
        CobarBaseVisitor visit = null;
        switch (node.getSqlType()) {
            case SELECT: {
                visit = StringUtils.isNotEmpty((String)TxcContext.getTxcHint()) ? new SelectVisitor(node) : new DefaultVisitor(node);
            }
            case SELECT_FOR_UPDATE: {
                visit = new SelectVisitor(node);
                break;
            }
            case DELETE: {
                visit = new DeleteVisitor(node);
                break;
            }
            case INSERT: {
                visit = new InsertVisitor(node);
                break;
            }
            case INSERT_ON_DUPLICATE_UPDATE: {
                visit = new InsertDupKeyVisitor(node);
                break;
            }
            case UPDATE: {
                visit = new UpdateVisitor(node);
                break;
            }
            default: {
                visit = new DefaultVisitor(node);
            }
        }
        return visit;
    }
}

