/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.struct.IndexType;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcIndexMeta;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.RmRpcClient;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.rpc.impl.RpcClient;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TxcMetaCache {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static long cacheSize = 100000L;
    private static long expireTime = 900000L;
    private static final Cache<String, TxcTableMeta> tableMetaCache = CacheBuilder.newBuilder().maximumSize(cacheSize).expireAfterWrite(expireTime, TimeUnit.MILLISECONDS).softValues().build();

    public static TxcTableMeta getTableMeta(ITxcVisitor v, ITxcConnection conn) throws SQLException {
        TxcTableMeta tableMeta = null;
        String tablename = v.getSQLExplain().getTableName();
        String tablenameAlias = v.getSQLExplain().getTableNameAlias();
        tableMeta = TxcMetaCache.getTableMeta(conn, tablename);
        tableMeta.setAlias(tablenameAlias);
        return tableMeta;
    }

    public static TxcTableMeta getTableMeta(final ITxcConnection conn, final String tableName) {
        if (StringUtils.isEmpty((String)tableName)) {
            throw new TxcException("TableMeta cannot fetched without tableName");
        }
        if (conn == null) {
            throw new TxcException("TableMeta cannot fetched without Connection");
        }
        String schemaName = null;
        if (conn instanceof ITxcConnection) {
            try {
                schemaName = conn.getTxcDataSource().getSchemaName();
            }
            catch (Exception ingore) {
                schemaName = null;
            }
        }
        if (StringUtils.isEmpty(schemaName) || "null".compareToIgnoreCase(schemaName) == 0) {
            try {
                schemaName = conn.getMetaData().getURL();
            }
            catch (Exception ingore) {
                // empty catch block
            }
        }
        if (StringUtils.isEmpty((String)schemaName)) {
            schemaName = "NULL";
        }
        boolean fromCache = false;
        TxcTableMeta tmeta = null;
        String cacheKey = schemaName + "." + tableName;
        List<Pattern> patternList = TxcConfigHolder.getInstance().getTablePatterns(RpcClient.getVgroup());
        if (patternList != null) {
            for (Pattern p : patternList) {
                if (!p.matcher(tableName).matches() && !p.matcher(tableName.toLowerCase()).matches()) continue;
                cacheKey = p.pattern();
                fromCache = true;
                break;
            }
        }
        final String key = cacheKey;
        try {
            tmeta = (TxcTableMeta)tableMetaCache.get((Object)key, (Callable)new Callable<TxcTableMeta>(){

                @Override
                public TxcTableMeta call() throws Exception {
                    logger.info("fetch schema of " + tableName + ",key:" + key);
                    return TxcMetaCache.fetchSchema(conn, tableName);
                }
            });
        }
        catch (ExecutionException e) {
            logger.warn(TxcErrCode.SqlCache.errCode, "tableMeta cache error since: " + e.getMessage());
        }
        if (tmeta == null) {
            try {
                logger.info("meta is null, fetch schema of " + tableName);
                tmeta = TxcMetaCache.fetchSchema(conn, tableName);
            }
            catch (SQLException e) {
                logger.warn(TxcErrCode.DBTableMetaFetchError.errCode, "tableMeta error since: " + e.getMessage());
            }
        }
        if (tmeta == null) {
            throw new TxcException(String.format("[xid:%s]get tablemeta failed", TxcContext.getCurrentXid()));
        }
        if (fromCache) {
            TxcTableMeta cmeta = new TxcTableMeta(tmeta);
            cmeta.setTableName(tableName);
            cmeta.setSchemaName(schemaName);
            return cmeta;
        }
        return tmeta;
    }

    private static TxcTableMeta fetchSchema(ITxcConnection conn, String tableName) throws SQLException {
        if (TxcDbType.ORACLE == conn.getDsType()) {
            return TxcMetaCache.fetchSchemeInORACLEWay(conn, tableName);
        }
        return TxcMetaCache.fetchSchemeInDefaultWay(conn, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TxcTableMeta fetchSchemeInORACLEWay(ITxcConnection conn, String tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.getTargetConnection().createStatement();
            if (tableName != null && tableName.contains(".")) {
                tableName = tableName.substring(tableName.lastIndexOf(".") + 1);
            }
            String sql = "select COLUMN_NAME,DATA_TYPE,DATA_LENGTH,DATA_SCALE from user_tab_cols where table_name='" + tableName + "'";
            rs = stmt.executeQuery(sql);
            TxcTableMeta txcTableMeta = TxcMetaCache.resultSetMetaToSchema(rs, conn, tableName);
            return txcTableMeta;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TxcTableMeta fetchSchemeInDefaultWay(ITxcConnection conn, String tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = conn.getTargetConnection().createStatement();
            StringBuffer sb = new StringBuffer("select * from ");
            if (RmRpcClient.tableKeywords != null && RmRpcClient.tableKeywords.contains(tableName.toUpperCase())) {
                sb.append("`").append(tableName).append("`");
            } else {
                sb.append(tableName);
            }
            sb.append(" limit 1");
            rs = stmt.executeQuery(sb.toString());
            ResultSetMetaData rsmd = rs.getMetaData();
            DatabaseMetaData dbmd = conn.getTargetConnection().getMetaData();
            TxcTableMeta txcTableMeta = TxcMetaCache.resultSetMetaToSchema(rsmd, dbmd);
            return txcTableMeta;
        }
        catch (Exception e) {
            logger.warn("Failed to fetch schema of " + tableName + " in default way. " + e.getMessage());
            if (!(e instanceof SQLException)) throw new SQLException("Failed to fetch schema of " + tableName, e);
            if (!"42000".equals(((SQLException)e).getSQLState())) throw (SQLException)e;
            try {
                TxcTableMeta rsmd = TxcMetaCache.fetchSchemeInORACLEWay(conn, tableName);
                return rsmd;
            }
            catch (SQLException sqle) {
                logger.warn("Also failed to fetch schema of " + tableName + " in ORACLE way. " + sqle.getMessage());
                throw (SQLException)e;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static TxcTableMeta resultSetMetaToSchema(ResultSet rs2, ITxcConnection conn, String tablename) throws SQLException {
        String tableName = tablename;
        TxcTableMeta tm = new TxcTableMeta();
        tm.setTableName(tableName);
        while (rs2.next()) {
            String colName = rs2.getString("COLUMN_NAME").trim().toUpperCase();
            if (logger.isDebugEnabled()) {
                logger.debug("parser col:" + colName);
            }
            if (colName.startsWith("SYS_") && colName.contains("$")) continue;
            TxcColumnMeta col = new TxcColumnMeta();
            col.setTableName(tableName);
            col.setColumnName(colName);
            String datatype = rs2.getString("DATA_TYPE");
            if (StringUtils.equalsIgnoreCase((String)datatype, (String)"NUMBER")) {
                int scale = rs2.getInt("DATA_SCALE");
                if (scale > 0) {
                    col.setDataType(2);
                } else {
                    col.setDataType(-5);
                }
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"VARCHAR2")) {
                col.setDataType(12);
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"CHAR")) {
                col.setDataType(1);
            } else if (StringUtils.equalsIgnoreCase((String)datatype, (String)"DATE")) {
                col.setDataType(91);
            } else if (datatype.startsWith("TIMESTAMP")) {
                col.setDataType(93);
            }
            col.setColumnSize(rs2.getInt("DATA_LENGTH"));
            if (logger.isDebugEnabled()) {
                logger.debug("save col:" + colName);
            }
            tm.getAllColumns().put(col.getColumnName(), col);
        }
        Statement stmt = null;
        ResultSet rs1 = null;
        try {
            stmt = conn.getTargetConnection().createStatement();
            rs1 = stmt.executeQuery("select a.constraint_name,  a.column_name from user_cons_columns a, user_constraints b  where a.constraint_name = b.constraint_name and b.constraint_type = 'P' and a.table_name ='" + tableName + "'");
            while (rs1.next()) {
                TxcIndexMeta index;
                String indexName = rs1.getString(1);
                String colName = rs1.getString(2).toUpperCase();
                TxcColumnMeta col = tm.getAllColumns().get(colName);
                if (tm.getAllIndexes().containsKey(indexName)) {
                    index = tm.getAllIndexes().get(indexName);
                    index.getValues().add(col);
                    continue;
                }
                index = new TxcIndexMeta();
                index.setIndexName(indexName);
                index.getValues().add(col);
                index.setIndextype(IndexType.PRIMARY);
                tm.getAllIndexes().put(indexName, index);
            }
        }
        finally {
            if (rs1 != null) {
                rs1.close();
            }
            if (stmt != null) {
                stmt.close();
            }
        }
        return tm;
    }

    private static TxcTableMeta resultSetMetaToSchema(ResultSetMetaData rsmd, DatabaseMetaData dbmd) throws SQLException {
        String tableName = rsmd.getTableName(1);
        String schemaName = rsmd.getSchemaName(1);
        String catalogName = rsmd.getCatalogName(1);
        if (RmRpcClient.tableKeywords != null && RmRpcClient.tableKeywords.contains(tableName.toUpperCase())) {
            tableName = "`" + tableName + "`";
        }
        TxcTableMeta tm = new TxcTableMeta();
        tm.setTableName(tableName);
        if (schemaName == null || schemaName.isEmpty()) {
            tm.setSchemaName(catalogName);
        } else {
            tm.setSchemaName(schemaName);
        }
        ResultSet rs1 = dbmd.getColumns(catalogName, schemaName, tableName, "%");
        while (rs1.next()) {
            TxcColumnMeta col = new TxcColumnMeta();
            col.setTableCat(rs1.getString("TABLE_CAT"));
            col.setTableSchemaName(rs1.getString("TABLE_SCHEM"));
            col.setTableName(rs1.getString("TABLE_NAME"));
            col.setColumnName(rs1.getString("COLUMN_NAME").toUpperCase());
            col.setDataType(rs1.getInt("DATA_TYPE"));
            col.setDataTypeName(rs1.getString("TYPE_NAME"));
            col.setColumnSize(rs1.getInt("COLUMN_SIZE"));
            col.setDecimalDigits(rs1.getInt("DECIMAL_DIGITS"));
            col.setNumPrecRadix(rs1.getInt("NUM_PREC_RADIX"));
            col.setNullAble(rs1.getInt("NULLABLE"));
            col.setRemarks(rs1.getString("REMARKS"));
            col.setColumnDef(rs1.getString("COLUMN_DEF"));
            col.setSqlDataType(rs1.getInt("SQL_DATA_TYPE"));
            col.setSqlDatetimeSub(rs1.getInt("SQL_DATETIME_SUB"));
            col.setCharOctetLength(rs1.getInt("CHAR_OCTET_LENGTH"));
            col.setOrdinalPosition(rs1.getInt("ORDINAL_POSITION"));
            col.setIsNullAble(rs1.getString("IS_NULLABLE"));
            col.setIsAutoincrement(rs1.getString("IS_AUTOINCREMENT"));
            tm.getAllColumns().put(col.getColumnName(), col);
        }
        ResultSet rs2 = dbmd.getIndexInfo(catalogName, schemaName, tableName, false, true);
        String indexName = "";
        while (rs2.next()) {
            TxcIndexMeta index;
            indexName = rs2.getString("INDEX_NAME");
            String colName = rs2.getString("COLUMN_NAME").toUpperCase();
            TxcColumnMeta col = tm.getAllColumns().get(colName);
            if (tm.getAllIndexes().containsKey(indexName)) {
                index = tm.getAllIndexes().get(indexName);
                index.getValues().add(col);
                continue;
            }
            index = new TxcIndexMeta();
            index.setIndexName(indexName);
            index.setNonUnique(rs2.getBoolean("NON_UNIQUE"));
            index.setIndexQualifier(rs2.getString("INDEX_QUALIFIER"));
            index.setIndexName(rs2.getString("INDEX_NAME"));
            index.setType(rs2.getShort("TYPE"));
            index.setOrdinalPosition(rs2.getShort("ORDINAL_POSITION"));
            index.setAscOrDesc(rs2.getString("ASC_OR_DESC"));
            index.setCardinality(rs2.getLong("CARDINALITY"));
            index.getValues().add(col);
            if ("PRIMARY".equalsIgnoreCase(indexName) || indexName.equalsIgnoreCase(rsmd.getTableName(1) + "_pkey")) {
                index.setIndextype(IndexType.PRIMARY);
            } else if (!index.isNonUnique()) {
                index.setIndextype(IndexType.Unique);
            } else {
                index.setIndextype(IndexType.Normal);
            }
            tm.getAllIndexes().put(indexName, index);
        }
        TxcIndexMeta index = tm.getAllIndexes().get(indexName);
        if (index.getIndextype().value() != 0) {
            if ("H2 JDBC Driver".equals(dbmd.getDriverName())) {
                if (indexName.length() > 11 && "PRIMARY_KEY".equalsIgnoreCase(indexName.substring(0, 11))) {
                    index.setIndextype(IndexType.PRIMARY);
                }
            } else if (dbmd.getDriverName() != null && dbmd.getDriverName().toLowerCase().indexOf("postgresql") >= 0 && (tableName + "_pkey").equalsIgnoreCase(indexName)) {
                index.setIndextype(IndexType.PRIMARY);
            }
        }
        return tm;
    }
}

