/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cobar;

import com.alibaba.txc.parser.ast.ASTNode;
import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNull;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertStatement;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcInsertDupKeyVisitor;
import com.taobao.txc.parser.visitor.cobar.InsertVisitor;
import com.taobao.txc.parser.visitor.cobar.NullValue;
import com.taobao.txc.parser.visitor.cobar.TxcAstNode;
import com.taobao.txc.parser.visitor.cobar.TxcObjectWapper;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class InsertDupKeyVisitor
extends InsertVisitor
implements ITxcInsertDupKeyVisitor {
    public InsertDupKeyVisitor(TxcAstNode stmt) {
        super(stmt);
    }

    @Override
    public String getWhereCondition(ITxcStatement st) throws SQLException {
        DMLInsertStatement node = this.thisVisitor();
        List<RowExpression> rows = node.getRowList();
        final List<Identifier> cols = node.getColumnNameList();
        if (cols == null) {
            throw new SQLException("INSERT SQL [" + node + "] without column names is not supported!");
        }
        if (rows == null || rows.isEmpty()) {
            throw new IllegalArgumentException("at least one row for INSERT");
        }
        String whereContition = null;
        ArrayList<String> relatedCols = new ArrayList<String>(){
            {
                for (Identifier col : cols) {
                    this.add(col.getIdTextUpUnescape());
                }
            }
        };
        if (this.getTableMeta().isContainsPriKey((List<String>)relatedCols)) {
            whereContition = this.selectByPK(rows, cols, st);
        } else if (this.getTableMeta().isContainsUnionKey((List<String>)relatedCols)) {
            whereContition = this.selectByUK(rows, cols, st);
        } else {
            throw new SQLException("INSERT ON DUPLICATE KEY is not supported without offering primary/union key");
        }
        return String.format(" WHERE %s", whereContition);
    }

    protected String selectByUK(List<RowExpression> rows, List<Identifier> cols, ITxcStatement st) throws SQLException {
        StringBuilder appender = this.getNullSqlAppenderBuilder();
        int lineNum = this.getParaRow();
        boolean bOrFlag = true;
        String theOnlyUK = null;
        if (lineNum == 0) {
            for (RowExpression row : rows) {
                if (row == null || row.getRowExprList().isEmpty()) continue;
                List<Expression> args = row.getRowExprList();
                for (int i = 0; i < args.size(); ++i) {
                    String attrName = cols.get(i).getIdTextUpUnescape();
                    TxcTableMeta tableMeta = this.getTableMeta();
                    Map<String, TxcColumnMeta> index = tableMeta.getUnionKeyMap();
                    TxcColumnMeta colMeta = tableMeta.getColumnMeta(attrName);
                    if (colMeta == null) {
                        colMeta = tableMeta.getAllColumns().get(attrName.toLowerCase());
                    }
                    if (!colMeta.isCommonType()) continue;
                    String tableName = tableMeta.getTableName();
                    String colName = colMeta.getColumnName().toUpperCase();
                    if (index.get(colName) == null) continue;
                    if (theOnlyUK != null && !colName.equalsIgnoreCase(theOnlyUK)) {
                        throw new SQLException("Multi UKs in INSERT ON DUPLICATE KEY UPDATE is NOT support! [" + colName + " AND " + theOnlyUK + "]");
                    }
                    theOnlyUK = colName;
                    Object value = null;
                    ASTNode arg = args.get(i);
                    if (arg instanceof LiteralNumber) {
                        LiteralNumber pNumber = (LiteralNumber)arg;
                        value = pNumber.getNumber();
                    } else if (arg instanceof LiteralString) {
                        LiteralString pString = (LiteralString)arg;
                        value = pString.getString();
                    } else if (arg instanceof LiteralNull) {
                        value = NullValue.getNullValue();
                        int dataType = colMeta.getDataType();
                        switch (dataType) {
                            case -6: 
                            case -5: 
                            case 2: 
                            case 4: 
                            case 5: {
                                value = null;
                            }
                        }
                    } else {
                        throw new SQLException("type of UK is:" + arg.toString());
                    }
                    attrName = String.format("%s.%s", tableName, attrName);
                    if (value == null) continue;
                    if (bOrFlag) {
                        bOrFlag = false;
                    } else {
                        appender.append(" OR ");
                    }
                    TxcObjectWapper.appendParamMarkerObject(attrName, value, appender);
                }
            }
        } else {
            for (RowExpression row : rows) {
                for (int j = 1; j <= lineNum; ++j) {
                    List<Expression> args = row.getRowExprList();
                    for (int i = 0; i < args.size(); ++i) {
                        String autoIncrement;
                        String colName;
                        String attrName = cols.get(i).getIdTextUpUnescape();
                        TxcTableMeta tableMeta = this.getTableMeta();
                        Map<String, TxcColumnMeta> index = tableMeta.getUnionKeyMap();
                        TxcColumnMeta colMeta = tableMeta.getColumnMeta(attrName);
                        if (!colMeta.isCommonType() || index.get(colName = colMeta.getColumnName().toUpperCase()) == null) continue;
                        if (theOnlyUK != null && !colName.equalsIgnoreCase(theOnlyUK)) {
                            throw new SQLException("Multi UKs in INSERT ON DUPLICATE KEY UPDATE is NOT support! [" + colName + " AND " + theOnlyUK + "]");
                        }
                        theOnlyUK = colName;
                        Object value = null;
                        ASTNode arg = args.get(i);
                        if (arg instanceof LiteralNumber) {
                            LiteralNumber pNumber = (LiteralNumber)arg;
                            value = pNumber.getNumber();
                        } else if (arg instanceof LiteralString) {
                            LiteralString pString = (LiteralString)arg;
                            value = pString.getString();
                        } else if (arg instanceof LiteralNull) {
                            value = NullValue.getNullValue();
                        } else if (arg instanceof ParamMarker) {
                            ParamMarker pMarker = (ParamMarker)arg;
                            int pMarkerIndex = pMarker.getParamIndex();
                            value = this.getParameterValue(pMarkerIndex, j);
                        }
                        if (value != null && value == NullValue.getNullValue()) {
                            int dataType = colMeta.getDataType();
                            switch (dataType) {
                                case -6: 
                                case -5: 
                                case 2: 
                                case 4: 
                                case 5: {
                                    value = null;
                                }
                            }
                        } else if (value != null && value instanceof Number && ((Number)value).longValue() == 0L && (autoIncrement = colMeta.getIsAutoincrement()) != null && (autoIncrement.charAt(0) == 'Y' || autoIncrement.charAt(0) == 'y')) {
                            value = null;
                        }
                        if (value == null) continue;
                        if (bOrFlag) {
                            bOrFlag = false;
                        } else {
                            appender.append(" OR ");
                        }
                        TxcObjectWapper.appendParamMarkerObject(attrName, value, appender);
                    }
                }
            }
        }
        return appender.toString();
    }
}

