/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cobar;

import com.alibaba.txc.parser.ast.ASTNode;
import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.misc.QueryExpression;
import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.RowExpression;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNull;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertStatement;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.parser.struct.TxcColumnMeta;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcIndexMeta;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcInsertVisitor;
import com.taobao.txc.parser.visitor.cobar.CobarBaseVisitor;
import com.taobao.txc.parser.visitor.cobar.NullValue;
import com.taobao.txc.parser.visitor.cobar.TxcAstNode;
import com.taobao.txc.parser.visitor.cobar.TxcObjectWapper;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class InsertVisitor
extends CobarBaseVisitor
implements ITxcInsertVisitor {
    private static final LoggerWrap logger = LoggerInit.logger;

    public InsertVisitor(TxcAstNode stmt) {
        super(stmt);
    }

    protected DMLInsertStatement thisVisitor() {
        return (DMLInsertStatement)((TxcAstNode)this.getSQLExplain()).getStatement();
    }

    @Override
    public void visit(DMLInsertStatement node) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String getUserSql() throws SQLException {
        boolean isFst;
        QueryExpression select;
        DMLInsertStatement node = this.thisVisitor();
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        appendable.append("INSERT ");
        switch (node.getMode()) {
            case DELAY: {
                appendable.append("DELAYED ");
                break;
            }
            case HIGH: {
                appendable.append("HIGH_PRIORITY ");
                break;
            }
            case LOW: {
                appendable.append("LOW_PRIORITY ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for INSERT: " + (Object)((Object)node.getMode()));
            }
        }
        if (node.isIgnore()) {
            appendable.append("IGNORE ");
        }
        appendable.append("INTO ");
        appendable.append(this.getSQLExplain().getTableName());
        appendable.append(' ');
        List<Identifier> cols = node.getColumnNameList();
        if (cols != null && !cols.isEmpty()) {
            appendable.append('(');
            this.printList(cols);
            appendable.append(") ");
        }
        if ((select = node.getSelect()) == null) {
            appendable.append("VALUES ");
            List<RowExpression> rows = node.getRowList();
            if (rows == null || rows.isEmpty()) throw new IllegalArgumentException("at least one row for INSERT");
            isFst = true;
            for (RowExpression rowExpression : rows) {
                if (rowExpression == null || rowExpression.getRowExprList().isEmpty()) continue;
                if (isFst) {
                    isFst = false;
                } else {
                    appendable.append(", ");
                }
                appendable.append('(');
                this.printList(rowExpression.getRowExprList());
                appendable.append(')');
            }
        } else {
            select.accept(this);
        }
        List<Pair<Identifier, Expression>> dup = node.getDuplicateUpdate();
        if (dup == null || dup.isEmpty()) return appendable.toString();
        appendable.append(" ON DUPLICATE KEY UPDATE ");
        isFst = true;
        for (Pair pair : dup) {
            if (isFst) {
                isFst = false;
            } else {
                appendable.append(", ");
            }
            ((Identifier)pair.getKey()).accept(this);
            appendable.append(" = ");
            ((Expression)pair.getValue()).accept(this);
        }
        return appendable.toString();
    }

    @Override
    public String getUserSql0() throws SQLException {
        QueryExpression select;
        DMLInsertStatement node = this.thisVisitor();
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        appendable.append("INSERT ");
        switch (node.getMode()) {
            case DELAY: {
                appendable.append("DELAYED ");
                break;
            }
            case HIGH: {
                appendable.append("HIGH_PRIORITY ");
                break;
            }
            case LOW: {
                appendable.append("LOW_PRIORITY ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown mode for INSERT: " + (Object)((Object)node.getMode()));
            }
        }
        if (node.isIgnore()) {
            appendable.append("IGNORE ");
        }
        appendable.append("INTO ");
        appendable.append(this.getSQLExplain().getTableName());
        appendable.append(' ');
        List<Identifier> cols = node.getColumnNameList();
        if (cols != null && !cols.isEmpty()) {
            appendable.append('(');
            this.printList(cols);
            appendable.append(") ");
        }
        if ((select = node.getSelect()) == null) {
            appendable.append("VALUES ");
            List<RowExpression> rows = node.getRowList();
            if (rows == null || rows.isEmpty()) {
                throw new IllegalArgumentException("at least one row for INSERT");
            }
            this.replacePlaceHolder(rows, cols, appendable);
        } else {
            select.accept(this);
        }
        List<Pair<Identifier, Expression>> dup = node.getDuplicateUpdate();
        if (dup != null && !dup.isEmpty()) {
            appendable.append(" ON DUPLICATE KEY UPDATE ");
            boolean isFst = true;
            for (Pair<Identifier, Expression> p : dup) {
                if (isFst) {
                    isFst = false;
                } else {
                    appendable.append(", ");
                }
                p.getKey().accept(this);
                appendable.append(" = ");
                p.getValue().accept(this);
            }
        }
        return appendable.toString();
    }

    @Override
    public String getWhereCondition(ITxcStatement st) throws SQLException {
        DMLInsertStatement node = this.thisVisitor();
        List<RowExpression> rows = node.getRowList();
        final List<Identifier> cols = node.getColumnNameList();
        if (cols == null) {
            throw new SQLException("INSERT SQL [" + node + "] without column names is not supported!");
        }
        if (rows == null || rows.isEmpty()) {
            throw new IllegalArgumentException("at least one row for INSERT");
        }
        String whereContition = null;
        if (this.getTableMeta().isContainsPriKey((List<String>)new ArrayList<String>(){
            {
                for (Identifier col : cols) {
                    this.add(col.getIdTextUpUnescape());
                }
            }
        })) {
            try {
                whereContition = this.selectByPK(rows, cols, st);
            }
            catch (Exception ex) {
                logger.warn("Can NOT selectByPK since: " + ex.getMessage() + ", will try to selectByAutoIncreaseKey");
                whereContition = this.selectByAutoIncreaseKey(rows, cols, st);
            }
        } else {
            whereContition = this.selectByAutoIncreaseKey(rows, cols, st);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("whereSqlAppender:" + whereContition);
        }
        return String.format(" WHERE %s", whereContition);
    }

    @Override
    public TxcTable executeAndGetFrontImage(ITxcStatement st) throws SQLException {
        this.setFrontImage(this.newTxcTable());
        return this.getFrontImage();
    }

    @Override
    public TxcTable executeAndGetRearImage(ITxcStatement st) throws SQLException {
        if (logger.isDebugEnabled()) {
            TxcTableMeta tableMeta = this.getTableMeta();
            Map<String, TxcIndexMeta> allIndexes = tableMeta.getAllIndexes();
            for (Map.Entry<String, TxcIndexMeta> entry : allIndexes.entrySet()) {
                logger.debug(" [" + entry.getKey() + "--->" + entry.getValue() + "] ");
            }
        }
        String sql = this.getSelectSql() + this.getWhereCondition(st);
        this.setRearImage(this.executeRear(st, sql));
        return this.getRearImage();
    }

    private void setRow(List<Identifier> cols, RowExpression row, int loop, StringBuilder appender) throws SQLException {
        boolean bFlag = true;
        List<Expression> args = row.getRowExprList();
        for (int i = 0; i < args.size(); ++i) {
            String attrName = cols.get(i).getIdTextUpUnescape();
            TxcTableMeta tableMeta = this.getTableMeta();
            TxcColumnMeta colMeta = tableMeta.getColumnMeta(attrName);
            if (!colMeta.isCommonType()) continue;
            Object value = null;
            ASTNode arg = args.get(i);
            if (arg instanceof LiteralNumber) {
                LiteralNumber pNumber = (LiteralNumber)arg;
                value = pNumber.getNumber();
            } else if (arg instanceof LiteralString) {
                LiteralString pString = (LiteralString)arg;
                value = pString.getString();
            } else if (arg instanceof ParamMarker) {
                ParamMarker pMarker = (ParamMarker)arg;
                int pMarkerIndex = pMarker.getParamIndex();
                value = this.getParameterValue(pMarkerIndex, loop);
            }
            if (value == null) continue;
            if (bFlag) {
                bFlag = false;
            } else {
                appender.append(" AND ");
            }
            TxcObjectWapper.appendParamMarkerObject(attrName, value, appender);
        }
    }

    private String selectByAutoIncreaseKey(List<RowExpression> rows, List<Identifier> cols, ITxcStatement st0) throws SQLException {
        ResultSet rs;
        TxcColumnMeta column;
        StringBuilder appender;
        block16: {
            appender = this.getNullSqlAppenderBuilder();
            column = this.getTableMeta().getAutoIncreaseColumn();
            if (logger.isDebugEnabled()) {
                logger.debug("Auto Increase Column: " + column);
            }
            if (column == null) {
                TxcColumnMeta pkColumn = this.getTableMeta().getPrimaryKeyColumn();
                if (logger.isDebugEnabled()) {
                    logger.debug("No Auto Increase Column Recognized. Try on PK: " + pkColumn);
                }
                column = pkColumn;
            }
            rs = null;
            try {
                rs = st0.getTargetStatement().getGeneratedKeys();
            }
            catch (SQLException e) {
                if (!e.getSQLState().equalsIgnoreCase("S1009")) break block16;
                rs = st0.getTargetStatement().executeQuery("SELECT LAST_INSERT_ID()");
            }
        }
        int appenderLength = appender.length();
        this.appendByResultSet(appender, column, rs);
        if (appender.length() == appenderLength) {
            logger.info("Try workaround on DbType[" + (Object)((Object)this.getDbType()) + "]");
            if (TxcDbType.ORACLE == this.getDbType()) {
                String tableName = this.getTableMeta().getTableName();
                String seq = "seq_" + tableName + "_pk";
                if (logger.isDebugEnabled()) {
                    logger.debug("Try sequence [" + seq + "]");
                }
                try {
                    Statement seqQueryStat = st0.getTargetStatement().getConnection().createStatement();
                    rs = seqQueryStat.executeQuery("SELECT " + seq + ".currval FROM dual");
                    this.appendByResultSet(appender, column, rs);
                }
                catch (Throwable ex) {
                    logger.warn("Failed to try sequence. " + ex.getMessage(), ex);
                }
            } else if (TxcDbType.POSTGRESQL == this.getDbType()) {
                String tableName = this.getTableMeta().getTableName();
                String seq = "seq_" + tableName + "_pk";
                if (logger.isDebugEnabled()) {
                    logger.debug("Try sequence [" + seq + "]");
                }
                try {
                    Statement seqQueryStat = st0.getTargetStatement().getConnection().createStatement();
                    rs = seqQueryStat.executeQuery("SELECT CURRVAL('" + seq + "')");
                    this.appendByResultSet(appender, column, rs);
                }
                catch (Throwable ex) {
                    logger.warn("Failed to try sequence. " + ex.getMessage(), ex);
                }
            }
        }
        if (appender.length() == appenderLength) {
            logger.info("Try to SELECT by all-fields. ");
            this.selectByAllFields(appender, rows, cols);
        }
        return appender.toString();
    }

    private void appendByResultSet(StringBuilder appender, TxcColumnMeta column, ResultSet rs) throws SQLException {
        if (column == null) {
            return;
        }
        if (rs != null) {
            boolean bOrFlag = true;
            while (rs.next()) {
                if (bOrFlag) {
                    bOrFlag = false;
                } else {
                    appender.append(" OR ");
                }
                appender.append(column.getColumnName());
                appender.append("=");
                appender.append(rs.getObject(1));
            }
        }
    }

    private void selectByAllFields(StringBuilder appender, List<RowExpression> rows, List<Identifier> cols) throws SQLException {
        boolean bOrFlag = true;
        int lineNum = this.getParaRow();
        if (lineNum == 0) {
            for (RowExpression row : rows) {
                if (row == null || row.getRowExprList().isEmpty()) continue;
                if (bOrFlag) {
                    bOrFlag = false;
                } else {
                    appender.append(" OR ");
                }
                this.setRow(cols, row, 1, appender);
            }
        } else {
            RowExpression row = rows.get(0);
            for (int i = 1; i <= lineNum; ++i) {
                if (bOrFlag) {
                    bOrFlag = false;
                } else {
                    appender.append(" OR ");
                }
                this.setRow(cols, row, i, appender);
            }
        }
    }

    private void replacePlaceHolder(List<RowExpression> rows, List<Identifier> cols, StringBuilder appendable) throws SQLException {
        int mLineNum = this.getParaRow();
        if (mLineNum == 0) {
            for (RowExpression row : rows) {
                appendable.append('(');
                List<Expression> args = row.getRowExprList();
                boolean bFlag = true;
                for (int index = 0; index < args.size(); ++index) {
                    ASTNode arg = args.get(index);
                    if (bFlag) {
                        bFlag = false;
                    } else {
                        appendable.append(", ");
                    }
                    arg.accept(this);
                }
                appendable.append(')');
            }
        } else {
            boolean isFst = true;
            for (int line = 1; line <= mLineNum; ++line) {
                if (isFst) {
                    isFst = false;
                } else {
                    appendable.append(", ");
                }
                for (RowExpression row : rows) {
                    appendable.append('(');
                    List<Expression> args = row.getRowExprList();
                    boolean bFlag = true;
                    for (int index = 0; index < args.size(); ++index) {
                        ASTNode arg = args.get(index);
                        if (bFlag) {
                            bFlag = false;
                        } else {
                            appendable.append(", ");
                        }
                        if (arg instanceof ParamMarker) {
                            ParamMarker pMarker = (ParamMarker)arg;
                            int pMarkerIndex = pMarker.getParamIndex();
                            appendable.append(this.getParameterValue(pMarkerIndex, line));
                            continue;
                        }
                        arg.accept(this);
                    }
                    appendable.append(')');
                }
            }
        }
    }

    protected String selectByPK(List<RowExpression> rows, List<Identifier> cols, ITxcStatement st) throws SQLException {
        ASTNode arg;
        Object value;
        String colName;
        StringBuilder appender = this.getNullSqlAppenderBuilder();
        int lineNum = this.getParaRow();
        boolean bOrFlag = true;
        boolean bNextVal = false;
        String pkColName = null;
        if (lineNum == 0) {
            for (RowExpression row : rows) {
                if (row == null || row.getRowExprList().isEmpty()) continue;
                List<Expression> args = row.getRowExprList();
                for (int i = 0; i < args.size(); ++i) {
                    String attrName = cols.get(i).getIdTextUpUnescape();
                    TxcTableMeta tableMeta = this.getTableMeta();
                    Map<String, TxcColumnMeta> index = tableMeta.getPrimaryKeyMap();
                    TxcColumnMeta colMeta = tableMeta.getColumnMeta(attrName);
                    if (colMeta == null) {
                        colMeta = tableMeta.getAllColumns().get(attrName.toLowerCase());
                    }
                    String tableName = tableMeta.getTableName();
                    colName = colMeta.getColumnName().toUpperCase();
                    if (index.get(colName) == null) continue;
                    if (!colMeta.isCommonType()) {
                        throw new SQLException("unsupport pk type:" + colMeta.getDataType());
                    }
                    value = null;
                    arg = args.get(i);
                    if (arg instanceof LiteralNumber) {
                        String autoIncrement;
                        LiteralNumber pNumber = (LiteralNumber)arg;
                        value = pNumber.getNumber();
                        if (value != null && value.equals(0) && (autoIncrement = colMeta.getIsAutoincrement()) != null && (autoIncrement.charAt(0) == 'Y' || autoIncrement.charAt(0) == 'y')) {
                            value = null;
                            bNextVal = true;
                            pkColName = colName;
                        }
                    } else if (arg instanceof LiteralString) {
                        LiteralString pString = (LiteralString)arg;
                        value = pString.getString();
                    } else if (arg instanceof LiteralNull) {
                        value = NullValue.getNullValue();
                        int dataType = colMeta.getDataType();
                        switch (dataType) {
                            case -6: 
                            case -5: 
                            case 2: 
                            case 4: 
                            case 5: {
                                value = null;
                                bNextVal = true;
                                pkColName = colName;
                            }
                        }
                    } else if (arg instanceof Identifier && ((Identifier)arg).isSequenceNextval()) {
                        bNextVal = true;
                        pkColName = colName;
                    } else {
                        throw new SQLException("type of pk is:" + arg.toString());
                    }
                    attrName = String.format("%s.%s", tableName, attrName);
                    if (value == null) continue;
                    if (bOrFlag) {
                        bOrFlag = false;
                    } else {
                        appender.append(" OR ");
                    }
                    TxcObjectWapper.appendParamMarkerObject(attrName, value, appender);
                }
            }
        } else {
            for (RowExpression row : rows) {
                for (int j = 1; j <= lineNum; ++j) {
                    List<Expression> args = row.getRowExprList();
                    for (int i = 0; i < args.size(); ++i) {
                        String autoIncrement;
                        TxcColumnMeta colMeta;
                        String attrName = cols.get(i).getIdTextUpUnescape();
                        TxcTableMeta tableMeta = this.getTableMeta();
                        Map<String, TxcColumnMeta> index = tableMeta.getPrimaryKeyMap();
                        if (index.get(colName = (colMeta = tableMeta.getColumnMeta(attrName)).getColumnName().toUpperCase()) == null) continue;
                        if (!colMeta.isCommonType()) {
                            throw new SQLException("unsupport pk type:" + colMeta.getDataType());
                        }
                        value = null;
                        arg = args.get(i);
                        if (arg instanceof LiteralNumber) {
                            LiteralNumber pNumber = (LiteralNumber)arg;
                            value = pNumber.getNumber();
                        } else if (arg instanceof LiteralString) {
                            LiteralString pString = (LiteralString)arg;
                            value = pString.getString();
                        } else if (arg instanceof LiteralNull) {
                            value = NullValue.getNullValue();
                        } else if (arg instanceof Identifier && ((Identifier)arg).isSequenceNextval()) {
                            bNextVal = true;
                            pkColName = colName;
                        } else if (arg instanceof ParamMarker) {
                            ParamMarker pMarker = (ParamMarker)arg;
                            int pMarkerIndex = pMarker.getParamIndex();
                            value = this.getParameterValue(pMarkerIndex, j);
                        }
                        if (value != null && value == NullValue.getNullValue()) {
                            int dataType = colMeta.getDataType();
                            switch (dataType) {
                                case -6: 
                                case -5: 
                                case 2: 
                                case 4: 
                                case 5: {
                                    value = null;
                                    bNextVal = true;
                                    pkColName = colName;
                                }
                            }
                        } else if (value != null && value instanceof Number && ((Number)value).longValue() == 0L && (autoIncrement = colMeta.getIsAutoincrement()) != null && (autoIncrement.charAt(0) == 'Y' || autoIncrement.charAt(0) == 'y')) {
                            value = null;
                            bNextVal = true;
                            pkColName = colName;
                        }
                        if (value == null) continue;
                        if (bOrFlag) {
                            bOrFlag = false;
                        } else {
                            appender.append(" OR ");
                        }
                        TxcObjectWapper.appendParamMarkerObject(attrName, value, appender);
                    }
                }
            }
        }
        if (bNextVal) {
            ResultSet rs = st.getGeneratedKeys();
            if (rs != null && !StringUtils.isEmpty(pkColName)) {
                int genPkCount = 0;
                while (rs.next()) {
                    if (bOrFlag) {
                        bOrFlag = false;
                    } else {
                        appender.append(" OR ");
                    }
                    appender.append(pkColName);
                    appender.append("=");
                    appender.append(rs.getObject(1));
                    ++genPkCount;
                }
                rs.close();
                if (genPkCount == 0) {
                    throw new IllegalArgumentException("pk is not generated id " + pkColName);
                }
            } else {
                throw new IllegalArgumentException("pk is not generated id or pk column is invalid " + pkColName);
            }
        }
        return appender.toString();
    }

    @Override
    public List<List<TxcField>> getpks() throws SQLException {
        DMLInsertStatement node = this.thisVisitor();
        List<RowExpression> rows = node.getRowList();
        final List<Identifier> cols = node.getColumnNameList();
        if (cols == null) {
            throw new SQLException("INSERT SQL [" + node + "] without column names is not supported!");
        }
        TxcTableMeta tableMeta = this.getTableMeta();
        if (rows == null || rows.isEmpty()) {
            throw new IllegalArgumentException("at least one row for INSERT");
        }
        if (tableMeta.isContainsPriKey((List<String>)new ArrayList<String>(){
            {
                for (Identifier col : cols) {
                    this.add(col.getIdTextUpUnescape());
                }
            }
        })) {
            ArrayList<List<TxcField>> pks = new ArrayList<List<TxcField>>();
            int lineNum = this.getParaRow();
            if (lineNum == 0) {
                for (RowExpression row : rows) {
                    if (row == null || row.getRowExprList().isEmpty()) continue;
                    ArrayList<TxcField> fields = new ArrayList<TxcField>();
                    List<Expression> args = row.getRowExprList();
                    for (int i = 0; i < args.size(); ++i) {
                        TxcField field = new TxcField();
                        String colName = cols.get(i).getIdTextUpUnescape();
                        Map<String, TxcColumnMeta> indexs = tableMeta.getPrimaryKeyMap();
                        TxcColumnMeta index = indexs.get(colName);
                        if (index == null) continue;
                        Object value = null;
                        ASTNode arg = args.get(i);
                        if (arg instanceof LiteralNumber) {
                            LiteralNumber pNumber = (LiteralNumber)arg;
                            value = pNumber.getNumber();
                        } else if (arg instanceof LiteralString) {
                            LiteralString pString = (LiteralString)arg;
                            value = pString.getString();
                        }
                        field.setName(index.getColumnName());
                        field.setType(index.getDataType());
                        field.setValue(value);
                        fields.add(field);
                    }
                    if (fields.size() <= 0) continue;
                    pks.add(fields);
                }
            } else {
                for (RowExpression row : rows) {
                    for (int j = 1; j <= this.getParaRow(); ++j) {
                        ArrayList<TxcField> fields = new ArrayList<TxcField>();
                        List<Expression> args = row.getRowExprList();
                        for (int i = 0; i < args.size(); ++i) {
                            TxcField field = new TxcField();
                            String colName = cols.get(i).getIdTextUpUnescape();
                            Map<String, TxcColumnMeta> indexs = tableMeta.getPrimaryKeyMap();
                            TxcColumnMeta index = indexs.get(colName);
                            if (index == null) continue;
                            Object value = null;
                            ASTNode arg = args.get(i);
                            if (arg instanceof LiteralNumber) {
                                LiteralNumber pNumber = (LiteralNumber)arg;
                                value = pNumber.getNumber();
                            } else if (arg instanceof LiteralString) {
                                LiteralString pString = (LiteralString)arg;
                                value = pString.getString();
                            } else if (arg instanceof ParamMarker) {
                                ParamMarker pMarker = (ParamMarker)arg;
                                int pMarkerIndex = pMarker.getParamIndex();
                                value = this.getParameterValue(pMarkerIndex, j);
                            }
                            field.setName(index.getColumnName());
                            field.setType(index.getDataType());
                            field.setValue(value);
                            fields.add(field);
                        }
                        if (fields.size() <= 0) continue;
                        pks.add(fields);
                    }
                }
            }
            return pks;
        }
        return null;
    }
}

