/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cobar;

import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.fragment.GroupBy;
import com.alibaba.txc.parser.ast.fragment.Limit;
import com.alibaba.txc.parser.ast.fragment.OrderBy;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.SQLStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectUnionStatement;
import com.alibaba.txc.parser.util.Pair;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcSelectVisitor;
import com.taobao.txc.parser.visitor.cobar.CobarBaseVisitor;
import com.taobao.txc.parser.visitor.cobar.TxcAstNode;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SelectVisitor
extends CobarBaseVisitor
implements ITxcSelectVisitor {
    private static final LoggerWrap logger = LoggerInit.logger;

    public SelectVisitor(TxcAstNode stmt) {
        super(stmt);
    }

    private DMLSelectStatement thisVisitor() {
        SQLStatement statement = ((TxcAstNode)this.getSQLExplain()).getStatement();
        if (statement instanceof DMLSelectUnionStatement) {
            statement = ((DMLSelectUnionStatement)statement).getSelectStmtList().get(0);
        }
        return (DMLSelectStatement)statement;
    }

    @Override
    public void visit(DMLSelectStatement node) {
    }

    @Override
    public String getUserSql() throws SQLException {
        DMLSelectStatement node = this.thisVisitor();
        StringBuilder appendable = new StringBuilder();
        appendable.append(this.getBody(node));
        Expression where = node.getWhere();
        appendable.append(this.getWhere(where, null));
        GroupBy group = node.getGroup();
        appendable.append(this.getGroupBy(group));
        Expression having = node.getHaving();
        appendable.append(this.getHaving(having));
        OrderBy order = node.getOrder();
        appendable.append(this.getOrderBy(order));
        Limit limit = node.getLimit();
        appendable.append(this.getLimit(limit));
        appendable.append(this.fixOption(node));
        if (logger.isDebugEnabled()) {
            logger.debug(appendable.toString());
        }
        return appendable.toString();
    }

    @Override
    public String getUserSql0() throws SQLException {
        return this.getUserSql();
    }

    @Override
    public String getWhereCondition(ITxcStatement st) {
        DMLSelectStatement node = this.thisVisitor();
        StringBuilder appendable = new StringBuilder();
        Expression where = node.getWhere();
        appendable.append(this.getWhere(where, null));
        GroupBy group = node.getGroup();
        appendable.append(this.getGroupBy(group));
        Expression having = node.getHaving();
        appendable.append(this.getHaving(having));
        OrderBy order = node.getOrder();
        appendable.append(this.getOrderBy(order));
        Limit limit = node.getLimit();
        appendable.append(this.getLimit(limit));
        appendable.append(this.fixOption(node));
        return appendable.toString();
    }

    @Override
    public TxcTable executeAndGetFrontImage(ITxcStatement st) throws SQLException {
        this.setFrontImage(this.newTxcTable());
        return this.getFrontImage();
    }

    @Override
    public TxcTable executeAndGetRearImage(ITxcStatement st) throws SQLException {
        this.setRearImage(this.newTxcTable());
        return this.getRearImage();
    }

    String fixOption(DMLSelectStatement node) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        DMLSelectStatement.SelectOption option = node.getOption();
        switch (option.lockMode) {
            case FOR_UPDATE: {
                appendable.append(" FOR UPDATE");
                break;
            }
            case LOCK_IN_SHARE_MODE: {
                appendable.append(" LOCK IN SHARE MODE");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        return appendable.toString();
    }

    String getLimit(Limit limit) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        if (limit != null) {
            appendable.append(' ');
            limit.accept(this);
        }
        return appendable.toString();
    }

    String getOrderBy(OrderBy order) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        if (order != null) {
            appendable.append(' ');
            order.accept(this);
        }
        return appendable.toString();
    }

    String getHaving(Expression having) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        if (having != null) {
            appendable.append(" HAVING ");
            having.accept(this);
        }
        return appendable.toString();
    }

    String getGroupBy(GroupBy group) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        if (group != null) {
            appendable.append(' ');
            group.accept(this);
        }
        return appendable.toString();
    }

    String getBody(DMLSelectStatement node) throws SQLException {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        appendable.append("SELECT ");
        DMLSelectStatement.SelectOption option = node.getOption();
        switch (option.resultDup) {
            case ALL: {
                break;
            }
            case DISTINCT: {
                appendable.append("DISTINCT ");
                break;
            }
            case DISTINCTROW: {
                appendable.append("DISTINCTROW ");
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.highPriority) {
            appendable.append("HIGH_PRIORITY ");
        }
        if (option.straightJoin) {
            appendable.append("STRAIGHT_JOIN ");
        }
        switch (option.resultSize) {
            case SQL_BIG_RESULT: {
                appendable.append("SQL_BIG_RESULT ");
                break;
            }
            case SQL_SMALL_RESULT: {
                appendable.append("SQL_SMALL_RESULT ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlBufferResult) {
            appendable.append("SQL_BUFFER_RESULT ");
        }
        switch (option.queryCache) {
            case SQL_CACHE: {
                appendable.append("SQL_CACHE ");
                break;
            }
            case SQL_NO_CACHE: {
                appendable.append("SQL_NO_CACHE ");
                break;
            }
            case UNDEF: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown option for SELECT: " + option);
            }
        }
        if (option.sqlCalcFoundRows) {
            appendable.append("SQL_CALC_FOUND_ROWS ");
        }
        boolean isFst = true;
        List<Pair<Expression, String>> exprList = node.getSelectExprList();
        for (Pair<Expression, String> p : exprList) {
            String alias;
            if (isFst) {
                isFst = false;
            } else {
                appendable.append(", ");
            }
            if (p.getKey() instanceof DMLSelectStatement) {
                appendable.append("(");
            }
            p.getKey().accept(this);
            if (p.getKey() instanceof DMLSelectStatement) {
                appendable.append(")");
            }
            if ((alias = p.getValue()) == null) continue;
            appendable.append(" AS ").append(alias);
        }
        TableReferences from = node.getTables();
        if (from != null) {
            appendable.append(" FROM ");
            appendable.append(this.getSQLExplain().getTableName());
        }
        return appendable.toString();
    }

    String getWhere(Expression where, String extraWhereCondition) {
        StringBuilder appendable = this.getNullSqlAppenderBuilder();
        if (where != null) {
            appendable.append(" WHERE ");
            where.accept(this);
            if (extraWhereCondition != null && !extraWhereCondition.isEmpty()) {
                appendable.append(" AND ");
                appendable.append(extraWhereCondition);
            }
        } else if (extraWhereCondition != null && !extraWhereCondition.isEmpty()) {
            appendable.append(" WHERE ");
            appendable.append(extraWhereCondition);
        }
        return appendable.toString();
    }

    @Override
    public List<List<TxcField>> getpks() throws SQLException {
        throw new SQLException("not supported");
    }

    @Override
    public String getSelectSqlByPK(TxcTable table) throws SQLException {
        if (table == null) {
            throw new SQLException("table is not exit");
        }
        TxcTableMeta tableMeta = this.getTableMeta();
        if (tableMeta == null) {
            throw new SQLException("tableMeta is null");
        }
        String pkName = tableMeta.getPkName();
        if (StringUtils.isEmpty((String)pkName)) {
            throw new SQLException("pkName is null");
        }
        DMLSelectStatement node = this.thisVisitor();
        StringBuilder sb = new StringBuilder();
        sb.append(this.getBody(node));
        if (table.linesNum() != 0) {
            String whereConditionByPK = this.getWhereCondition(table);
            sb.append(whereConditionByPK);
        } else {
            sb.append(" WHERE 1=0");
        }
        String ret = sb.toString();
        logger.info(String.format("[xid:%d] [%s]", TxcContext.getTransactionId(), ret));
        return ret;
    }
}

