/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cobar;

import com.alibaba.txc.parser.ast.expression.primary.Identifier;
import com.alibaba.txc.parser.ast.fragment.tableref.TableRefFactor;
import com.alibaba.txc.parser.ast.fragment.tableref.TableReferences;
import com.alibaba.txc.parser.ast.stmt.SQLStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLDeleteStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertReplaceStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLInsertStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLSelectUnionStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLStatement;
import com.alibaba.txc.parser.ast.stmt.dml.DMLUpdateStatement;
import com.alibaba.txc.parser.recognizer.SQLParserDelegate;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.parser.struct.SqlType;
import com.taobao.txc.parser.struct.SqlTypeParser;
import com.taobao.txc.parser.visitor.api.ITxcSQLExplain;
import java.sql.SQLException;
import java.util.List;

public class TxcAstNode
implements ITxcSQLExplain {
    private static final LoggerWrap logger = LoggerInit.logger;
    private SQLStatement statement;
    private final SqlType type;
    private final String sql;

    public TxcAstNode(String sql) throws SQLException {
        long end;
        this.sql = sql;
        long start = System.currentTimeMillis();
        this.type = SqlTypeParser.getSqlType(sql);
        if (this.type != SqlType.SELECT) {
            this.statement = SQLParserDelegate.parse(sql);
        }
        if ((end = System.currentTimeMillis()) - start > 10L) {
            logger.info(String.format("SQL:[%s] parser too slow, cost [%d] ms.", sql, end - start));
        }
    }

    public SQLStatement getStatement() {
        return this.statement;
    }

    @Override
    public SqlType getSqlType() {
        return this.type;
    }

    @Override
    public String getInputSql() {
        return this.sql;
    }

    @Override
    public Boolean isQuerySql() throws SQLException {
        return SqlTypeParser.isQuerySqlType(this.type);
    }

    @Override
    public String getTableName() throws SQLException {
        SQLStatement statement = this.getStatement();
        return this.getTableName(statement);
    }

    @Override
    public String getTableNameAlias() throws SQLException {
        String alias = null;
        if (!(this.statement instanceof DMLDeleteStatement) && !(this.statement instanceof DMLInsertStatement)) {
            if (this.statement instanceof DMLSelectStatement) {
                DMLSelectStatement dnode = (DMLSelectStatement)this.statement;
                TableReferences tRefs = dnode.getTables();
                alias = this.getTableNameAlias(tRefs);
            } else if (this.statement instanceof DMLUpdateStatement) {
                DMLUpdateStatement dnode = (DMLUpdateStatement)this.statement;
                TableReferences tRefs = dnode.getTableRefs();
                alias = this.getTableNameAlias(tRefs);
            }
        }
        return alias;
    }

    private String getTableName(SQLStatement statement) throws SQLException {
        DMLStatement dnode;
        String tableName = null;
        if (statement instanceof DMLDeleteStatement) {
            dnode = (DMLDeleteStatement)statement;
            Identifier id = ((DMLDeleteStatement)dnode).getTableNames().get(0);
            tableName = this.getTableName(id);
        } else if (statement instanceof DMLInsertStatement) {
            dnode = (DMLInsertStatement)statement;
            Identifier id = ((DMLInsertReplaceStatement)dnode).getTable();
            tableName = this.getTableName(id);
        } else if (statement instanceof DMLSelectStatement) {
            dnode = (DMLSelectStatement)statement;
            TableReferences tRefs = ((DMLSelectStatement)dnode).getTables();
            tableName = this.getTableName(tRefs);
        } else if (statement instanceof DMLUpdateStatement) {
            dnode = (DMLUpdateStatement)statement;
            TableReferences tRefs = ((DMLUpdateStatement)dnode).getTableRefs();
            tableName = this.getTableName(tRefs);
        } else if (statement instanceof DMLSelectUnionStatement) {
            dnode = (DMLSelectUnionStatement)statement;
            List<DMLSelectStatement> selectStmtList = ((DMLSelectUnionStatement)dnode).getSelectStmtList();
            tableName = this.getTableName(selectStmtList.get(0));
        }
        if (tableName == null) {
            String errorLog = String.format("getTableName error, %s", statement.getClass().getName());
            logger.error(errorLog, errorLog);
            throw new SQLException(errorLog);
        }
        return tableName;
    }

    private String getTableName(TableReferences tr) throws SQLException {
        if (!tr.isSingleTable()) {
            throw new SQLException("getTableName error, unsupported complex sql.");
        }
        return ((TableRefFactor)tr.getTableReferenceList().get(0)).getTable().getIdTextUpUnescape();
    }

    private String getTableNameAlias(TableReferences tr) throws SQLException {
        if (!tr.isSingleTable()) {
            throw new SQLException("getTableName error, unsupported complex sql.");
        }
        return ((TableRefFactor)tr.getTableReferenceList().get(0)).getAlias();
    }

    private String getTableName(Identifier node) throws SQLException {
        String tableName = "";
        Identifier parent = node.getParent();
        if (parent != null) {
            tableName = this.getTableName(parent);
            tableName = tableName + ".";
        }
        return tableName + node.getIdText().toUpperCase();
    }
}

