/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.parser.visitor.cobar;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.txc.parser.ast.expression.Expression;
import com.alibaba.txc.parser.ast.expression.primary.ParamMarker;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralNumber;
import com.alibaba.txc.parser.ast.expression.primary.literal.LiteralString;
import com.taobao.txc.parser.struct.ParameterContext;
import com.taobao.txc.parser.struct.Parameters;
import com.taobao.txc.parser.visitor.cobar.NullValue;
import java.sql.SQLException;
import java.util.Date;

public class TxcObjectWapper {
    public static String stringReplaceSpecialCharacters(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        char[] chs = str.toCharArray();
        if (str.length() < 2 || chs[0] != '\'' || chs[str.length() - 1] != '\'') {
            return str;
        }
        StringBuilder sb = new StringBuilder("'");
        for (int i = 1; i < chs.length - 1; ++i) {
            if (chs[i] == '\'') {
                sb.append("''");
                continue;
            }
            if (chs[i] == '\\') {
                sb.append("\\\\");
                continue;
            }
            sb.append(chs[i]);
        }
        sb.append("'");
        return sb.toString();
    }

    public static String jsonObjectDeserialize(int type, Object value) {
        if (value == null) {
            return "null";
        }
        switch (type) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2003: {
                return "'" + value + "'";
            }
            case 91: 
            case 92: 
            case 93: {
                Date d = new Date(Long.parseLong(value.toString()));
                return JSON.toJSONString((Object)d, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat, SerializerFeature.UseSingleQuotes});
            }
        }
        return value.toString();
    }

    public static Object getCommonValue(Expression arg, Parameters paras) {
        Object value = null;
        if (arg instanceof LiteralNumber) {
            LiteralNumber pNumber = (LiteralNumber)arg;
            value = pNumber.getNumber();
        } else if (arg instanceof LiteralString) {
            LiteralString pString = (LiteralString)arg;
            value = pString.getString();
        } else if (arg instanceof ParamMarker) {
            ParamMarker pMarker = (ParamMarker)arg;
            int pMarkerIndex = pMarker.getParamIndex();
            value = paras.getFirstParameter().get(pMarkerIndex);
        }
        return value;
    }

    public static void appendParamMarkerObject(Object value, StringBuilder appender) throws SQLException {
        if (value == null) {
            appender.append("null");
            return;
        }
        if (String.class.isAssignableFrom(value.getClass())) {
            String text = (String)value;
            appender.append("'" + text.replaceAll("'", "''") + "'");
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            appender.append("'" + value + "'");
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            appender.append(value);
        } else if (ParameterContext.class.isAssignableFrom(value.getClass())) {
            appender.append("'" + value + "'");
        } else if (value == NullValue.getNullValue()) {
            appender.append("null");
        } else {
            throw new SQLException("" + value.getClass());
        }
    }

    public static void appendParamMarkerObject(String name, Object value, StringBuilder appender) throws SQLException {
        if (value == null) {
            return;
        }
        appender.append(name);
        appender.append(" = ");
        if (String.class.isAssignableFrom(value.getClass())) {
            appender.append("'" + value + "'");
        } else if (Date.class.isAssignableFrom(value.getClass())) {
            appender.append("'" + value + "'");
        } else if (Number.class.isAssignableFrom(value.getClass())) {
            appender.append(value);
        } else if (ParameterContext.class.isAssignableFrom(value.getClass())) {
            appender.append("'" + value + "'");
        } else if (value == NullValue.getNullValue()) {
            appender.append("null");
        } else {
            throw new SQLException("" + value.getClass());
        }
    }
}

