/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.TransactionMode;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.RegisterMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.common.message.TxcMergeMessage;
import com.taobao.txc.common.message.TxcMergeResultMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.resourcemanager.IRmRpcClient;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.mt.MtRmRpcClient;
import com.taobao.txc.rpc.api.ClientMessageListener;
import com.taobao.txc.rpc.api.TxcClientMessageSender;
import com.taobao.txc.rpc.impl.HeartbeatMessage;
import com.taobao.txc.rpc.impl.MessageFuture;
import com.taobao.txc.rpc.impl.RegisterRmMessage;
import com.taobao.txc.rpc.impl.RegisterRmResultMessage;
import com.taobao.txc.rpc.impl.RpcEndpoint;
import com.taobao.txc.rpc.impl.RpcMessage;
import com.taobao.txc.rpc.impl.TxcMessageCodec;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.internal.ConcurrentSet;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@ChannelHandler.Sharable
public class RmRpcClient
extends RpcEndpoint
implements IRmRpcClient,
TxcClientMessageSender {
    private static final LoggerWrap logger = LoggerInit.logger;
    private NioEventLoopGroup eventloopGroup = new NioEventLoopGroup(1);
    private ClientMessageListener clientMessageListener;
    private String appName;
    protected volatile Set<String> serverAddressList = null;
    private ConcurrentHashMap<String, Object> channelLocks = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, TxcChannel> channels = new ConcurrentHashMap();
    private static RmRpcClient instance;
    private String customerKeys;
    public static Set<String> tableKeywords;

    public String getAppName() {
        return this.appName;
    }

    public RmRpcClient(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        super(txcCommonThreadPoolExecutor);
    }

    public static RmRpcClient getInstance() {
        return instance;
    }

    public static RmRpcClient getInstance(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        if (instance == null) {
            instance = new RmRpcClient(txcCommonThreadPoolExecutor);
        }
        TxcConfigHolder.getInstance().getTableKeywordsDynamic(new IConfigCallback(){

            @Override
            public void callback(String content) {
                logger.info(String.format("table key words: %s", content));
                if (content == null) {
                    return;
                }
                if ((content = content.trim()).length() == 0) {
                    return;
                }
                try {
                    String[] words;
                    if (tableKeywords == null) {
                        tableKeywords = new ConcurrentSet();
                    }
                    tableKeywords.clear();
                    for (String word : words = content.split(",")) {
                        tableKeywords.add(word.toUpperCase());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return instance;
    }

    @Override
    public void init() {
        this.skipVip = TxcConfigHolder.getSkipVip(false);
        logger.info("RmRpcClient skip vip " + this.skipVip);
        this.timerExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RmRpcClient.this.reconnect();
            }
        }, 30L, 5L, TimeUnit.SECONDS);
        this.fetchServerAddressList();
        new Thread(new Worker(this)).start();
        super.init();
    }

    protected void fetchVipServerAddressIfAbsentOnce(String serverAddress) {
        String vipAddress = TxcConfigHolder.getInstance().lookupVIP(serverAddress);
        if (vipAddress == null) {
            String vipAddressDataId = TxcString.toServerAddressVipDataId(serverAddress);
            try {
                vipAddress = TxcConfigHolder.getInstance().getConfig(vipAddressDataId, "TXC_GROUP", 1000L);
                logger.info(vipAddressDataId + "=" + vipAddress);
                vipAddressDataId = TxcString.toServerAddressVipVPCDataId(serverAddress);
                String vipVPCAddress = TxcConfigHolder.getInstance().getConfig(vipAddressDataId, "TXC_GROUP", 1000L);
                logger.info(vipAddressDataId + "=" + vipVPCAddress);
                if (vipVPCAddress != null) {
                    vipAddress = vipVPCAddress;
                }
                TxcConfigHolder.getInstance().updateVIPMapping(serverAddress, vipAddress);
            }
            catch (IOException e) {
                logger.error(TxcErrCode.DiamondGetConfig.errCode, String.format("get vip failed:%s", serverAddress));
            }
        }
    }

    protected void fetchServerAddressList() {
        this.serverAddressList = TxcAtomDataSourceHelper.getServerAddrs();
        for (String serverAddress : this.serverAddressList) {
            this.fetchVipServerAddressIfAbsentOnce(serverAddress);
        }
    }

    private void reconnect() {
        if (this.serverAddressList != null) {
            for (String serverAddress : this.serverAddressList) {
                try {
                    if (serverAddress == null || serverAddress.length() <= 0) continue;
                    this.fetchVipServerAddressIfAbsentOnce(serverAddress);
                    this.connect(serverAddress);
                }
                catch (Exception e) {
                    logger.error(TxcErrCode.NetConnect.errCode, "schedule reconnect,can not connect to " + serverAddress + " cause:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.messageExecutor.isShutdown()) {
            return;
        }
        logger.info("channel inactive:" + ctx.channel());
        this.releaseChannel(ctx.channel(), NetUtil.toStringAddress(ctx.channel().remoteAddress()));
        super.channelInactive(ctx);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.eventloopGroup.shutdownGracefully();
    }

    @Override
    public void dispatch(long msgId, ChannelHandlerContext ctx, Object msg) {
        String remoteAddress = NetUtil.toStringAddress(ctx.channel().remoteAddress());
        String address = TxcConfigHolder.getInstance().lookupRIP(remoteAddress);
        if (address != null) {
            remoteAddress = address;
        }
        this.clientMessageListener.onMessage(msgId, remoteAddress, msg);
    }

    @Override
    public Object invoke(Object msg, long timeout) throws IOException, TimeoutException {
        return super.invoke(TxcXID.getServerAddress(TxcContext.getCurrentXid()), this.getTargetServerChannel(), msg, timeout);
    }

    @Override
    public Object invoke(String serverAddress, Object msg, long timeout) throws IOException, TimeoutException {
        return super.invoke(serverAddress, this.connect(serverAddress), msg, timeout);
    }

    private Channel getTargetServerChannel() {
        String serverAddress = null;
        if (!TxcContext.inTxcTransaction()) {
            return null;
        }
        serverAddress = TxcXID.getServerAddress(TxcContext.getCurrentXid());
        return this.connect(serverAddress);
    }

    @Override
    public Object invoke(Object msg) throws IOException, TimeoutException {
        return this.invoke(msg, 30000L);
    }

    public short getRmType() {
        return (short)CommitMode.COMMIT_IN_PHASE1.getValue();
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        RpcMessage rpcMessage;
        if (msg instanceof RpcMessage && (rpcMessage = (RpcMessage)msg).getBody() == HeartbeatMessage.PONG) {
            if (logger.isDebugEnabled()) {
                logger.debug("received PONG from " + ctx.channel().remoteAddress());
            }
            return;
        }
        if (((RpcMessage)msg).getBody() instanceof TxcMergeResultMessage) {
            TxcMergeResultMessage results = (TxcMergeResultMessage)((RpcMessage)msg).getBody();
            TxcMergeMessage mergeMessage = (TxcMergeMessage)this.mergeMsgMap.remove(((RpcMessage)msg).getId());
            logger.info("received merge msg:" + ((RpcMessage)msg).getId() + ", exist in map:" + mergeMessage + ",origin rpc msg:" + ((RpcMessage)msg).getBody());
            int num = mergeMessage.msgs.size();
            for (int i = 0; i < num; ++i) {
                long msgId = mergeMessage.msgIds.get(i);
                MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                if (future == null) {
                    logger.info("msg:" + msgId + " is not found in futures.");
                    continue;
                }
                future.setResultMessage(results.getMsgs()[i]);
            }
            return;
        }
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent == IdleStateEvent.READER_IDLE_STATE_EVENT) {
                if (this instanceof MtRmRpcClient) {
                    logger.info("MtRmRpcClient channel" + ctx.channel() + " idle.");
                } else {
                    logger.info("RmRpcClient channel" + ctx.channel() + " idle.");
                }
                try {
                    ctx.disconnect();
                    ctx.close();
                    TxcConstants.removeChannelVersion(ctx.channel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (idleStateEvent == IdleStateEvent.WRITER_IDLE_STATE_EVENT) {
                try {
                    logger.info("write idle,will send ping,channel:" + ctx.channel());
                    this.sendRequest(ctx.channel(), HeartbeatMessage.PING);
                }
                catch (Throwable throwable) {
                    logger.error("", "send request error", throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseChannel(Channel channel, String serverAddress) {
        try {
            Object connectLock = this.channelLocks.get(serverAddress);
            if (connectLock == null) {
                this.channelLocks.putIfAbsent(serverAddress, new Object());
                connectLock = this.channelLocks.get(serverAddress);
            }
            logger.info("will be release channel:" + channel);
            Object object = connectLock;
            synchronized (object) {
                TxcChannel ch = this.channels.get(serverAddress);
                if (ch != null && ch.channel.compareTo((Object)channel) == 0) {
                    this.channels.remove(serverAddress);
                    try {
                        logger.info("release channel:" + channel);
                        channel.disconnect();
                        channel.close();
                        TxcConstants.removeChannelVersion(channel);
                    }
                    catch (Throwable throwable) {
                        logger.error("", "channel close error", throwable);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("", "close not active channel error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel connect(String serverAddress) {
        TxcChannel channelToServer = this.channels.get(serverAddress);
        if (channelToServer != null) {
            if (channelToServer.channel.isActive()) {
                return channelToServer.channel;
            }
            int i = 0;
            for (i = 0; i < TxcConfigHolder.getInstance().getMaxConnectRetryTime(); ++i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                channelToServer = this.channels.get(serverAddress);
                if (channelToServer == null) break;
                if (!channelToServer.channel.isActive()) continue;
                return channelToServer.channel;
            }
            if (i == TxcConfigHolder.getInstance().getMaxConnectRetryTime()) {
                logger.warn("channel " + channelToServer.channel + " is not active after long wait, close it.");
                this.releaseChannel(channelToServer.channel, serverAddress);
            }
        }
        logger.info("will connect to " + serverAddress);
        Object connectLock = this.channelLocks.get(serverAddress);
        if (connectLock == null) {
            this.channelLocks.putIfAbsent(serverAddress, new Object());
            connectLock = this.channelLocks.get(serverAddress);
        }
        Object object = connectLock;
        synchronized (object) {
            InetSocketAddress address;
            channelToServer = this.channels.get(serverAddress);
            if (channelToServer != null && channelToServer.channel.isActive()) {
                return channelToServer.channel;
            }
            String vipAddress = this.findVip(serverAddress);
            if (vipAddress != null && !vipAddress.isEmpty()) {
                address = NetUtil.toInetSocketAddress(vipAddress);
                logger.info(String.format("vip: %s ==> %s", serverAddress, vipAddress));
            } else {
                address = NetUtil.toInetSocketAddress(serverAddress);
            }
            logger.info("will connect to " + serverAddress + " via VIP " + vipAddress);
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)this.eventloopGroup)).channel(NioSocketChannel.class)).remoteAddress((SocketAddress)address).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)false)).option(ChannelOption.WRITE_BUFFER_LOW_WATER_MARK, (Object)32768)).option(ChannelOption.WRITE_BUFFER_HIGH_WATER_MARK, (Object)131072)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(15, 3, 0), new TxcMessageCodec(), RmRpcClient.this});
                }
            });
            Channel tmpChannel = null;
            ChannelFuture f = b.connect();
            try {
                f.await(10L, TimeUnit.SECONDS);
                if (f.isCancelled()) {
                    throw new TxcException("connect concelled, can not connect to txc server. " + address);
                }
                if (!f.isSuccess()) {
                    throw new TxcException(f.cause(), "connect failed, can not connect to txc server. " + address);
                }
                tmpChannel = f.channel();
            }
            catch (Exception e) {
                throw new TxcException(e, "can not connect to txc server.");
            }
            try {
                String dbKey = this.customerKeys == null ? TxcAtomDataSourceHelper.getDbKeysFromSet() : this.customerKeys;
                logger.info("RM will register dbkey:" + dbKey);
                RegisterRmMessage message = new RegisterRmMessage(dbKey);
                message.setAppName(this.appName);
                message.setType(this.getRmType());
                Object response = super.invoke(null, tmpChannel, message, 30000L);
                if (response != null && response instanceof RegisterRmResultMessage) {
                    if (((RegisterRmResultMessage)response).isResult()) {
                        logger.info("register RM sucesss. server version:" + ((RegisterRmResultMessage)response).getVersion() + ",channel:" + tmpChannel);
                        if (this.customerKeys == null) {
                            Class<TxcAtomDataSourceHelper> clazz = TxcAtomDataSourceHelper.class;
                            synchronized (TxcAtomDataSourceHelper.class) {
                                this.channels.put(serverAddress, new TxcChannel(tmpChannel, TransactionMode.TXC_AT));
                                String dbKey1 = TxcAtomDataSourceHelper.getDbKeysFromSet();
                                // ** MonitorExit[var14_17] (shouldn't be in output)
                                if (!dbKey.equals(dbKey1)) {
                                    this.sendRegisterMessage(serverAddress, tmpChannel, dbKey1);
                                }
                            }
                        } else {
                            this.channels.put(serverAddress, new TxcChannel(tmpChannel, TransactionMode.TXC_MT));
                        }
                        return tmpChannel;
                    }
                    logger.info("register RM failed. server version:" + ((RegisterRmResultMessage)response).getVersion());
                    if (tmpChannel != null) {
                        tmpChannel.close();
                    }
                    throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "register RM failed.");
                }
                if (tmpChannel != null) {
                    tmpChannel.close();
                }
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register RM.");
            }
            catch (Exception e) {
                logger.error(TxcErrCode.RegistRM.errCode, "register RM failed.", (Throwable)e);
                if (tmpChannel != null) {
                    tmpChannel.close();
                }
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register RM.");
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(TxcErrCode.ExceptionCaught.errCode, NetUtil.toStringAddress(ctx.channel().remoteAddress()) + "connect exception. " + cause.getMessage(), cause);
        Iterator<Map.Entry<String, TxcChannel>> it = this.channels.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue().channel.compareTo((Object)ctx.channel()) != 0) continue;
            it.remove();
            logger.info("remove channel:" + ctx.channel());
        }
        super.exceptionCaught(ctx, cause);
    }

    private void sendRegisterMessage(String serverAddress, Channel channel, String dbKey) {
        RegisterRmMessage message = new RegisterRmMessage(dbKey);
        message.setAppName(this.appName);
        message.setType(this.getRmType());
        try {
            super.invoke(null, channel, message, 0L, false);
        }
        catch (TxcException e) {
            if (e.getMessage() != null && e.getMessage().contains("channel is not writable") && serverAddress != null) {
                this.channels.remove(serverAddress);
                logger.info("remove channel:" + channel);
            } else {
                logger.error("", "register failed", (Throwable)e);
            }
        }
        catch (IOException iOException) {
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerNewDbKey(String dbKey) {
        logger.info("registerNewDbKey dbKey:" + dbKey);
        Class<TxcAtomDataSourceHelper> clazz = TxcAtomDataSourceHelper.class;
        synchronized (TxcAtomDataSourceHelper.class) {
            Iterator<Map.Entry<String, TxcChannel>> iterator = this.channels.entrySet().iterator();
            // ** MonitorExit[var3_2] (shouldn't be in output)
            while (iterator.hasNext()) {
                Map.Entry<String, TxcChannel> entry = iterator.next();
                String serverAddress = entry.getKey();
                TxcChannel txcChannel = entry.getValue();
                if (txcChannel.mode.getValue() != TransactionMode.TXC_AT.getValue()) continue;
                logger.info("registerNewDbKey dbKey:" + dbKey);
                this.sendRegisterMessage(serverAddress, txcChannel.channel, dbKey);
            }
            return;
        }
    }

    public ClientMessageListener getClientMessageListener() {
        return this.clientMessageListener;
    }

    @Override
    public void setClientMessageListener(ClientMessageListener clientMessageListener) {
        this.clientMessageListener = clientMessageListener;
    }

    @Override
    public void sendResponse(long msgId, String serverAddress, Object msg) {
        logger.info("RmRpcClient sendResponse " + msg);
        super.sendResponse(msgId, this.connect(serverAddress), msg);
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getCustomerKeys() {
        return this.customerKeys;
    }

    public void setCustomerKeys(String customerKeys) {
        this.customerKeys = customerKeys;
    }

    static {
        tableKeywords = null;
    }

    public class Worker
    implements Runnable {
        RmRpcClient client;

        public Worker(RmRpcClient client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Iterator iterator = RmRpcClient.this.mergeLock;
                synchronized (iterator) {
                    try {
                        RmRpcClient.this.mergeLock.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                RmRpcClient.this.isSending = true;
                for (String address : RmRpcClient.this.rmBasketMap.keySet()) {
                    BlockingQueue basket = (BlockingQueue)RmRpcClient.this.rmBasketMap.get(address);
                    if (basket.isEmpty()) continue;
                    TxcMergeMessage mergeMessage = new TxcMergeMessage();
                    int idx = 0;
                    while (!basket.isEmpty()) {
                        RpcMessage msg = (RpcMessage)basket.poll();
                        if (logger.isDebugEnabled() && msg.getBody() instanceof RegisterMessage) {
                            logger.debug("poll msg:" + msg.getBody());
                        }
                        mergeMessage.msgs.add((TxcMessage)msg.getBody());
                        mergeMessage.msgIds.add(msg.getId());
                        ++idx;
                    }
                    if (idx > 1 && logger.isDebugEnabled()) {
                        logger.debug("msgs:" + idx);
                        for (TxcMessage cm : mergeMessage.msgs) {
                            logger.debug(cm.toString());
                        }
                        StringBuffer sb = new StringBuffer();
                        for (long l : mergeMessage.msgIds) {
                            sb.append("msgid:").append(l).append(";");
                        }
                        sb.append("\n");
                        for (long l : RmRpcClient.this.futures.keySet()) {
                            sb.append("futures:").append(l).append(";");
                        }
                        logger.debug(sb.toString());
                    }
                    try {
                        RmRpcClient.this.sendRequest(this.client.connect(address), mergeMessage);
                    }
                    catch (Exception e) {
                        logger.error("", "txc merge call failed", (Throwable)e);
                    }
                }
                RmRpcClient.this.isSending = false;
            }
        }
    }

    public static final class TxcChannel {
        Channel channel;
        TransactionMode mode;

        public TxcChannel(Channel channel, TransactionMode mode) {
            this.channel = channel;
            this.mode = mode;
        }
    }
}

