/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.RegisterMessage;
import com.taobao.txc.common.message.RegisterResultMessage;
import com.taobao.txc.common.message.ReportStatusMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.common.util.CommandStreamReader;
import com.taobao.txc.resourcemanager.ResourceManager;
import com.taobao.txc.resourcemanager.TxcResourceManagerImpl;
import com.taobao.txc.resourcemanager.limit.ClientLimitationHelper;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import com.taobao.txc.resourcemanager.rt.RtResourceManager;
import com.taobao.txc.rpc.api.TxcClientMessageSender;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

public abstract class TxcBaseResourceManagerImpl
implements ResourceManager {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static HashMap<String, ResourceManager> m_registry = new HashMap();
    private TxcClientMessageSender clientMessageSender;
    private int reportRetryTime = 3;
    private int registerMax = 2;

    protected TxcBaseResourceManagerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static ResourceManager getInstance(String name) {
        if (name == null) {
            throw new TxcException("null ResourceManager class name");
        }
        if (m_registry.get(name) != null) return m_registry.get(name);
        Class<TxcBaseResourceManagerImpl> clazz = TxcBaseResourceManagerImpl.class;
        synchronized (TxcBaseResourceManagerImpl.class) {
            if (m_registry.get(name) != null) return m_registry.get(name);
            try {
                TxcBaseResourceManagerImpl resourceManager = name.compareTo("rt") == 0 ? new RtResourceManager() : (name.compareTo("mt") == 0 ? new MtResourceManager() : (name.compareTo("at") == 0 ? new TxcResourceManagerImpl() : new TxcResourceManagerImpl()));
                m_registry.put(name, resourceManager);
                logger.info(String.format("TxcBaseResourceManagerImpl %s inited.", name));
            }
            catch (Exception e) {
                throw new TxcException("Error happened:" + name);
            }
            return m_registry.get(name);
        }
    }

    @Override
    public int getReportRetryTime() {
        return this.reportRetryTime;
    }

    @Override
    public void setReportRetryTime(int reportRetryTime) {
        this.reportRetryTime = reportRetryTime;
    }

    @Override
    public TxcClientMessageSender getClientMessageSender() {
        return this.clientMessageSender;
    }

    @Override
    public void setClientMessageSender(TxcClientMessageSender clientMessageSender) {
        this.clientMessageSender = clientMessageSender;
    }

    private long register(RegisterMessage registerMessage, int retry) throws TxcException {
        if (TxcContext.inTxcTransaction()) {
            registerMessage.setTranId(TxcXID.getTransactionId(TxcContext.getCurrentXid()));
            try {
                RegisterResultMessage resultMessage = (RegisterResultMessage)this.getClientMessageSender().invoke(registerMessage, 3000L);
                if (logger.isDebugEnabled()) {
                    logger.debug(registerMessage.toString());
                }
                if (resultMessage.getResult() != ResultCode.OK.getValue()) {
                    throw new TxcException(resultMessage.getResult(), resultMessage.getMsg());
                }
                long l = resultMessage.getBranchId();
                return l;
            }
            catch (Throwable th) {
                block8: {
                    logger.error("", "invoke msg failed. " + registerMessage + ",retry:" + retry);
                    if (!(th instanceof TimeoutException) || retry >= this.registerMax) break block8;
                    logger.info("register branch timeout,will retry:" + ++retry);
                    RegisterMessage newRegisterMessage = new RegisterMessage();
                    newRegisterMessage.setKey(registerMessage.getKey());
                    newRegisterMessage.setBusinessKey(registerMessage.getBusinessKey());
                    newRegisterMessage.setCommitMode(registerMessage.getCommitMode());
                    long l = this.register(newRegisterMessage, retry);
                    return l;
                }
                throw new TxcException(th);
            }
        }
        throw new IllegalStateException("current thread is not bind to txc transaction.");
    }

    @Override
    public long register(String key, String businessKey, CommitMode commitMode) throws TxcException {
        RegisterMessage registerMessage = new RegisterMessage();
        registerMessage.setKey(key);
        registerMessage.setBusinessKey(businessKey);
        registerMessage.setCommitMode((byte)commitMode.getValue());
        ClientLimitationHelper.getInstance().handleMessage(registerMessage);
        try {
            return this.register(registerMessage, 1);
        }
        catch (Throwable th) {
            ClientLimitationHelper.getInstance().handleException(registerMessage, th);
            return 0L;
        }
    }

    @Override
    public void reportStatus(long branchId, boolean success, String key, String udata) throws TxcException {
        int retry = this.getReportRetryTime();
        int i = 1;
        while (true) {
            try {
                this.reportStatus(branchId, success, key, udata, i);
            }
            catch (TxcException e) {
                if (i > retry) {
                    logger.error("", "reportStatus failed. branch:" + branchId, (Throwable)e);
                    throw e;
                }
                logger.error("", "reportStatus branch:" + branchId + ", retry:" + i, (Throwable)e);
                ++i;
                continue;
            }
            break;
        }
    }

    private void reportStatus(long branchId, boolean success, String key, String udata, int tryTime) throws TxcException {
        if (TxcContext.inTxcTransaction()) {
            ReportStatusMessage reportStatusMessage = new ReportStatusMessage();
            reportStatusMessage.setBranchId(branchId);
            reportStatusMessage.setSuccess(success);
            reportStatusMessage.setKey(key);
            reportStatusMessage.setTranId(TxcXID.getTransactionId(TxcContext.getCurrentXid()));
            reportStatusMessage.setUdata(udata);
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(reportStatusMessage.toString());
                }
                this.getClientMessageSender().invoke(reportStatusMessage, -1L);
            }
            catch (Throwable th) {
                throw new TxcException(th);
            }
        } else {
            throw new IllegalStateException("current thread is not bind to txc transaction.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanOldTxcLog(Integer cleanOldTxcDays) {
        String logdirstr;
        File logdir;
        String homedir;
        int cleanDays = 7;
        if (cleanOldTxcDays != null) {
            if (cleanOldTxcDays <= 0) {
                return;
            }
            cleanDays = cleanOldTxcDays;
        }
        if (StringUtils.isEmpty((String)(homedir = System.getProperty("user.home")))) {
            homedir = "/home/admin";
        }
        if (!(logdir = new File(logdirstr = homedir + "/logs/txc")).exists()) {
            logger.info("clean log failed. no dir " + logdirstr);
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("find ").append(logdirstr).append(" -mtime +").append(cleanDays);
        sb.append(" -name 'txc*.log.*' -type f -delete");
        sb.append(";");
        sb.append("find ").append(logdirstr).append(" -mtime +").append(cleanDays);
        sb.append(" -name 'txc.*.log*' -type f | while read origfile; do fname=$(basename $origfile); pid=$(echo $fname | cut -d'.' -f2); if [ $(ps -ef|grep java|grep $pid|wc -l) -eq 0 ]; then rm -f $origfile; fi; done");
        CommandStreamReader commandStreamReader = new CommandStreamReader();
        try {
            commandStreamReader.execute(new String[]{"/bin/sh", "-c", sb.toString()}, null);
            String res = commandStreamReader.readContent(CommandStreamReader.StreamType.ERROR_STREAM, 10000L);
            logger.info(String.format("clean log done. cmd:[%s] res:[%s]", sb.toString(), res));
        }
        catch (Exception e) {
            logger.warn("clean log failed. " + e.getMessage());
        }
        finally {
            commandStreamReader.destroy();
        }
    }
}

