/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.BranchCommitMessage;
import com.taobao.txc.common.message.BranchCommitResultMessage;
import com.taobao.txc.common.message.BranchRollbackMessage;
import com.taobao.txc.common.message.BranchRollbackResultMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.resourcemanager.IRmRpcClient;
import com.taobao.txc.resourcemanager.ResourceManager;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import com.taobao.txc.rpc.api.ClientMessageListener;
import java.util.List;

public class TxcRMMessageListener
implements ClientMessageListener {
    private IRmRpcClient rmRpcClient;
    private IRmRpcClient mtRmRpcClient;
    private ResourceManager resourceManager;
    private static final LoggerWrap logger = LoggerInit.logger;
    private MtResourceManager mtResourceManager;

    public MtResourceManager getMtResourceManager() {
        return this.mtResourceManager;
    }

    public void setMtResourceManager(MtResourceManager mtResourceManager) {
        this.mtResourceManager = mtResourceManager;
    }

    @Override
    public void onMessage(long msgId, String serverAddress, Object msg) {
        logger.info("onMessage:" + msg);
        if (Thread.currentThread().getName().startsWith("nio")) {
            logger.error(TxcErrCode.Diagnose.errCode, "onMessage goto nio thread", (Throwable)new RuntimeException("shouldn't in nio thread."));
        }
        if (msg instanceof BranchCommitMessage) {
            this.handleBranchCommit(msgId, serverAddress, msg);
        } else if (msg instanceof BranchRollbackMessage) {
            this.handleBranchRollback(msgId, serverAddress, msg);
        }
    }

    private void handleBranchRollback(long msgId, String serverAddress, Object msg) {
        block20: {
            BranchRollbackMessage rollbackMessage = (BranchRollbackMessage)msg;
            if (logger.isDebugEnabled()) {
                logger.debug("begin branch rollback:" + rollbackMessage);
            }
            BranchRollbackResultMessage resultMessage = new BranchRollbackResultMessage();
            resultMessage.setBranchId(rollbackMessage.getBranchId());
            resultMessage.setTranId(rollbackMessage.getTranId());
            if (logger.isAnalyzeEnabled()) {
                AnalyzeLogger.getInstance().getLastCost();
            }
            try {
                String xid = rollbackMessage.getServerAddr() + ":" + rollbackMessage.getTranId();
                if (this.mtResourceManager != null && this.mtResourceManager.isMtBranch(rollbackMessage.getDbName()) && this.mtRmRpcClient != null) {
                    this.mtResourceManager.branchRollback(xid, rollbackMessage.getBranchId(), rollbackMessage.getDbName(), rollbackMessage.getUdata(), rollbackMessage.getCommitMode());
                    resultMessage.setResult(ResultCode.OK.getValue());
                    try {
                        this.mtRmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
                    }
                    catch (Throwable throwable) {
                        logger.error("", "send response error", throwable);
                    }
                    break block20;
                }
                if (this.resourceManager == null || this.rmRpcClient == null) break block20;
                this.resourceManager.branchRollback(xid, rollbackMessage.getBranchId(), rollbackMessage.getDbName(), rollbackMessage.getUdata(), rollbackMessage.getCommitMode(), rollbackMessage.getIsDelLock());
                resultMessage.setResult(ResultCode.OK.getValue());
                if (logger.isDebugEnabled()) {
                    logger.debug("branch rollback result:" + resultMessage);
                }
                try {
                    this.rmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", rollbackMessage.getServerAddr() + ":" + rollbackMessage.getTranId(), rollbackMessage.getBranchId(), "rollback", resultMessage.getResult(), "1", AnalyzeLogger.getInstance().getLastCost(), "", "");
                    }
                }
                catch (Throwable throwable) {
                    logger.error("", "send successful response error", throwable);
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", rollbackMessage.getServerAddr() + ":" + rollbackMessage.getTranId(), rollbackMessage.getBranchId(), "rollback", resultMessage.getResult(), "0", AnalyzeLogger.getInstance().getLastCost(), "", throwable.getMessage());
                    }
                }
            }
            catch (Exception e) {
                logger.error(TxcErrCode.HandleBranchRollBack.errCode, e.getMessage(), (Throwable)e);
                if (e instanceof TxcException) {
                    resultMessage.setResult(((TxcException)e).getResult());
                } else {
                    resultMessage.setResult(ResultCode.SYSTEMERROR.getValue());
                }
                resultMessage.setMsg(e.getMessage());
                try {
                    if (this.mtResourceManager != null && this.mtResourceManager.isMtBranch(rollbackMessage.getDbName()) && this.mtRmRpcClient != null) {
                        this.mtRmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
                    } else if (this.resourceManager != null && this.rmRpcClient != null) {
                        this.rmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
                    }
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", rollbackMessage.getServerAddr() + ":" + rollbackMessage.getTranId(), rollbackMessage.getBranchId(), "rollback", resultMessage.getResult(), "1", AnalyzeLogger.getInstance().getLastCost(), resultMessage.getMsg(), "");
                    }
                }
                catch (Throwable e2) {
                    logger.error("", "send failed response error", e2);
                    if (!logger.isAnalyzeEnabled()) break block20;
                    logger.analyze("tran.branch.end", rollbackMessage.getServerAddr() + ":" + rollbackMessage.getTranId(), rollbackMessage.getBranchId(), "rollback", resultMessage.getResult(), "0", AnalyzeLogger.getInstance().getLastCost(), resultMessage.getMsg(), e2.getMessage());
                }
            }
        }
    }

    private void handleBranchCommit(long msgId, String serverAddress, Object msg) {
        BranchCommitMessage commitMessage = (BranchCommitMessage)msg;
        List<Long> bids = commitMessage.getBranchIds();
        List<Long> tranids = commitMessage.getTranIds();
        String servAddr = commitMessage.getServerAddr();
        String dbName = commitMessage.getDbName();
        String udata = commitMessage.getUdata();
        byte commitMode = commitMessage.getCommitMode();
        String retrySql = commitMessage.getRetrySql();
        IRmRpcClient thisRmRpcClient = null;
        ResourceManager thisResourceManager = null;
        if (this.mtResourceManager != null && this.mtResourceManager.isMtBranch(dbName) && this.mtRmRpcClient != null) {
            thisRmRpcClient = this.mtRmRpcClient;
            thisResourceManager = this.mtResourceManager;
        } else if (this.resourceManager != null && this.rmRpcClient != null) {
            thisRmRpcClient = this.rmRpcClient;
            thisResourceManager = this.resourceManager;
        } else {
            throw new RuntimeException("branch commit request IRmRpcClient is null!");
        }
        BranchCommitResultMessage resultMessage = new BranchCommitResultMessage();
        resultMessage.setBranchIds(bids);
        resultMessage.setTranIds(tranids);
        try {
            for (int i = 0; i < bids.size(); ++i) {
                Long bid = bids.get(i);
                Long tranid = tranids.get(i);
                String xid = servAddr + ":" + tranid;
                thisResourceManager.branchCommit(xid, bid, dbName, udata, commitMode, retrySql);
            }
            resultMessage.setResult(ResultCode.OK.getValue());
            thisRmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
        }
        catch (Exception e) {
            logger.error(TxcErrCode.HandleBranchCommit.errCode, e.getMessage(), (Throwable)e);
            resultMessage.setResult(ResultCode.SYSTEMERROR.getValue());
            resultMessage.setMsg(e.getMessage());
            thisRmRpcClient.sendResponse(msgId, serverAddress, resultMessage);
        }
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public IRmRpcClient getRmRpcClient() {
        return this.rmRpcClient;
    }

    public void setRmRpcClient(IRmRpcClient rmRpcClient) {
        this.rmRpcClient = rmRpcClient;
    }

    public IRmRpcClient getMtRmRpcClient() {
        return this.mtRmRpcClient;
    }

    public void setMtRmRpcClient(IRmRpcClient mtRmRpcClient) {
        this.mtRmRpcClient = mtRmRpcClient;
    }

    public void init() {
        if (this.rmRpcClient != null) {
            this.rmRpcClient.setClientMessageListener(this);
        }
        if (this.mtRmRpcClient != null) {
            this.mtRmRpcClient.setClientMessageListener(this);
        }
    }
}

