/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.ContextStep2;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.QueryLockMessage;
import com.taobao.txc.common.message.QueryLockResultMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.resourcemanager.TxcBaseResourceManagerImpl;
import com.taobao.txc.resourcemanager.executor.api.ITxcLogManager;
import com.taobao.txc.rpc.impl.RpcClient;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import sun.misc.Signal;
import sun.misc.SignalHandler;

public class TxcResourceManagerImpl
extends TxcBaseResourceManagerImpl {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static Map<String, TxcBranchStatus> currentTaskMap = new ConcurrentHashMap<String, TxcBranchStatus>();
    private static List<ContextStep2> currentTaskCommitedAt = Collections.synchronizedList(new ArrayList());
    private static ScheduledExecutorService timerExecutor = Executors.newScheduledThreadPool(1);
    private ITxcLogManager txcSqlLogManager = null;
    private static ScheduledExecutorService cleanOldLogExecutor = Executors.newSingleThreadScheduledExecutor();
    private static ExecutorService cleanOldLogSignalExecutor = Executors.newSingleThreadExecutor();
    private static int cleanOldLogEventTriggerSeconds = 7200;
    private static final int MAX_KEEP_COMMITED_AT_SIZE = 10000;

    protected TxcResourceManagerImpl() {
    }

    public static TxcResourceManagerImpl getTxcResourceManager() {
        return (TxcResourceManagerImpl)TxcBaseResourceManagerImpl.getInstance("at");
    }

    private Integer getCleanOldTxcDays() {
        String vgroup = RpcClient.getVgroup();
        return TxcConfigHolder.getInstance().getCleanOldUndoLogDays(vgroup);
    }

    public void init() {
        try {
            timerExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        TxcResourceManagerImpl.this.getTxcSqlLogManager().branchCommit(currentTaskCommitedAt);
                    }
                    catch (Throwable e) {
                        logger.error("", "branch commit fail. ", e);
                    }
                }
            }, 10L, 1000L, TimeUnit.MILLISECONDS);
            try {
                Signal.handle(new Signal("USR2"), new SignalHandler(){

                    @Override
                    public void handle(Signal signal) {
                        cleanOldLogSignalExecutor.submit(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                Integer cleanOldTxcDays = TxcResourceManagerImpl.this.getCleanOldTxcDays();
                                logger.info("manually trigger clean old event, days=" + cleanOldTxcDays);
                                TxcResourceManagerImpl.this.cleanOldTxcUndoLog(cleanOldTxcDays);
                                TxcResourceManagerImpl.this.cleanOldTxcLog(cleanOldTxcDays);
                                return null;
                            }
                        });
                    }
                });
            }
            catch (Exception e) {
                logger.warn(String.format("current OS not support signal USR2", e));
            }
            cleanOldLogExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Calendar calendar = Calendar.getInstance();
                    int nowHour = calendar.get(11);
                    if (nowHour >= 0 && nowHour <= 3) {
                        Integer cleanOldTxcDays = TxcResourceManagerImpl.this.getCleanOldTxcDays();
                        logger.info("Scheduled[00:00~04:00] old txc_undo_log cleaning, days=" + cleanOldTxcDays);
                        TxcResourceManagerImpl.this.cleanOldTxcUndoLog(cleanOldTxcDays);
                        TxcResourceManagerImpl.this.cleanOldTxcLog(cleanOldTxcDays);
                    }
                }
            }, 60L, cleanOldLogEventTriggerSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw TxcException.nestedException(e);
        }
    }

    private void cleanOldTxcUndoLog(Integer cleanOldTxcDays) {
        if (this.txcSqlLogManager != null) {
            try {
                this.txcSqlLogManager.cleanOldTxcLog(cleanOldTxcDays);
                logger.info("clean old txclog success.");
            }
            catch (Exception e) {
                logger.error("", "clean old txclog fail. " + e.getMessage());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void branchCommit(String xid, long branchId, String key, String udata, byte commitMode, String retrySql) throws TxcException {
        String branchName = TxcXID.getBranchName(xid, branchId);
        if (currentTaskMap.containsKey(branchName)) {
            throw new TxcException("Branch is working:" + (Object)((Object)currentTaskMap.get(branchName)));
        }
        if (commitMode != CommitMode.COMMIT_RETRY_MODE.getValue() && currentTaskCommitedAt.size() >= 10000) {
            return;
        }
        if (currentTaskMap.put(branchName, TxcBranchStatus.COMMITING) != null) {
            throw new TxcException("Branch is working:" + (Object)((Object)currentTaskMap.get(branchName)));
        }
        try {
            ContextStep2 context = new ContextStep2(xid, branchId, key, udata, commitMode, retrySql, 0);
            switch (context.getCommitMode()) {
                case COMMIT_IN_PHASE1: 
                case COMMIT_IN_PHASE2: {
                    currentTaskCommitedAt.add(context);
                    return;
                }
                case COMMIT_RETRY_MODE: {
                    this.getTxcSqlLogManager().branchCommit(context);
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            throw TxcException.nestedException(e);
        }
        finally {
            currentTaskMap.remove(branchName);
        }
    }

    @Override
    public void branchRollback(String xid, long branchId, String key, String udata, byte commitMode, int isDelKey) throws TxcException {
        String branchName = TxcXID.getBranchName(xid, branchId);
        if (currentTaskMap.containsKey(branchName)) {
            throw new TxcException("Branch is working:" + (Object)((Object)currentTaskMap.get(branchName)));
        }
        if (currentTaskMap.put(branchName, TxcBranchStatus.ROLLBACKING) != null) {
            throw new TxcException("Branch is working:" + (Object)((Object)currentTaskMap.get(branchName)));
        }
        ContextStep2 context = new ContextStep2(xid, branchId, key, udata, commitMode, null, isDelKey);
        try {
            this.getTxcSqlLogManager().branchRollback(context);
        }
        catch (Exception e) {
            throw TxcException.nestedException(e);
        }
        finally {
            currentTaskMap.remove(branchName);
        }
    }

    public static void main(String[] args) {
        System.out.println(TxcBranchStatus.COMMITING.getValue());
        System.out.println(TxcBranchStatus.ROLLBACKING.getValue());
    }

    @Override
    public void reportUdata(String xid, long branchId, String key, String udata, boolean delay) throws TxcException {
    }

    @Override
    public void branchRollback(String xid, long branchId, String key, String udata, byte commitMode) throws TxcException {
    }

    @Override
    public void queryReadLocks(String key, long tranId, String writeKeys) throws TxcException {
        QueryLockMessage queryLockMessage = new QueryLockMessage();
        queryLockMessage.setBusinessKey(writeKeys.toUpperCase());
        queryLockMessage.setKey(key);
        queryLockMessage.setTranId(tranId);
        try {
            QueryLockResultMessage resultMessage = (QueryLockResultMessage)this.getClientMessageSender().invoke(queryLockMessage, 30000L);
            if (resultMessage.getResult() != ResultCode.OK.getValue()) {
                throw new TxcException(resultMessage.getResult(), resultMessage.getMsg());
            }
        }
        catch (Throwable th) {
            throw TxcException.nestedException(th);
        }
    }

    public ITxcLogManager getTxcSqlLogManager() {
        return this.txcSqlLogManager;
    }

    public void setTxcSqlLogManager(ITxcLogManager txcSqlLogManager) {
        this.txcSqlLogManager = txcSqlLogManager;
    }

    static enum TxcBranchStatus {
        COMMITING(1),
        ROLLBACKING(2);

        private int value;

        private TxcBranchStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

